/*
 * Decompiled with CFR 0.152.
 */
package scalaprops;

import java.io.Serializable;
import java.math.BigInteger;
import scala.Char$;
import scala.Int$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scalaprops.F2Polynomial;
import scalaprops.F2Polynomial$;
import scalaprops.Rand;
import scalaprops.TinyMT32$;
import scalaprops.TinyMT32$MutableState$;
import scalaprops.TinyMT32Parameter;

public final class TinyMT32
extends Rand
implements Product,
Serializable {
    private final int st0;
    private final int st1;
    private final int st2;
    private final int st3;
    private final TinyMT32Parameter parameter;

    public static TinyMT32 apply(int n, int n2, int n3, int n4, TinyMT32Parameter tinyMT32Parameter) {
        return TinyMT32$.MODULE$.apply(n, n2, n3, n4, tinyMT32Parameter);
    }

    public static TinyMT32 fromProduct(Product product) {
        return TinyMT32$.MODULE$.fromProduct(product);
    }

    public static TinyMT32 getDefault() {
        return TinyMT32$.MODULE$.getDefault();
    }

    public static TinyMT32 getDefault(int[] nArray) {
        return TinyMT32$.MODULE$.getDefault(nArray);
    }

    public static TinyMT32 getDefault(long l) {
        return TinyMT32$.MODULE$.getDefault(l);
    }

    public static TinyMT32 getDefault(String string) {
        return TinyMT32$.MODULE$.getDefault(string);
    }

    public static TinyMT32[] getDefaultArray(int n, long l, long l2) {
        return TinyMT32$.MODULE$.getDefaultArray(n, l, l2);
    }

    public static TinyMT32[] getDefaultArray(int n, String string, long l) {
        return TinyMT32$.MODULE$.getDefaultArray(n, string, l);
    }

    public static TinyMT32 getThreadLocal(long l) {
        return TinyMT32$.MODULE$.getThreadLocal(l);
    }

    public static TinyMT32 unapply(TinyMT32 tinyMT32) {
        return TinyMT32$.MODULE$.unapply(tinyMT32);
    }

    public TinyMT32(int st0, int st1, int st2, int st3, TinyMT32Parameter parameter) {
        this.st0 = st0;
        this.st1 = st1;
        this.st2 = st2;
        this.st3 = st3;
        this.parameter = parameter;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.st0());
        n = Statics.mix((int)n, (int)this.st1());
        n = Statics.mix((int)n, (int)this.st2());
        n = Statics.mix((int)n, (int)this.st3());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameter()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TinyMT32)) return false;
        TinyMT32 tinyMT32 = (TinyMT32)object;
        if (this.st0() != tinyMT32.st0()) return false;
        if (this.st1() != tinyMT32.st1()) return false;
        if (this.st2() != tinyMT32.st2()) return false;
        if (this.st3() != tinyMT32.st3()) return false;
        TinyMT32Parameter tinyMT32Parameter = this.parameter();
        TinyMT32Parameter tinyMT32Parameter2 = tinyMT32.parameter();
        if (tinyMT32Parameter != null) {
            if (!((Object)tinyMT32Parameter).equals(tinyMT32Parameter2)) return false;
            return true;
        }
        if (tinyMT32Parameter2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TinyMT32;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "TinyMT32";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "st0";
            }
            case 1: {
                return "st1";
            }
            case 2: {
                return "st2";
            }
            case 3: {
                return "st3";
            }
            case 4: {
                return "parameter";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    private int st0() {
        return this.st0;
    }

    private int st1() {
        return this.st1;
    }

    private int st2() {
        return this.st2;
    }

    private int st3() {
        return this.st3;
    }

    private TinyMT32Parameter parameter() {
        return this.parameter;
    }

    private MutableState asMutable() {
        return TinyMT32$MutableState$.MODULE$.apply(this.st0(), this.st1(), this.st2(), this.st3(), this.parameter());
    }

    public TinyMT32(TinyMT32Parameter param) {
        this(0, 0, 0, 0, param);
    }

    public Tuple2<TinyMT32, Object> nextInt() {
        TinyMT32 s = this.nextState();
        return Tuple2$.MODULE$.apply((Object)s, (Object)BoxesRunTime.boxToInteger((int)s.output()));
    }

    public Tuple2<TinyMT32, Object> nextLong() {
        Tuple2<TinyMT32, Object> tuple2 = this.nextInt();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TinyMT32 s0 = (TinyMT32)tuple2._1();
        int x0 = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)s0, (Object)BoxesRunTime.boxToInteger((int)x0));
        TinyMT32 s02 = (TinyMT32)tuple22._1();
        int x02 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        long t = Int$.MODULE$.int2long(x02) << TinyMT32$.scalaprops$TinyMT32$$$INT_SIZE;
        Tuple2<TinyMT32, Object> tuple23 = s02.nextInt();
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        TinyMT32 s1 = (TinyMT32)tuple23._1();
        int x1 = BoxesRunTime.unboxToInt((Object)tuple23._2());
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)s1, (Object)BoxesRunTime.boxToInteger((int)x1));
        TinyMT32 s12 = (TinyMT32)tuple24._1();
        int x12 = BoxesRunTime.unboxToInt((Object)tuple24._2());
        long x2 = t | (long)x12 & TinyMT32$.scalaprops$TinyMT32$$$INT_TO_LONG_MASK;
        return Tuple2$.MODULE$.apply((Object)s12, (Object)BoxesRunTime.boxToLong((long)x2));
    }

    @Override
    public TinyMT32 reseed(long seed) {
        return this.setLongSeed(seed);
    }

    public TinyMT32 setLongSeed(long seed) {
        if (seed >= 0L && seed < TinyMT32$.scalaprops$TinyMT32$$$LONG_LIMIT) {
            return this.setIntSeed((int)seed);
        }
        int[] tmp = new int[]{(int)(seed & 0xFFFFFFFFFFFFFFFFL), (int)(seed >>> TinyMT32$.scalaprops$TinyMT32$$$INT_SIZE)};
        return this.setSeed(tmp);
    }

    public TinyMT32 setSeed(String seed) {
        int[] intSeeds = new int[seed.length()];
        TinyMT32.loop$1(seed, intSeeds, 0);
        return this.setSeed(intSeeds);
    }

    public TinyMT32 setSeed(int[] seeds) {
        int lag = 1;
        int mid = 1;
        int size = 4;
        int i = 0;
        int j = 0;
        int count = 0;
        int r = 0;
        int keyLength = seeds.length;
        int[] status = new int[]{0, this.parameter().mat1(), this.parameter().mat2(), this.parameter().tmat()};
        count = keyLength + 1 > TinyMT32$.scalaprops$TinyMT32$$$MIN_LOOP ? keyLength + 1 : TinyMT32$.scalaprops$TinyMT32$$$MIN_LOOP;
        r = this.iniFunc1(status[0] ^ status[mid % size] ^ status[(size - 1) % size]);
        int n = mid % size;
        status[n] = status[n] + r;
        int n2 = (mid + lag) % size;
        status[n2] = status[n2] + (r += keyLength);
        status[0] = r;
        --count;
        i = 1;
        for (j = 0; j < count && j < keyLength; ++j) {
            r = this.iniFunc1(status[i % size] ^ status[(i + mid) % size] ^ status[(i + size - 1) % size]);
            int n3 = (i + mid) % size;
            status[n3] = status[n3] + r;
            int n4 = (i + mid + lag) % size;
            status[n4] = status[n4] + (r += seeds[j] + i);
            status[i % size] = r;
            i = (i + 1) % size;
        }
        while (j < count) {
            r = this.iniFunc1(status[i % size] ^ status[(i + mid) % size] ^ status[(i + size - 1) % size]);
            int n5 = (i + mid) % size;
            status[n5] = status[n5] + r;
            int n6 = (i + mid + lag) % size;
            status[n6] = status[n6] + (r += i);
            status[i % size] = r;
            i = (i + 1) % size;
            ++j;
        }
        for (j = 0; j < size; ++j) {
            r = this.iniFunc2(status[i % size] + status[(i + mid) % size] + status[(i + size - 1) % size]);
            int n7 = (i + mid) % size;
            status[n7] = status[n7] ^ r;
            int n8 = (i + mid + lag) % size;
            status[n8] = status[n8] ^ (r -= i);
            status[i % size] = r;
            i = (i + 1) % size;
        }
        TinyMT32 x = new TinyMT32(status[0], status[1], status[2], status[3], this.parameter()).periodCertification0();
        return TinyMT32.loop$2(x.asMutable(), 0);
    }

    private int iniFunc1(int x) {
        return (x ^ x >>> TinyMT32$.scalaprops$TinyMT32$$$INITIALIZE_SHIFT) * TinyMT32$.scalaprops$TinyMT32$$$MAGIC_NUMBER1;
    }

    private int iniFunc2(int x) {
        return (x ^ x >>> TinyMT32$.scalaprops$TinyMT32$$$INITIALIZE_SHIFT) * TinyMT32$.scalaprops$TinyMT32$$$MAGIC_NUMBER2;
    }

    @Override
    public TinyMT32 setIntSeed(int seed) {
        int counterMask = 3;
        int[] status = new int[]{seed, this.parameter().mat1(), this.parameter().mat2(), this.parameter().tmat()};
        TinyMT32.loop0$1(counterMask, status, 1);
        TinyMT32 x = new TinyMT32(status[0], status[1], status[2], status[3], this.parameter()).periodCertification0();
        return TinyMT32.loop$3(0, x.asMutable());
    }

    private TinyMT32 periodCertification0() {
        if ((this.st0() & TinyMT32$.scalaprops$TinyMT32$$$MASK) == 0 && this.st1() == 0 && this.st2() == 0 && this.st3() == 0) {
            return new TinyMT32(84, 73, 78, 89, this.parameter());
        }
        return this;
    }

    private TinyMT32 nextState() {
        int x = 0;
        int y = 0;
        y = this.st3();
        x = this.st0() & TinyMT32$.scalaprops$TinyMT32$$$MASK ^ this.st1() ^ this.st2();
        x ^= x << TinyMT32$.scalaprops$TinyMT32$$$SH0;
        y ^= y >>> TinyMT32$.scalaprops$TinyMT32$$$SH0 ^ x;
        int x0 = this.st1();
        int x3 = y;
        int x1 = this.st2() ^ this.parameter().getMat1(y);
        int x2 = x ^ y << TinyMT32$.scalaprops$TinyMT32$$$SH1 ^ this.parameter().getMat2(y);
        return new TinyMT32(x0, x1, x2, x3, this.parameter());
    }

    private int output() {
        int t0 = 0;
        int t1 = 0;
        t0 = this.st3();
        t1 = this.st0() + (this.st2() >>> TinyMT32$.scalaprops$TinyMT32$$$SH8);
        t0 ^= t1;
        return t0 ^= this.parameter().getTmat(t1);
    }

    private float outputFloat() {
        int t0 = 0;
        int t1 = 0;
        t0 = this.st3();
        t1 = this.st0() + (this.st2() >>> TinyMT32$.scalaprops$TinyMT32$$$SH8);
        t0 ^= t1;
        t0 = t0 >>> TinyMT32$.scalaprops$TinyMT32$$$INT_TO_FLOAT_SHIFT ^ this.parameter().getTmatFloat(t1);
        return Float.intBitsToFloat(t0) - 1.0f;
    }

    private TinyMT32 add0(TinyMT32 that) {
        return new TinyMT32(this.st0() ^ that.st0(), this.st1() ^ that.st1(), this.st2() ^ that.st2(), this.st3() ^ that.st3(), this.parameter());
    }

    private TinyMT32 jump(F2Polynomial pol) {
        int degree = pol.degree();
        return TinyMT32.loop$4(pol, degree, 0, this, new TinyMT32(this.parameter()));
    }

    public TinyMT32[] getJumpedArray(int count, long jump) {
        TinyMT32[] tiny = new TinyMT32[count];
        tiny[0] = this;
        F2Polynomial poly = tiny[0].parameter().characteristic();
        BigInteger pow = TinyMT32$.scalaprops$TinyMT32$$$BASIC_JUMP_STEP.multiply(BigInteger.valueOf(jump));
        F2Polynomial jumpPoly = F2Polynomial$.MODULE$.X().powerMod(pow, poly);
        TinyMT32.loop$5(count, tiny, jumpPoly, 1);
        return tiny;
    }

    public Tuple2<TinyMT32, Object> nextDouble() {
        Tuple2<TinyMT32, Object> temp = this.nextLong();
        long x = BoxesRunTime.unboxToLong((Object)temp._2()) >>> TinyMT32$.scalaprops$TinyMT32$$$LONG_TO_DOUBLE_SHIFT | TinyMT32$.scalaprops$TinyMT32$$$LONG_TO_DOUBLE_MASK;
        return Tuple2$.MODULE$.apply(temp._1(), (Object)BoxesRunTime.boxToDouble((double)(Double.longBitsToDouble(x) - 1.0)));
    }

    public Tuple2<TinyMT32, Object> nextFloat() {
        TinyMT32 s = this.nextState();
        return Tuple2$.MODULE$.apply((Object)s, (Object)BoxesRunTime.boxToFloat((float)s.outputFloat()));
    }

    public String getCharacteristic() {
        return this.parameter().characteristic().toString(TinyMT32$.scalaprops$TinyMT32$$$HEXA_DECIMAL_BASE);
    }

    public int getId() {
        return this.parameter().id();
    }

    public int getDelta() {
        return this.parameter().delta();
    }

    public int getWeight() {
        return this.parameter().weight();
    }

    public TinyMT32 copy(int st0, int st1, int st2, int st3, TinyMT32Parameter parameter) {
        return new TinyMT32(st0, st1, st2, st3, parameter);
    }

    public int copy$default$1() {
        return this.st0();
    }

    public int copy$default$2() {
        return this.st1();
    }

    public int copy$default$3() {
        return this.st2();
    }

    public int copy$default$4() {
        return this.st3();
    }

    public TinyMT32Parameter copy$default$5() {
        return this.parameter();
    }

    public int _1() {
        return this.st0();
    }

    public int _2() {
        return this.st1();
    }

    public int _3() {
        return this.st2();
    }

    public int _4() {
        return this.st3();
    }

    public TinyMT32Parameter _5() {
        return this.parameter();
    }

    private static final void loop$1(String seed$1, int[] intSeeds$1, int i) {
        while (i < intSeeds$1.length) {
            intSeeds$1[i] = Char$.MODULE$.char2int(seed$1.charAt(i));
            ++i;
        }
    }

    private static final TinyMT32 loop$2(MutableState z, int i) {
        while (i < TinyMT32$.scalaprops$TinyMT32$$$MIN_LOOP) {
            MutableState mutableState = z.next();
            int n = i + 1;
            z = mutableState;
            i = n;
        }
        return z.asImmutable();
    }

    private static final void loop0$1(int counterMask$1, int[] status$1, int i) {
        while (i < TinyMT32$.scalaprops$TinyMT32$$$MIN_LOOP) {
            int n = i & counterMask$1;
            status$1[n] = status$1[n] ^ i + TinyMT32$.scalaprops$TinyMT32$$$MAGIC_NUMBER3 * (status$1[i - 1 & counterMask$1] ^ status$1[i - 1 & counterMask$1] >>> TinyMT32$.scalaprops$TinyMT32$$$INITIALIZE_SHIFT2);
            ++i;
        }
    }

    private static final TinyMT32 loop$3(int i, MutableState z) {
        while (i < TinyMT32$.scalaprops$TinyMT32$$$MIN_LOOP) {
            int n = i + 1;
            MutableState mutableState = z.next();
            i = n;
            z = mutableState;
        }
        return z.asImmutable();
    }

    private static final TinyMT32 loop$4(F2Polynomial pol$1, int degree$1, int i, TinyMT32 src, TinyMT32 that) {
        while (i <= degree$1) {
            if (pol$1.getCoefficient(i) == 1) {
                int n = i + 1;
                TinyMT32 tinyMT32 = src.nextState();
                TinyMT32 tinyMT322 = that.add0(src);
                i = n;
                src = tinyMT32;
                that = tinyMT322;
                continue;
            }
            int n = i + 1;
            TinyMT32 tinyMT32 = src.nextState();
            i = n;
            src = tinyMT32;
        }
        return that;
    }

    private static final void loop$5(int count$1, TinyMT32[] tiny$1, F2Polynomial jumpPoly$1, int i) {
        while (i < count$1) {
            tiny$1[i] = tiny$1[i - 1].jump(jumpPoly$1);
            ++i;
        }
    }

    public static final class MutableState
    implements Product,
    Serializable {
        private int st0;
        private int st1;
        private int st2;
        private int st3;
        private TinyMT32Parameter param;

        public static MutableState apply(int n, int n2, int n3, int n4, TinyMT32Parameter tinyMT32Parameter) {
            return TinyMT32$MutableState$.MODULE$.apply(n, n2, n3, n4, tinyMT32Parameter);
        }

        public static MutableState fromProduct(Product product) {
            return TinyMT32$MutableState$.MODULE$.fromProduct(product);
        }

        public static MutableState unapply(MutableState mutableState) {
            return TinyMT32$MutableState$.MODULE$.unapply(mutableState);
        }

        public MutableState(int st0, int st1, int st2, int st3, TinyMT32Parameter param) {
            this.st0 = st0;
            this.st1 = st1;
            this.st2 = st2;
            this.st3 = st3;
            this.param = param;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.st0());
            n = Statics.mix((int)n, (int)this.st1());
            n = Statics.mix((int)n, (int)this.st2());
            n = Statics.mix((int)n, (int)this.st3());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.param()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MutableState)) return false;
            MutableState mutableState = (MutableState)object;
            if (this.st0() != mutableState.st0()) return false;
            if (this.st1() != mutableState.st1()) return false;
            if (this.st2() != mutableState.st2()) return false;
            if (this.st3() != mutableState.st3()) return false;
            TinyMT32Parameter tinyMT32Parameter = this.param();
            TinyMT32Parameter tinyMT32Parameter2 = mutableState.param();
            if (tinyMT32Parameter != null) {
                if (!((Object)tinyMT32Parameter).equals(tinyMT32Parameter2)) return false;
                return true;
            }
            if (tinyMT32Parameter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MutableState;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "MutableState";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "st0";
                }
                case 1: {
                    return "st1";
                }
                case 2: {
                    return "st2";
                }
                case 3: {
                    return "st3";
                }
                case 4: {
                    return "param";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int st0() {
            return this.st0;
        }

        public void st0_$eq(int x$1) {
            this.st0 = x$1;
        }

        public int st1() {
            return this.st1;
        }

        public void st1_$eq(int x$1) {
            this.st1 = x$1;
        }

        public int st2() {
            return this.st2;
        }

        public void st2_$eq(int x$1) {
            this.st2 = x$1;
        }

        public int st3() {
            return this.st3;
        }

        public void st3_$eq(int x$1) {
            this.st3 = x$1;
        }

        public TinyMT32Parameter param() {
            return this.param;
        }

        public void param_$eq(TinyMT32Parameter x$1) {
            this.param = x$1;
        }

        public TinyMT32 asImmutable() {
            return new TinyMT32(this.st0(), this.st1(), this.st2(), this.st3(), this.param());
        }

        public MutableState next() {
            int x = 0;
            int y = 0;
            y = this.st3();
            x = this.st0() & TinyMT32$.scalaprops$TinyMT32$$$MASK ^ this.st1() ^ this.st2();
            x ^= x << TinyMT32$.scalaprops$TinyMT32$$$SH0;
            y ^= y >>> TinyMT32$.scalaprops$TinyMT32$$$SH0 ^ x;
            this.st0_$eq(this.st1());
            this.st3_$eq(y);
            this.st1_$eq(this.st2() ^ this.param().getMat1(y));
            this.st2_$eq(x ^ y << TinyMT32$.scalaprops$TinyMT32$$$SH1 ^ this.param().getMat2(y));
            return this;
        }

        public MutableState copy(int st0, int st1, int st2, int st3, TinyMT32Parameter param) {
            return new MutableState(st0, st1, st2, st3, param);
        }

        public int copy$default$1() {
            return this.st0();
        }

        public int copy$default$2() {
            return this.st1();
        }

        public int copy$default$3() {
            return this.st2();
        }

        public int copy$default$4() {
            return this.st3();
        }

        public TinyMT32Parameter copy$default$5() {
            return this.param();
        }

        public int _1() {
            return this.st0();
        }

        public int _2() {
            return this.st1();
        }

        public int _3() {
            return this.st2();
        }

        public int _4() {
            return this.st3();
        }

        public TinyMT32Parameter _5() {
            return this.param();
        }
    }
}

