/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.actor.ActorSystem;
import akka.contrib.persistence.mongodb.MongoSettings$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!B\u0001\u0003\u0011\u0003Y\u0011!D'p]\u001e|7+\u001a;uS:<7O\u0003\u0002\u0004\t\u00059Qn\u001c8h_\u0012\u0014'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u001dA\u0011aB2p]R\u0014\u0018N\u0019\u0006\u0002\u0013\u0005!\u0011m[6b\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011Q\"T8oO>\u001cV\r\u001e;j]\u001e\u001c8CA\u0007\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q#\u0004C\u00011\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u000655!\taG\u0001\u0006CB\u0004H.\u001f\u000b\u00049\u00055\u0004C\u0001\u0007\u001e\r\u0011q!\u0001\u0001\u0010\u0014\u0005u\u0001\u0002\u0002\u0003\u0011\u001e\u0005\u000b\u0007I\u0011A\u0011\u0002\r\r|gNZ5h+\u0005\u0011\u0003CA\u0012*\u001b\u0005!#B\u0001\u0011&\u0015\t1s%\u0001\u0005usB,7/\u00194f\u0015\u0005A\u0013aA2p[&\u0011!\u0006\n\u0002\u0007\u0007>tg-[4\t\u00111j\"\u0011!Q\u0001\n\t\nqaY8oM&<\u0007\u0005C\u0003\u0018;\u0011\u0005a\u0006\u0006\u0002\u001d_!)\u0001%\fa\u0001E!)\u0011'\bC\u0001e\u0005aq/\u001b;i\u001fZ,'O]5eKR\u0011Ad\r\u0005\u0006iA\u0002\rAI\u0001\u0003EfDqAN\u000fC\u0002\u0013\u0005q'\u0001\bJ[BdW-\\3oi\u0006$\u0018n\u001c8\u0016\u0003a\u0002\"!\u000f!\u000f\u0005ir\u0004CA\u001e\u0013\u001b\u0005a$BA\u001f\u000b\u0003\u0019a$o\\8u}%\u0011qHE\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@%!1A)\bQ\u0001\na\nq\"S7qY\u0016lWM\u001c;bi&|g\u000e\t\u0005\b\rv\u0011\r\u0011\"\u00018\u0003!iuN\\4p+JL\u0007B\u0002%\u001eA\u0003%\u0001(A\u0005N_:<w.\u0016:jA!9!*\bb\u0001\n\u0003Y\u0015\u0001\u0003#bi\u0006\u0014\u0017m]3\u0016\u00031\u00032!E'9\u0013\tq%C\u0001\u0004PaRLwN\u001c\u0005\u0007!v\u0001\u000b\u0011\u0002'\u0002\u0013\u0011\u000bG/\u00192bg\u0016\u0004\u0003b\u0002*\u001e\u0005\u0004%\taN\u0001\u0012\u0015>,(O\\1m\u0007>dG.Z2uS>t\u0007B\u0002+\u001eA\u0003%\u0001(\u0001\nK_V\u0014h.\u00197D_2dWm\u0019;j_:\u0004\u0003b\u0002,\u001e\u0005\u0004%\taN\u0001\r\u0015>,(O\\1m\u0013:$W\r\u001f\u0005\u00071v\u0001\u000b\u0011\u0002\u001d\u0002\u001b){WO\u001d8bY&sG-\u001a=!\u0011\u001dQVD1A\u0005\u0002]\n\u0011CS8ve:\fGnU3r\u001dJLe\u000eZ3y\u0011\u0019aV\u0004)A\u0005q\u0005\u0011\"j\\;s]\u0006d7+Z9Oe&sG-\u001a=!\u0011\u001dqVD1A\u0005\u0002]\nqBS8ve:\fG\u000eV1h\u0013:$W\r\u001f\u0005\u0007Av\u0001\u000b\u0011\u0002\u001d\u0002!){WO\u001d8bYR\u000bw-\u00138eKb\u0004\u0003b\u00022\u001e\u0005\u0004%\taN\u0001\u0014\u0015>,(O\\1m/JLG/Z\"p]\u000e,'O\u001c\u0005\u0007Iv\u0001\u000b\u0011\u0002\u001d\u0002)){WO\u001d8bY^\u0013\u0018\u000e^3D_:\u001cWM\u001d8!\u0011\u001d1WD1A\u0005\u0002\u001d\fqBS8ve:\fGn\u0016+j[\u0016|W\u000f^\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\tIV\u0014\u0018\r^5p]*\u0011QNE\u0001\u000bG>t7-\u001e:sK:$\u0018BA8k\u000591\u0015N\\5uK\u0012+(/\u0019;j_:Da!]\u000f!\u0002\u0013A\u0017\u0001\u0005&pkJt\u0017\r\\,US6,w.\u001e;!\u0011\u001d\u0019XD1A\u0005\u0002Q\fABS8ve:\fGNR*z]\u000e,\u0012!\u001e\t\u0003#YL!a\u001e\n\u0003\u000f\t{w\u000e\\3b]\"1\u00110\bQ\u0001\nU\fQBS8ve:\fGNR*z]\u000e\u0004\u0003bB>\u001e\u0005\u0004%\t\u0001^\u0001\u0018\u0015>,(O\\1m\u0003V$x.\\1uS\u000e,\u0006o\u001a:bI\u0016Da!`\u000f!\u0002\u0013)\u0018\u0001\u0007&pkJt\u0017\r\\!vi>l\u0017\r^5d+B<'/\u00193fA!9q0\bb\u0001\n\u00039\u0014aD*oCB\u001c8i\u001c7mK\u000e$\u0018n\u001c8\t\u000f\u0005\rQ\u0004)A\u0005q\u0005\u00012K\\1qg\u000e{G\u000e\\3di&|g\u000e\t\u0005\t\u0003\u000fi\"\u0019!C\u0001o\u0005Q1K\\1qg&sG-\u001a=\t\u000f\u0005-Q\u0004)A\u0005q\u0005Y1K\\1qg&sG-\u001a=!\u0011!\ty!\bb\u0001\n\u00039\u0014!E*oCB\u001cxK]5uK\u000e{gnY3s]\"9\u00111C\u000f!\u0002\u0013A\u0014AE*oCB\u001cxK]5uK\u000e{gnY3s]\u0002B\u0001\"a\u0006\u001e\u0005\u0004%\taZ\u0001\u000e':\f\u0007o],US6,w.\u001e;\t\u000f\u0005mQ\u0004)A\u0005Q\u0006q1K\\1qg^#\u0016.\\3pkR\u0004\u0003\u0002CA\u0010;\t\u0007I\u0011\u0001;\u0002\u0015Ms\u0017\r]:G'ft7\rC\u0004\u0002$u\u0001\u000b\u0011B;\u0002\u0017Ms\u0017\r]:G'ft7\r\t\u0005\t\u0003Oi\"\u0019!C\u0001i\u0006I\"/Z1mi&lW-\u00128bE2,\u0007+\u001a:tSN$XM\\2f\u0011\u001d\tY#\bQ\u0001\nU\f!D]3bYRLW.Z#oC\ndW\rU3sg&\u001cH/\u001a8dK\u0002B\u0001\"a\f\u001e\u0005\u0004%\taN\u0001\u0017e\u0016\fG\u000e^5nK\u000e{G\u000e\\3di&|gNT1nK\"9\u00111G\u000f!\u0002\u0013A\u0014a\u0006:fC2$\u0018.\\3D_2dWm\u0019;j_:t\u0015-\\3!\u0011%\t9$\bb\u0001\n\u0003\tI$\u0001\fsK\u0006dG/[7f\u0007>dG.Z2uS>t7+\u001b>f+\t\tY\u0004E\u0002\u0012\u0003{I1!a\u0010\u0013\u0005\u0011auN\\4\t\u0011\u0005\rS\u0004)A\u0005\u0003w\tqC]3bYRLW.Z\"pY2,7\r^5p]NK'0\u001a\u0011\t\u0011\u0005\u001dSD1A\u0005\u0002]\n!#T3uC\u0012\fG/Y\"pY2,7\r^5p]\"9\u00111J\u000f!\u0002\u0013A\u0014aE'fi\u0006$\u0017\r^1D_2dWm\u0019;j_:\u0004\u0003\u0002CA(;\t\u0007I\u0011\u0001;\u0002;U\u001bX\rT3hC\u000eL(j\\;s]\u0006d7+\u001a:jC2L'0\u0019;j_:Dq!a\u0015\u001eA\u0003%Q/\u0001\u0010Vg\u0016dUmZ1ds*{WO\u001d8bYN+'/[1mSj\fG/[8oA!A\u0011qK\u000fC\u0002\u0013\u0005q'\u0001\nTk\u001a4\u0017\u000e\u001f\"vS2$WM]\"mCN\u001c\bbBA.;\u0001\u0006I\u0001O\u0001\u0014'V4g-\u001b=Ck&dG-\u001a:DY\u0006\u001c8\u000f\t\u0005\t\u0003?j\"\u0019!C\u0001o\u0005y1+\u001e4gSb\u001cV\r]1sCR|'\u000fC\u0004\u0002du\u0001\u000b\u0011\u0002\u001d\u0002!M+hMZ5y'\u0016\u0004\u0018M]1u_J\u0004\u0003\u0002CA4;\t\u0007I\u0011\u0001;\u00025M+hMZ5y\tJ|\u0007/R7qif\u001cu\u000e\u001c7fGRLwN\\:\t\u000f\u0005-T\u0004)A\u0005k\u0006Y2+\u001e4gSb$%o\u001c9F[B$\u0018pQ8mY\u0016\u001cG/[8og\u0002Bq!a\u001c\u001a\u0001\u0004\t\t(\u0001\btsN$X-\\*fiRLgnZ:\u0011\t\u0005M\u0014q\u0010\b\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u0005\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005u\u0014qO\u0001\f\u0003\u000e$xN]*zgR,W.\u0003\u0003\u0002\u0002\u0006\r%\u0001C*fiRLgnZ:\u000b\t\u0005u\u0014q\u000f")
public class MongoSettings {
    private final Config config;
    private final String Implementation;
    private final String MongoUri;
    private final Option<String> Database;
    private final String JournalCollection;
    private final String JournalIndex;
    private final String JournalSeqNrIndex;
    private final String JournalTagIndex;
    private final String JournalWriteConcern;
    private final FiniteDuration JournalWTimeout;
    private final boolean JournalFSync;
    private final boolean JournalAutomaticUpgrade;
    private final String SnapsCollection;
    private final String SnapsIndex;
    private final String SnapsWriteConcern;
    private final FiniteDuration SnapsWTimeout;
    private final boolean SnapsFSync;
    private final boolean realtimeEnablePersistence;
    private final String realtimeCollectionName;
    private final long realtimeCollectionSize;
    private final String MetadataCollection;
    private final boolean UseLegacyJournalSerialization;
    private final String SuffixBuilderClass;
    private final String SuffixSeparator;
    private final boolean SuffixDropEmptyCollections;

    public static MongoSettings apply(ActorSystem.Settings settings) {
        return MongoSettings$.MODULE$.apply(settings);
    }

    public Config config() {
        return this.config;
    }

    public MongoSettings withOverride(Config by) {
        return new MongoSettings(by.withFallback((ConfigMergeable)this.config()));
    }

    public String Implementation() {
        return this.Implementation;
    }

    public String MongoUri() {
        return this.MongoUri;
    }

    public Option<String> Database() {
        return this.Database;
    }

    public String JournalCollection() {
        return this.JournalCollection;
    }

    public String JournalIndex() {
        return this.JournalIndex;
    }

    public String JournalSeqNrIndex() {
        return this.JournalSeqNrIndex;
    }

    public String JournalTagIndex() {
        return this.JournalTagIndex;
    }

    public String JournalWriteConcern() {
        return this.JournalWriteConcern;
    }

    public FiniteDuration JournalWTimeout() {
        return this.JournalWTimeout;
    }

    public boolean JournalFSync() {
        return this.JournalFSync;
    }

    public boolean JournalAutomaticUpgrade() {
        return this.JournalAutomaticUpgrade;
    }

    public String SnapsCollection() {
        return this.SnapsCollection;
    }

    public String SnapsIndex() {
        return this.SnapsIndex;
    }

    public String SnapsWriteConcern() {
        return this.SnapsWriteConcern;
    }

    public FiniteDuration SnapsWTimeout() {
        return this.SnapsWTimeout;
    }

    public boolean SnapsFSync() {
        return this.SnapsFSync;
    }

    public boolean realtimeEnablePersistence() {
        return this.realtimeEnablePersistence;
    }

    public String realtimeCollectionName() {
        return this.realtimeCollectionName;
    }

    public long realtimeCollectionSize() {
        return this.realtimeCollectionSize;
    }

    public String MetadataCollection() {
        return this.MetadataCollection;
    }

    public boolean UseLegacyJournalSerialization() {
        return this.UseLegacyJournalSerialization;
    }

    public String SuffixBuilderClass() {
        return this.SuffixBuilderClass;
    }

    public String SuffixSeparator() {
        return this.SuffixSeparator;
    }

    public boolean SuffixDropEmptyCollections() {
        return this.SuffixDropEmptyCollections;
    }

    public MongoSettings(Config config) {
        String string;
        this.config = config;
        this.Implementation = config.getString("driver");
        Option option = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("mongouri")).toOption();
        if (option instanceof Some) {
            String uri;
            Some some = (Some)option;
            string = uri = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String Urls = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("urls")).asScala()).toList().mkString(",");
            Option Username = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("username")).toOption();
            Option Password = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("password")).toOption();
            String DbName = config.getString("db");
            string = (String)Username.flatMap((Function1 & Serializable & scala.Serializable)user -> Password.map((Function1 & Serializable & scala.Serializable)password -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mongodb://", ":", "@", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, password, Urls, DbName})))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mongodb://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Urls, DbName})));
        } else {
            throw new MatchError((Object)option);
        }
        this.MongoUri = string;
        this.Database = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("database")).toOption();
        this.JournalCollection = config.getString("journal-collection");
        this.JournalIndex = config.getString("journal-index");
        this.JournalSeqNrIndex = config.getString("journal-seq-nr-index");
        this.JournalTagIndex = config.getString("journal-tag-index");
        this.JournalWriteConcern = config.getString("journal-write-concern");
        this.JournalWTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("journal-wtimeout", TimeUnit.MILLISECONDS))).millis();
        this.JournalFSync = config.getBoolean("journal-fsync");
        this.JournalAutomaticUpgrade = config.getBoolean("journal-automatic-upgrade");
        this.SnapsCollection = config.getString("snaps-collection");
        this.SnapsIndex = config.getString("snaps-index");
        this.SnapsWriteConcern = config.getString("snaps-write-concern");
        this.SnapsWTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("snaps-wtimeout", TimeUnit.MILLISECONDS))).millis();
        this.SnapsFSync = config.getBoolean("snaps-fsync");
        this.realtimeEnablePersistence = config.getBoolean("realtime-enable-persistence");
        this.realtimeCollectionName = config.getString("realtime-collection");
        this.realtimeCollectionSize = config.getLong("realtime-collection-size");
        this.MetadataCollection = config.getString("metadata-collection");
        this.UseLegacyJournalSerialization = config.getBoolean("use-legacy-serialization");
        this.SuffixBuilderClass = config.getString("suffix-builder.class");
        this.SuffixSeparator = config.getString("suffix-builder.separator");
        this.SuffixDropEmptyCollections = config.getBoolean("suffix-drop-empty-collections");
    }
}

