/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.actor.DynamicAccess;
import akka.contrib.persistence.mongodb.Bin;
import akka.contrib.persistence.mongodb.BooleanPayload;
import akka.contrib.persistence.mongodb.Bson;
import akka.contrib.persistence.mongodb.DocumentType;
import akka.contrib.persistence.mongodb.FixedPointPayload;
import akka.contrib.persistence.mongodb.FloatingPointPayload;
import akka.contrib.persistence.mongodb.Legacy;
import akka.contrib.persistence.mongodb.Legacy$;
import akka.contrib.persistence.mongodb.Payload;
import akka.contrib.persistence.mongodb.SerializationHelper$;
import akka.contrib.persistence.mongodb.Serialized;
import akka.contrib.persistence.mongodb.Serialized$;
import akka.contrib.persistence.mongodb.StringPayload;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.Tagged;
import akka.serialization.Serialization;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxesRunTime;

public final class Payload$ {
    public static Payload$ MODULE$;

    static {
        new Payload$();
    }

    public <D> Bson<D> bson2payload(D document, Manifest<D> ev, DocumentType<D> dt) {
        return new Bson<D>(document, (Set<String>)Predef$.MODULE$.Set().empty(), dt);
    }

    public StringPayload str2payload(String string) {
        return new StringPayload(string, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public FloatingPointPayload fpnum2payload(double d) {
        return new FloatingPointPayload(d, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public FixedPointPayload fxnum2payload(long l) {
        return new FixedPointPayload(l, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public BooleanPayload bln2payload(boolean bool) {
        return new BooleanPayload(bool, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public Bin bytes2payload(byte[] buf) {
        return new Bin(buf, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public <D> Payload apply(Object payload, Set<String> tags, Serialization ser, Manifest<D> ev, DocumentType<D> dt, DynamicAccess loadClass) {
        return (Payload)SerializationHelper$.MODULE$.withTransportInformation(ser.system(), (Function0 & Serializable & scala.Serializable)() -> {
            Payload payload;
            Object object = payload;
            if (object instanceof Tagged) {
                Tagged tagged = (Tagged)object;
                payload = MODULE$.apply(tagged.payload(), (Set<String>)tagged.tags(), ser, ev, dt, loadClass);
            } else if (object instanceof PersistentRepr) {
                PersistentRepr persistentRepr = (PersistentRepr)object;
                payload = Legacy$.MODULE$.apply(persistentRepr, tags, ser);
            } else {
                Option option = ev.unapply(object);
                if (!option.isEmpty() && option.get() instanceof Object) {
                    payload = new Bson<Object>(object, tags, dt);
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    payload = new Bin(byArray, tags);
                } else if (object instanceof String) {
                    String string = (String)object;
                    payload = new StringPayload(string, tags);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    payload = new FloatingPointPayload(d, tags);
                } else if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    payload = new FixedPointPayload(l, tags);
                } else if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    payload = new BooleanPayload(bl, tags);
                } else if (object instanceof Object) {
                    Object object2 = object;
                    payload = Serialized$.MODULE$.apply(object2, tags, ser, loadClass);
                } else {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type for ", " of ", " is currently unsupported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object, object.getClass()})));
                }
            }
            return payload;
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <D> Payload apply(String hint, Object any, Set<String> tags, Option<String> clazzName, Option<Object> serId, Option<String> serManifest, Serialization evs, Manifest<D> ev, DocumentType<D> dt, DynamicAccess loadClass) {
        void var11_23;
        Tuple2 tuple2 = new Tuple2((Object)hint, any);
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object repr = tuple2._2();
            if ("repr".equals(string) && repr instanceof byte[]) {
                byte[] byArray = (byte[])repr;
                Legacy legacy = new Legacy(byArray, tags, evs);
                return var11_23;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object ser = tuple2._2();
            if ("ser".equals(string) && ser instanceof byte[]) {
                byte[] byArray = (byte[])ser;
                Serialized serialized = new Serialized(byArray, (String)clazzName.getOrElse((Function0 & Serializable & scala.Serializable)() -> Object.class.getName()), tags, serId, serManifest, evs, loadClass, ClassTag$.MODULE$.Nothing());
                return var11_23;
            }
        }
        if (tuple2 != null) {
            Option option;
            String string = (String)tuple2._1();
            Object d = tuple2._2();
            if ("bson".equals(string) && !(option = ev.unapply(d)).isEmpty() && option.get() instanceof Object) {
                Bson<Object> bson = new Bson<Object>(d, tags, dt);
                return var11_23;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object b = tuple2._2();
            if ("bin".equals(string) && b instanceof byte[]) {
                byte[] byArray = (byte[])b;
                Bin bin = new Bin(byArray, tags);
                return var11_23;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object s = tuple2._2();
            if ("s".equals(string) && s instanceof String) {
                String string2 = (String)s;
                StringPayload stringPayload = new StringPayload(string2, tags);
                return var11_23;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object d = tuple2._2();
            if ("d".equals(string) && d instanceof Double) {
                double d2 = BoxesRunTime.unboxToDouble((Object)d);
                FloatingPointPayload floatingPointPayload = new FloatingPointPayload(d2, tags);
                return var11_23;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object l = tuple2._2();
            if ("l".equals(string) && l instanceof Long) {
                long l2 = BoxesRunTime.unboxToLong((Object)l);
                FixedPointPayload fixedPointPayload = new FixedPointPayload(l2, tags);
                return var11_23;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object b = tuple2._2();
            if ("b".equals(string) && b instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)b);
                BooleanPayload booleanPayload = new BooleanPayload(bl, tags);
                return var11_23;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String x = (String)tuple2._1();
        Object y = tuple2._2();
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown hint ", " or type for payload content ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x, y})));
    }

    public <D> Set<String> apply$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private Payload$() {
        MODULE$ = this;
    }
}

