/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.actor.ActorSystem;
import akka.contrib.persistence.mongodb.MongoSettings$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015w!B$I\u0011\u0003\tf!B*I\u0011\u0003!\u0006\"B.\u0002\t\u0003a\u0006\"B/\u0002\t\u0003qf\u0001B*I\u0001\u0001D\u0001\"\u0019\u0003\u0003\u0006\u0004%\tA\u0019\u0005\tY\u0012\u0011\t\u0011)A\u0005G\")1\f\u0002C\u0001[\")q\u000e\u0002C\u0001a\"91\u000f\u0002b\u0001\n\u0003!\bbBA\u0001\t\u0001\u0006I!\u001e\u0005\t\u0003\u0007!!\u0019!C\u0001i\"9\u0011Q\u0001\u0003!\u0002\u0013)\b\"CA\u0004\t\t\u0007I\u0011AA\u0005\u0011!\t\t\u0002\u0002Q\u0001\n\u0005-\u0001\u0002CA\n\t\t\u0007I\u0011\u0001;\t\u000f\u0005UA\u0001)A\u0005k\"A\u0011q\u0003\u0003C\u0002\u0013\u0005A\u000fC\u0004\u0002\u001a\u0011\u0001\u000b\u0011B;\t\u0011\u0005mAA1A\u0005\u0002QDq!!\b\u0005A\u0003%Q\u000f\u0003\u0005\u0002 \u0011\u0011\r\u0011\"\u0001u\u0011\u001d\t\t\u0003\u0002Q\u0001\nUD\u0001\"a\t\u0005\u0005\u0004%\t\u0001\u001e\u0005\b\u0003K!\u0001\u0015!\u0003v\u0011%\t9\u0003\u0002b\u0001\n\u0003\tI\u0003\u0003\u0005\u0002<\u0011\u0001\u000b\u0011BA\u0016\u0011%\ti\u0004\u0002b\u0001\n\u0003\ty\u0004\u0003\u0005\u0002H\u0011\u0001\u000b\u0011BA!\u0011%\tI\u0005\u0002b\u0001\n\u0003\ty\u0004\u0003\u0005\u0002L\u0011\u0001\u000b\u0011BA!\u0011!\ti\u0005\u0002b\u0001\n\u0003!\bbBA(\t\u0001\u0006I!\u001e\u0005\t\u0003#\"!\u0019!C\u0001i\"9\u00111\u000b\u0003!\u0002\u0013)\b\u0002CA+\t\t\u0007I\u0011\u0001;\t\u000f\u0005]C\u0001)A\u0005k\"I\u0011\u0011\f\u0003C\u0002\u0013\u0005\u0011\u0011\u0006\u0005\t\u00037\"\u0001\u0015!\u0003\u0002,!I\u0011Q\f\u0003C\u0002\u0013\u0005\u0011q\b\u0005\t\u0003?\"\u0001\u0015!\u0003\u0002B!I\u0011\u0011\r\u0003C\u0002\u0013\u0005\u0011q\b\u0005\t\u0003G\"\u0001\u0015!\u0003\u0002B!A\u0011Q\r\u0003C\u0002\u0013\u0005A\u000fC\u0004\u0002h\u0011\u0001\u000b\u0011B;\t\u0013\u0005%DA1A\u0005\u0002\u0005-\u0004\u0002CA:\t\u0001\u0006I!!\u001c\t\u0011\u0005UDA1A\u0005\u0002QDq!a\u001e\u0005A\u0003%Q\u000fC\u0005\u0002z\u0011\u0011\r\u0011\"\u0001\u0002@!A\u00111\u0010\u0003!\u0002\u0013\t\t\u0005\u0003\u0005\u0002~\u0011\u0011\r\u0011\"\u0001u\u0011\u001d\ty\b\u0002Q\u0001\nUD\u0001\"!!\u0005\u0005\u0004%\t\u0001\u001e\u0005\b\u0003\u0007#\u0001\u0015!\u0003v\u0011%\t)\t\u0002b\u0001\n\u0003\ty\u0004\u0003\u0005\u0002\b\u0012\u0001\u000b\u0011BA!\u0011%\tI\t\u0002b\u0001\n\u0003\ty\u0004\u0003\u0005\u0002\f\u0012\u0001\u000b\u0011BA!\u0011%\ti\t\u0002b\u0001\n\u0003\ty\t\u0003\u0005\u0002\u0018\u0012\u0001\u000b\u0011BAI\u0011%\tI\n\u0002b\u0001\n\u0003\ty\t\u0003\u0005\u0002\u001c\u0012\u0001\u000b\u0011BAI\u0011%\ti\n\u0002b\u0001\n\u0003\ty\t\u0003\u0005\u0002 \u0012\u0001\u000b\u0011BAI\u0011%\t\t\u000b\u0002b\u0001\n\u0003\ty\t\u0003\u0005\u0002$\u0012\u0001\u000b\u0011BAI\u0011!\t)\u000b\u0002b\u0001\n\u0003!\bbBAT\t\u0001\u0006I!\u001e\u0005\t\u0003S#!\u0019!C\u0001E\"9\u00111\u0016\u0003!\u0002\u0013\u0019\u0017!D'p]\u001e|7+\u001a;uS:<7O\u0003\u0002J\u0015\u00069Qn\u001c8h_\u0012\u0014'BA&M\u0003-\u0001XM]:jgR,gnY3\u000b\u00055s\u0015aB2p]R\u0014\u0018N\u0019\u0006\u0002\u001f\u0006!\u0011m[6b\u0007\u0001\u0001\"AU\u0001\u000e\u0003!\u0013Q\"T8oO>\u001cV\r\u001e;j]\u001e\u001c8CA\u0001V!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!U\u0001\u0006CB\u0004H.\u001f\u000b\u0004?\u00065\u0006C\u0001*\u0005'\t!Q+\u0001\u0004d_:4\u0017nZ\u000b\u0002GB\u0011AM[\u0007\u0002K*\u0011\u0011M\u001a\u0006\u0003O\"\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002S\u0006\u00191m\\7\n\u0005-,'AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0015\u0005}s\u0007\"B1\b\u0001\u0004\u0019\u0017\u0001D<ji\"|e/\u001a:sS\u0012,GCA0r\u0011\u0015\u0011\b\u00021\u0001d\u0003\t\u0011\u00170\u0001\bJ[BdW-\\3oi\u0006$\u0018n\u001c8\u0016\u0003U\u0004\"A^?\u000f\u0005]\\\bC\u0001=X\u001b\u0005I(B\u0001>Q\u0003\u0019a$o\\8u}%\u0011ApV\u0001\u0007!J,G-\u001a4\n\u0005y|(AB*ue&twM\u0003\u0002}/\u0006y\u0011*\u001c9mK6,g\u000e^1uS>t\u0007%\u0001\u0005N_:<w.\u0016:j\u0003%iuN\\4p+JL\u0007%\u0001\u0005ECR\f'-Y:f+\t\tY\u0001\u0005\u0003W\u0003\u001b)\u0018bAA\b/\n1q\n\u001d;j_:\f\u0011\u0002R1uC\n\f7/\u001a\u0011\u0002#){WO\u001d8bY\u000e{G\u000e\\3di&|g.\u0001\nK_V\u0014h.\u00197D_2dWm\u0019;j_:\u0004\u0013\u0001\u0004&pkJt\u0017\r\\%oI\u0016D\u0018!\u0004&pkJt\u0017\r\\%oI\u0016D\b%A\tK_V\u0014h.\u00197TKFt%/\u00138eKb\f!CS8ve:\fGnU3r\u001dJLe\u000eZ3yA\u0005y!j\\;s]\u0006dG+Y4J]\u0012,\u00070\u0001\tK_V\u0014h.\u00197UC\u001eLe\u000eZ3yA\u0005\u0019\"j\\;s]\u0006dwK]5uK\u000e{gnY3s]\u0006!\"j\\;s]\u0006dwK]5uK\u000e{gnY3s]\u0002\nqBS8ve:\fGn\u0016+j[\u0016|W\u000f^\u000b\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0005ekJ\fG/[8o\u0015\r\t)dV\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u001d\u0003_\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\tK_V\u0014h.\u00197X)&lWm\\;uA\u0005a!j\\;s]\u0006dgiU=oGV\u0011\u0011\u0011\t\t\u0004-\u0006\r\u0013bAA#/\n9!i\\8mK\u0006t\u0017!\u0004&pkJt\u0017\r\u001c$Ts:\u001c\u0007%A\fK_V\u0014h.\u00197BkR|W.\u0019;jGV\u0003xM]1eK\u0006A\"j\\;s]\u0006d\u0017)\u001e;p[\u0006$\u0018nY+qOJ\fG-\u001a\u0011\u0002\u001fMs\u0017\r]:D_2dWm\u0019;j_:\f\u0001c\u00158baN\u001cu\u000e\u001c7fGRLwN\u001c\u0011\u0002\u0015Ms\u0017\r]:J]\u0012,\u00070A\u0006T]\u0006\u00048/\u00138eKb\u0004\u0013!E*oCB\u001cxK]5uK\u000e{gnY3s]\u0006\u00112K\\1qg^\u0013\u0018\u000e^3D_:\u001cWM\u001d8!\u00035\u0019f.\u00199t/RKW.Z8vi\u0006q1K\\1qg^#\u0016.\\3pkR\u0004\u0013AC*oCB\u001chiU=oG\u0006Y1K\\1qg\u001a\u001b\u0016P\\2!\u0003e\u0011X-\u00197uS6,WI\\1cY\u0016\u0004VM]:jgR,gnY3\u00025I,\u0017\r\u001c;j[\u0016,e.\u00192mKB+'o]5ti\u0016t7-\u001a\u0011\u0002-I,\u0017\r\u001c;j[\u0016\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016\fqC]3bYRLW.Z\"pY2,7\r^5p]:\u000bW.\u001a\u0011\u0002-I,\u0017\r\u001c;j[\u0016\u001cu\u000e\u001c7fGRLwN\\*ju\u0016,\"!!\u001c\u0011\u0007Y\u000by'C\u0002\u0002r]\u0013A\u0001T8oO\u00069\"/Z1mi&lWmQ8mY\u0016\u001cG/[8o'&TX\rI\u0001\u0013\u001b\u0016$\u0018\rZ1uC\u000e{G\u000e\\3di&|g.A\nNKR\fG-\u0019;b\u0007>dG.Z2uS>t\u0007%A\u000fVg\u0016dUmZ1ds*{WO\u001d8bYN+'/[1mSj\fG/[8o\u0003y)6/\u001a'fO\u0006\u001c\u0017PS8ve:\fGnU3sS\u0006d\u0017N_1uS>t\u0007%\u0001\nTk\u001a4\u0017\u000e\u001f\"vS2$WM]\"mCN\u001c\u0018aE*vM\u001aL\u0007PQ;jY\u0012,'o\u00117bgN\u0004\u0013aD*vM\u001aL\u0007pU3qCJ\fGo\u001c:\u0002!M+hMZ5y'\u0016\u0004\u0018M]1u_J\u0004\u0013AG*vM\u001aL\u0007\u0010\u0012:pa\u0016k\u0007\u000f^=D_2dWm\u0019;j_:\u001c\u0018aG*vM\u001aL\u0007\u0010\u0012:pa\u0016k\u0007\u000f^=D_2dWm\u0019;j_:\u001c\b%\u0001\rTk\u001a4\u0017\u000e_'jOJ\fG/[8o\u0011\u0016\fg/\u001f'pC\u0012\f\u0011dU;gM&DX*[4sCRLwN\u001c%fCZLHj\\1eA\u0005i2+\u001e4gSbl\u0015n\u001a:bi&|g.T1y\u0013:\u001cXM\u001d;SKR\u0014\u00180\u0006\u0002\u0002\u0012B\u0019a+a%\n\u0007\u0005UuKA\u0002J]R\fadU;gM&DX*[4sCRLwN\\'bq&s7/\u001a:u%\u0016$(/\u001f\u0011\u0002;M+hMZ5y\u001b&<'/\u0019;j_:l\u0015\r\u001f#fY\u0016$XMU3uef\fadU;gM&DX*[4sCRLwN\\'bq\u0012+G.\u001a;f%\u0016$(/\u001f\u0011\u0002IM+hMZ5y\u001b&<'/\u0019;j_:l\u0015\r_#naRLX*\u001a;bI\u0006$\u0018MU3uef\fQeU;gM&DX*[4sCRLwN\\'bq\u0016k\u0007\u000f^=NKR\fG-\u0019;b%\u0016$(/\u001f\u0011\u00025M+hMZ5y\u001b&<'/\u0019;j_:\u0004\u0016M]1mY\u0016d\u0017n]7\u00027M+hMZ5y\u001b&<'/\u0019;j_:\u0004\u0016M]1mY\u0016d\u0017n]7!\u0003aiuN\\4p\u001b\u0016$(/[2t\u0005VLG\u000eZ3s\u00072\f7o]\u0001\u001a\u001b>twm\\'fiJL7m\u001d\"vS2$WM]\"mCN\u001c\b%A\bD_2dWm\u0019;j_:\u001c\u0015m\u00195f\u0003A\u0019u\u000e\u001c7fGRLwN\\\"bG\",\u0007\u0005C\u0004\u00020\u000e\u0001\r!!-\u0002\u001dML8\u000f^3n'\u0016$H/\u001b8hgB!\u00111WA`\u001d\u0011\t),a/\u000e\u0005\u0005]&bAA]\u001d\u0006)\u0011m\u0019;pe&!\u0011QXA\\\u0003-\t5\r^8s'f\u001cH/Z7\n\t\u0005\u0005\u00171\u0019\u0002\t'\u0016$H/\u001b8hg*!\u0011QXA\\\u0001")
public class MongoSettings {
    private final Config config;
    private final String Implementation;
    private final String MongoUri;
    private final Option<String> Database;
    private final String JournalCollection;
    private final String JournalIndex;
    private final String JournalSeqNrIndex;
    private final String JournalTagIndex;
    private final String JournalWriteConcern;
    private final FiniteDuration JournalWTimeout;
    private final boolean JournalFSync;
    private final boolean JournalAutomaticUpgrade;
    private final String SnapsCollection;
    private final String SnapsIndex;
    private final String SnapsWriteConcern;
    private final FiniteDuration SnapsWTimeout;
    private final boolean SnapsFSync;
    private final boolean realtimeEnablePersistence;
    private final String realtimeCollectionName;
    private final long realtimeCollectionSize;
    private final String MetadataCollection;
    private final boolean UseLegacyJournalSerialization;
    private final String SuffixBuilderClass;
    private final String SuffixSeparator;
    private final boolean SuffixDropEmptyCollections;
    private final boolean SuffixMigrationHeavyLoad;
    private final int SuffixMigrationMaxInsertRetry;
    private final int SuffixMigrationMaxDeleteRetry;
    private final int SuffixMigrationMaxEmptyMetadataRetry;
    private final int SuffixMigrationParallelism;
    private final String MongoMetricsBuilderClass;
    private final Config CollectionCache;

    public static MongoSettings apply(ActorSystem.Settings settings) {
        return MongoSettings$.MODULE$.apply(settings);
    }

    public Config config() {
        return this.config;
    }

    public MongoSettings withOverride(Config by) {
        return new MongoSettings(by.withFallback((ConfigMergeable)this.config()));
    }

    public String Implementation() {
        return this.Implementation;
    }

    public String MongoUri() {
        return this.MongoUri;
    }

    public Option<String> Database() {
        return this.Database;
    }

    public String JournalCollection() {
        return this.JournalCollection;
    }

    public String JournalIndex() {
        return this.JournalIndex;
    }

    public String JournalSeqNrIndex() {
        return this.JournalSeqNrIndex;
    }

    public String JournalTagIndex() {
        return this.JournalTagIndex;
    }

    public String JournalWriteConcern() {
        return this.JournalWriteConcern;
    }

    public FiniteDuration JournalWTimeout() {
        return this.JournalWTimeout;
    }

    public boolean JournalFSync() {
        return this.JournalFSync;
    }

    public boolean JournalAutomaticUpgrade() {
        return this.JournalAutomaticUpgrade;
    }

    public String SnapsCollection() {
        return this.SnapsCollection;
    }

    public String SnapsIndex() {
        return this.SnapsIndex;
    }

    public String SnapsWriteConcern() {
        return this.SnapsWriteConcern;
    }

    public FiniteDuration SnapsWTimeout() {
        return this.SnapsWTimeout;
    }

    public boolean SnapsFSync() {
        return this.SnapsFSync;
    }

    public boolean realtimeEnablePersistence() {
        return this.realtimeEnablePersistence;
    }

    public String realtimeCollectionName() {
        return this.realtimeCollectionName;
    }

    public long realtimeCollectionSize() {
        return this.realtimeCollectionSize;
    }

    public String MetadataCollection() {
        return this.MetadataCollection;
    }

    public boolean UseLegacyJournalSerialization() {
        return this.UseLegacyJournalSerialization;
    }

    public String SuffixBuilderClass() {
        return this.SuffixBuilderClass;
    }

    public String SuffixSeparator() {
        return this.SuffixSeparator;
    }

    public boolean SuffixDropEmptyCollections() {
        return this.SuffixDropEmptyCollections;
    }

    public boolean SuffixMigrationHeavyLoad() {
        return this.SuffixMigrationHeavyLoad;
    }

    public int SuffixMigrationMaxInsertRetry() {
        return this.SuffixMigrationMaxInsertRetry;
    }

    public int SuffixMigrationMaxDeleteRetry() {
        return this.SuffixMigrationMaxDeleteRetry;
    }

    public int SuffixMigrationMaxEmptyMetadataRetry() {
        return this.SuffixMigrationMaxEmptyMetadataRetry;
    }

    public int SuffixMigrationParallelism() {
        return this.SuffixMigrationParallelism;
    }

    public String MongoMetricsBuilderClass() {
        return this.MongoMetricsBuilderClass;
    }

    public Config CollectionCache() {
        return this.CollectionCache;
    }

    public MongoSettings(Config config) {
        String string;
        this.config = config;
        this.Implementation = config.getString("driver");
        Option option = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("mongouri")).toOption();
        if (option instanceof Some) {
            String uri;
            Some some = (Some)option;
            string = uri = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String Urls = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("urls")).asScala()).toList().mkString(",");
            Option Username = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("username")).toOption();
            Option Password = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("password")).toOption();
            String DbName = config.getString("db");
            string = (String)Username.flatMap((Function1 & Serializable & scala.Serializable)user -> Password.map((Function1 & Serializable & scala.Serializable)password -> new StringBuilder(13).append("mongodb://").append((String)user).append(":").append((String)password).append("@").append(Urls).append("/").append(DbName).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("mongodb://").append(Urls).append("/").append(DbName).toString());
        } else {
            throw new MatchError((Object)option);
        }
        this.MongoUri = string;
        this.Database = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString("database")).toOption();
        this.JournalCollection = config.getString("journal-collection");
        this.JournalIndex = config.getString("journal-index");
        this.JournalSeqNrIndex = config.getString("journal-seq-nr-index");
        this.JournalTagIndex = config.getString("journal-tag-index");
        this.JournalWriteConcern = config.getString("journal-write-concern");
        this.JournalWTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("journal-wtimeout", TimeUnit.MILLISECONDS))).millis();
        this.JournalFSync = config.getBoolean("journal-fsync");
        this.JournalAutomaticUpgrade = config.getBoolean("journal-automatic-upgrade");
        this.SnapsCollection = config.getString("snaps-collection");
        this.SnapsIndex = config.getString("snaps-index");
        this.SnapsWriteConcern = config.getString("snaps-write-concern");
        this.SnapsWTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("snaps-wtimeout", TimeUnit.MILLISECONDS))).millis();
        this.SnapsFSync = config.getBoolean("snaps-fsync");
        this.realtimeEnablePersistence = config.getBoolean("realtime-enable-persistence");
        this.realtimeCollectionName = config.getString("realtime-collection");
        this.realtimeCollectionSize = config.getLong("realtime-collection-size");
        this.MetadataCollection = config.getString("metadata-collection");
        this.UseLegacyJournalSerialization = config.getBoolean("use-legacy-serialization");
        this.SuffixBuilderClass = config.getString("suffix-builder.class");
        this.SuffixSeparator = config.getString("suffix-builder.separator");
        this.SuffixDropEmptyCollections = config.getBoolean("suffix-drop-empty-collections");
        this.SuffixMigrationHeavyLoad = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("suffix-migration.heavy-load"))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        this.SuffixMigrationMaxInsertRetry = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.max-insert-retry"))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        this.SuffixMigrationMaxDeleteRetry = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.max-delete-retry"))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        this.SuffixMigrationMaxEmptyMetadataRetry = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.max-empty-metadata-retry"))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        this.SuffixMigrationParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.parallelism"))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        this.MongoMetricsBuilderClass = config.getString("metrics-builder.class");
        this.CollectionCache = config.getConfig("collection-cache");
    }
}

