/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.actor.ActorSystem;
import akka.contrib.persistence.mongodb.Atom;
import akka.contrib.persistence.mongodb.CanDeserializeJournal;
import akka.contrib.persistence.mongodb.CanSerializeJournal;
import akka.contrib.persistence.mongodb.CanSuffixCollectionNames;
import akka.contrib.persistence.mongodb.Event;
import akka.contrib.persistence.mongodb.IndexSettings;
import akka.contrib.persistence.mongodb.MongoCollectionCache;
import akka.contrib.persistence.mongodb.MongoCollectionCache$;
import akka.contrib.persistence.mongodb.MongoPersistenceDriver$;
import akka.contrib.persistence.mongodb.MongoSettings;
import akka.contrib.persistence.mongodb.MongoSettings$;
import akka.contrib.persistence.mongodb.ReflectiveLookupExtension;
import akka.contrib.persistence.mongodb.ReflectiveLookupExtension$;
import akka.contrib.persistence.mongodb.WithMongoPersistencePluginDispatcher;
import akka.dispatch.MessageDispatcher;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005x!\u0002;v\u0011\u0003qhaBA\u0001k\"\u0005\u00111\u0001\u0005\b\u0003#\tA\u0011AA\n\r%\t)\"\u0001I\u0001$C\t9bB\u0004\u0002>\u0006A\t)a-\u0007\u000f\u00055\u0016\u0001#!\u00020\"9\u0011\u0011C\u0003\u0005\u0002\u0005E\u0006\"CA\u001a\u000b\u0005\u0005I\u0011IA\u001b\u0011%\t9%BA\u0001\n\u0003\tI\u0005C\u0005\u0002R\u0015\t\t\u0011\"\u0001\u00026\"I\u0011qL\u0003\u0002\u0002\u0013\u0005\u0013\u0011\r\u0005\n\u0003_*\u0011\u0011!C\u0001\u0003sC\u0011\"a\u001f\u0006\u0003\u0003%\t%! \t\u0013\u0005}T!!A\u0005B\u0005\u0005\u0005\"CAB\u000b\u0005\u0005I\u0011BAC\u000f\u001d\ty,\u0001EA\u0003c1q!a\u0007\u0002\u0011\u0003\u000bi\u0002C\u0004\u0002\u0012A!\t!a\f\t\u0013\u0005M\u0002#!A\u0005B\u0005U\u0002\"CA$!\u0005\u0005I\u0011AA%\u0011%\t\t\u0006EA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002`A\t\t\u0011\"\u0011\u0002b!I\u0011q\u000e\t\u0002\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003w\u0002\u0012\u0011!C!\u0003{B\u0011\"a \u0011\u0003\u0003%\t%!!\t\u0013\u0005\r\u0005#!A\u0005\n\u0005\u0015uaBAa\u0003!\u0005\u00151\u0013\u0004\b\u0003\u001b\u000b\u0001\u0012QAH\u0011\u001d\t\tb\u0007C\u0001\u0003#C\u0011\"a\r\u001c\u0003\u0003%\t%!\u000e\t\u0013\u0005\u001d3$!A\u0005\u0002\u0005%\u0003\"CA)7\u0005\u0005I\u0011AAK\u0011%\tyfGA\u0001\n\u0003\n\t\u0007C\u0005\u0002pm\t\t\u0011\"\u0001\u0002\u001a\"I\u00111P\u000e\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u007fZ\u0012\u0011!C!\u0003\u0003C\u0011\"a!\u001c\u0003\u0003%I!!\"\b\u000f\u0005\r\u0017\u0001#!\u0002$\u001a9\u0011QT\u0001\t\u0002\u0006}\u0005bBA\tM\u0011\u0005\u0011\u0011\u0015\u0005\n\u0003g1\u0013\u0011!C!\u0003kA\u0011\"a\u0012'\u0003\u0003%\t!!\u0013\t\u0013\u0005Ec%!A\u0005\u0002\u0005\u0015\u0006\"CA0M\u0005\u0005I\u0011IA1\u0011%\tyGJA\u0001\n\u0003\tI\u000bC\u0005\u0002|\u0019\n\t\u0011\"\u0011\u0002~!I\u0011q\u0010\u0014\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u00073\u0013\u0011!C\u0005\u0003\u000bCq!!2\u0002\t\u0007\t9MB\u0004\u0002\u0002U\f\t!!9\t\u0015\u0005%\u0018G!A!\u0002\u0013\tY\u000f\u0003\u0006\u0002xF\u0012\t\u0011)A\u0005\u0003sDq!!\u00052\t\u0003\u0011Y\u0001B\u0004\u0003\u0014E\u0012\tA!\u0006\u0005\u000f\tu\u0011G!\u0001\u0003\u0016!I!qD\u0019C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0005C\t\u0004\u0015!\u0003\u00028!I!1E\u0019C\u0002\u0013E!Q\u0005\u0005\t\u0005o\t\u0004\u0015!\u0003\u0003(!I!\u0011H\u0019C\u0002\u0013\r!1\b\u0005\t\u0005{\t\u0004\u0015!\u0003\u0002l\"Q!qH\u0019\t\u0006\u0004%\tA!\u0011\t\u0011\u0005%\u0014G\"\u0001v\u0005\u0013B\u0001B!\u001a2\r\u0003)(q\r\u0005\t\u0005_\nd\u0011A;\u0003r!A!\u0011P\u0019\u0007\u0002U\u0014Y\b\u0003\u0005\u0003$F2\t!\u001eBS\u0011%\u0011i+\rb\u0001\n\u0013\u0011y\u000b\u0003\u0005\u0003>F\u0002\u000b\u0011\u0002BY\u0011!\u0011y,\rQ\u0005\n\t\u0005\u0007\u0002\u0003Bdc\u0001&IA!3\t\u0011\t=\u0017\u0007)C\u0005\u0005#D\u0001B!82\t\u0003)(q\u001c\u0005\t\u0005G\fD\u0011A;\u0003f\"A!\u0011^\u0019\u0005\u0002U\u0014Y\u000f\u0003\u0005\u0003pF\"\t!\u001eBy\u0011-\u0011)0\rEC\u0002\u0013\u0005QOa>\t\u0011\rE\u0011\u0007)A\u0005\u0007'A\u0001b!\u00072\t\u0003)81\u0004\u0005\t\u00073\tD\u0011A;\u0004\u001e!A1QE\u0019\u0005\u0002U\u001c9\u0003\u0003\u0005\u0004,E\u0002\u000b\u0011BB\n\u0011!\u0019i#\rC\u0001k\u000em\u0001\u0002CB\u0017c\u0011\u0005Qoa\f\t\u0011\r]\u0012\u0007\"\u0001v\u0007sA\u0001b!\u00102A\u0003%11\u0003\u0005\t\u0007\u007f\tD\u0011A;\u0004\u001c!Q1\u0011I\u0019C\u0002\u0013\u0005Qoa\u0011\t\u0011\rE\u0013\u0007)A\u0005\u0007\u000bB\u0001ba\u00152A\u0003%11\u0003\u0005\t\u0007+\nD\u0011A;\u0004X!911L\u0019\u0005\u0002\ru\u0003bBB0c\u0011\u00051\u0011\r\u0005\b\u0007K\nD\u0011AB4\u0011\u001d\u0019I'\rC\u0001\u0007OBqaa\u001b2\t\u0003\u0019i\u0007C\u0004\u0004tE\"\ta!\u001e\t\u000f\r\r\u0015\u0007\"\u0001\u0004^!91QQ\u0019\u0005\u0002\r\u001d\u0004bBBDc\u0011\u00051q\r\u0005\b\u0007\u0013\u000bD\u0011AB4\u0011\u001d\u0019Y)\rC\u0001\u0007OBqa!$2\t\u0003\u0019i\u0007C\u0004\u0004\u0010F\"\ta!\u001e\t\u000f\rE\u0015\u0007\"\u0001\u0004^!911S\u0019\u0005\u0002\ru\u0003bBBKc\u0011\u00051q\r\u0005\b\u0007/\u000bD\u0011ABM\u0011\u001d\u0019\t+\rC\u0001\u0007OBqaa)2\t\u0003\u00199\u0007C\u0004\u0004&F\"\ta!\u0018\t\u000f\r\u001d\u0016\u0007\"\u0001\u0004b!91\u0011V\u0019\u0005\u0002\r\u001d\u0004bBBVc\u0011\u00051Q\f\u0005\b\u0007[\u000bD\u0011ABX\u0011\u001d\u0019I-\rC\u0001\u0007\u0017\fa#T8oO>\u0004VM]:jgR,gnY3Ee&4XM\u001d\u0006\u0003m^\fq!\\8oO>$'M\u0003\u0002ys\u0006Y\u0001/\u001a:tSN$XM\\2f\u0015\tQ80A\u0004d_:$(/\u001b2\u000b\u0003q\fA!Y6lC\u000e\u0001\u0001CA@\u0002\u001b\u0005)(AF'p]\u001e|\u0007+\u001a:tSN$XM\\2f\tJLg/\u001a:\u0014\u0007\u0005\t)\u0001\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\t\tY!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0010\u0005%!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002}\nYqK]5uKN\u000bg-\u001a;z'\r\u0019\u0011QA\u0015\u0006\u0007AYb%\u0002\u0002\r\u0003\u000e\\gn\\<mK\u0012<W\rZ\n\n!\u0005\u0015\u0011qDA\u0012\u0003S\u00012!!\t\u0004\u001b\u0005\t\u0001\u0003BA\u0004\u0003KIA!a\n\u0002\n\t9\u0001K]8ek\u000e$\b\u0003BA\u0004\u0003WIA!!\f\u0002\n\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011\u0007\t\u0004\u0003C\u0001\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00028A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012\u0001\u00027b]\u001eT!!!\u0011\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\nYD\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0017\u0002B!a\u0002\u0002N%!\u0011qJA\u0005\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)&a\u0017\u0011\t\u0005\u001d\u0011qK\u0005\u0005\u00033\nIAA\u0002B]fD\u0011\"!\u0018\u0015\u0003\u0003\u0005\r!a\u0013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0007\u0005\u0004\u0002f\u0005-\u0014QK\u0007\u0003\u0003ORA!!\u001b\u0002\n\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002t\u0005e\u0004\u0003BA\u0004\u0003kJA!a\u001e\u0002\n\t9!i\\8mK\u0006t\u0007\"CA/-\u0005\u0005\t\u0019AA+\u0003!A\u0017m\u001d5D_\u0012,GCAA&\u0003!!xn\u0015;sS:<GCAA\u001c\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u001d\u0005\u0003BA\u001d\u0003\u0013KA!a#\u0002<\t1qJ\u00196fGR\u0014\u0011BS8ve:\fG.\u001a3\u0014\u0013m\t)!a\b\u0002$\u0005%BCAAJ!\r\t\tc\u0007\u000b\u0005\u0003+\n9\nC\u0005\u0002^}\t\t\u00111\u0001\u0002LQ!\u00111OAN\u0011%\ti&IA\u0001\u0002\u0004\t)FA\nSKBd\u0017nY1BG.twn\u001e7fI\u001e,GmE\u0005'\u0003\u000b\ty\"a\t\u0002*Q\u0011\u00111\u0015\t\u0004\u0003C1C\u0003BA+\u0003OC\u0011\"!\u0018+\u0003\u0003\u0005\r!a\u0013\u0015\t\u0005M\u00141\u0016\u0005\n\u0003;b\u0013\u0011!a\u0001\u0003+\u0012a\"\u00168bG.twn\u001e7fI\u001e,GmE\u0005\u0006\u0003\u000b\ty\"a\t\u0002*Q\u0011\u00111\u0017\t\u0004\u0003C)A\u0003BA+\u0003oC\u0011\"!\u0018\n\u0003\u0003\u0005\r!a\u0013\u0015\t\u0005M\u00141\u0018\u0005\n\u0003;Z\u0011\u0011!a\u0001\u0003+\na\"\u00168bG.twn\u001e7fI\u001e,G-\u0001\u0007BG.twn\u001e7fI\u001e,G-A\u0005K_V\u0014h.\u00197fI\u0006\u0019\"+\u001a9mS\u000e\f\u0017iY6o_^dW\rZ4fI\u0006\u00112\u000f\u001e:j]\u001e\u0014tK]5uKN\u000bg-\u001a;z)\u0011\ty\"!3\t\u000f\u0005-\u0007\u00071\u0001\u0002N\u0006QaM]8n\u0007>tg-[4\u0011\t\u0005=\u0017Q\u001c\b\u0005\u0003#\fI\u000e\u0005\u0003\u0002T\u0006%QBAAk\u0015\r\t9.`\u0001\u0007yI|w\u000e\u001e \n\t\u0005m\u0017\u0011B\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\u001c\u0006\u0005\u00037\fIaE\u00022\u0003G\u00042a`As\u0013\r\t9/\u001e\u0002%/&$\b.T8oO>\u0004VM]:jgR,gnY3QYV<\u0017N\u001c#jgB\fGo\u00195fe\u0006\u0011\u0011m\u001d\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011_>\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005U\u0018q\u001e\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003w\u00149!\u0004\u0002\u0002~*!\u0011q_A\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u0011QL\b/Z:bM\u0016T!A!\u0002\u0002\u0007\r|W.\u0003\u0003\u0003\n\u0005u(AB\"p]\u001aLw\r\u0006\u0004\u0003\u000e\t=!\u0011\u0003\t\u0003\u007fFBq!!;5\u0001\u0004\tY\u000fC\u0004\u0002xR\u0002\r!!?\u0003\u0003\r\u000bBAa\u0006\u0002VA!\u0011q\u0001B\r\u0013\u0011\u0011Y\"!\u0003\u0003\u000f9{G\u000f[5oO\n\tA)A\bE\u000b\u001a\u000bU\u000b\u0014+`\t\n{f*Q'F\u0003A!UIR!V\u0019R{FIQ0O\u00036+\u0005%\u0001\u0004m_\u001e<WM]\u000b\u0003\u0005O\u0001BA!\u000b\u000345\u0011!1\u0006\u0006\u0005\u0005[\u0011y#A\u0003tY\u001a$$N\u0003\u0002\u00032\u0005\u0019qN]4\n\t\tU\"1\u0006\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Y\u0011m\u0019;peNK8\u000f^3n+\t\tY/\u0001\u0007bGR|'oU=ti\u0016l\u0007%\u0001\u0005tKR$\u0018N\\4t+\t\u0011\u0019\u0005E\u0002\u0000\u0005\u000bJ1Aa\u0012v\u00055iuN\\4p'\u0016$H/\u001b8hgR!!1\nB1)\u0011\u0011iE!\u0015\u0011\u0007\t=S'D\u00012\u0011\u001d\u0011\u0019F\u0010a\u0002\u0005+\n!!Z2\u0011\t\t]#QL\u0007\u0003\u00053RAAa\u0017\u0002\n\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t}#\u0011\f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDqAa\u0019?\u0001\u0004\ti-\u0001\u0003oC6,\u0017\u0001E3ogV\u0014XmQ8mY\u0016\u001cG/[8o)\u0011\u0011IG!\u001c\u0015\t\t5#1\u000e\u0005\b\u0005'z\u00049\u0001B+\u0011\u001d\u0011\u0019g\u0010a\u0001\u0003\u001b\f\u0001cY1qa\u0016$7i\u001c7mK\u000e$\u0018n\u001c8\u0015\t\tM$q\u000f\u000b\u0005\u0005\u001b\u0012)\bC\u0004\u0003T\u0001\u0003\u001dA!\u0016\t\u000f\t\r\u0004\t1\u0001\u0002N\u0006YQM\\:ve\u0016Le\u000eZ3y))\u0011iHa\"\u0003\f\n=%1\u0013\u000b\u0005\u0005\u007f\u0012)\t\u0005\u0005\u0002\b\t\u0005%Q\nB'\u0013\u0011\u0011\u0019)!\u0003\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002B*\u0003\u0002\u000f!Q\u000b\u0005\b\u0005\u0013\u000b\u0005\u0019AAg\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0003\u000e\u0006\u0003\r!a\u001d\u0002\rUt\u0017.];f\u0011\u001d\u0011\t*\u0011a\u0001\u0003g\naa\u001d9beN,\u0007b\u0002BK\u0003\u0002\u0007!qS\u0001\u0007M&,G\u000eZ:\u0011\r\u0005\u001d!\u0011\u0014BO\u0013\u0011\u0011Y*!\u0003\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0005\u0002\b\t}\u0015QZA&\u0013\u0011\u0011\t+!\u0003\u0003\rQ+\b\u000f\\33\u0003A\u0019Gn\\:f\u0007>tg.Z2uS>t7\u000f\u0006\u0002\u0003(B!\u0011q\u0001BU\u0013\u0011\u0011Y+!\u0003\u0003\tUs\u0017\u000e^\u0001 G\u0006t7+\u001e4gSb\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016\u001c()^5mI\u0016\u0014XC\u0001BY!\u0019\t9Aa-\u00038&!!QWA\u0005\u0005\u0019y\u0005\u000f^5p]B\u0019qP!/\n\u0007\tmVO\u0001\rDC:\u001cVO\u001a4jq\u000e{G\u000e\\3di&|gNT1nKN\f\u0001eY1o'V4g-\u001b=D_2dWm\u0019;j_:t\u0015-\\3t\u0005VLG\u000eZ3sA\u0005Qr-\u001a;Tk\u001a4\u0017\u000e\u001f$s_6\u0004VM]:jgR,gnY3JIR!\u0011Q\u001aBb\u0011\u001d\u0011)-\u0012a\u0001\u0003\u001b\fQ\u0002]3sg&\u001cH/\u001a8dK&#\u0017a\u0006<bY&$\u0017\r^3N_:<wn\u00115be\u0006\u001cG/\u001a:t)\u0011\tiMa3\t\u000f\t5g\t1\u0001\u0002N\u0006)\u0011N\u001c9vi\u0006\u0011\u0012\r\u001d9f]\u0012\u001cVO\u001a4jqR{g*Y7f)\u0011\u0011\u0019N!7\u0015\t\u00055'Q\u001b\u0005\b\u0005/<\u0005\u0019AAg\u0003\u0019\u0019XO\u001a4jq\"9!1\\$A\u0002\u00055\u0017A\u00048b[\u0016LenU3ui&twm]\u0001\u0019O\u0016$(j\\;s]\u0006d7i\u001c7mK\u000e$\u0018n\u001c8OC6,G\u0003BAg\u0005CDqA!2I\u0001\u0004\ti-\u0001\fhKR\u001cf.\u00199t\u0007>dG.Z2uS>tg*Y7f)\u0011\tiMa:\t\u000f\t\u0015\u0017\n1\u0001\u0002N\u0006Qq-\u001a;K_V\u0014h.\u00197\u0015\t\t5#Q\u001e\u0005\b\u0005\u000bT\u0005\u0019AAg\u0003!9W\r^*oCB\u001cH\u0003\u0002B'\u0005gDqA!2L\u0001\u0004\ti-A\u0004j]\u0012,\u00070Z:\u0016\u0005\te\bC\u0002B~\u0007\u000b\u0019YA\u0004\u0003\u0003~\u000e\u0005a\u0002BAj\u0005\u007fL!!a\u0003\n\t\r\r\u0011\u0011B\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00199a!\u0003\u0003\u0007M+\u0017O\u0003\u0003\u0004\u0004\u0005%\u0001cA@\u0004\u000e%\u00191qB;\u0003\u001b%sG-\u001a=TKR$\u0018N\\4t\u00031Qw.\u001e:oC2\u001c\u0015m\u00195f!\u0015y8Q\u0003B'\u0013\r\u00199\"\u001e\u0002\u0015\u001b>twm\\\"pY2,7\r^5p]\u000e\u000b7\r[3\u0002\u000f)|WO\u001d8bYV\u0011!Q\n\u000b\u0005\u0007?\u0019\u0019\u0003\u0006\u0003\u0003N\r\u0005\u0002b\u0002B*\u001f\u0002\u000f!Q\u000b\u0005\b\u0005\u000b|\u0005\u0019AAg\u0003Q\u0011X-\\8wK*{WO\u001d8bY&s7)Y2iKR!!qUB\u0015\u0011\u001d\u0011)\r\u0015a\u0001\u0003\u001b\f!b\u001d8baN\u001c\u0015m\u00195f\u0003\u0015\u0019h.\u00199t)\u0011\u0019\td!\u000e\u0015\t\t531\u0007\u0005\b\u0005'\u001a\u00069\u0001B+\u0011\u001d\u0011)m\u0015a\u0001\u0003\u001b\f!C]3n_Z,7K\\1qg&s7)Y2iKR!!qUB\u001e\u0011\u001d\u0011)\r\u0016a\u0001\u0003\u001b\fQB]3bYRLW.Z\"bG\",\u0017\u0001\u0003:fC2$\u0018.\\3\u0002'E,XM]=TS\u0012,G)[:qCR\u001c\u0007.\u001a:\u0016\u0005\r\u0015\u0003\u0003BB$\u0007\u001bj!a!\u0013\u000b\u0007\r-30\u0001\u0005eSN\u0004\u0018\r^2i\u0013\u0011\u0019ye!\u0013\u0003#5+7o]1hK\u0012K7\u000f]1uG\",'/\u0001\u000brk\u0016\u0014\u0018pU5eK\u0012K7\u000f]1uG\",'\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u00115,G/\u00193bi\u0006$BA!\u0014\u0004Z!9!1\u000b.A\u0004\tU\u0013AG;tKN+hMZ5yK\u0012\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016\u001cXCAA:\u00031!\u0017\r^1cCN,g*Y7f+\t\u0019\u0019\u0007\u0005\u0004\u0002\b\tM\u0016QZ\u0001\u0014g:\f\u0007o]\"pY2,7\r^5p]:\u000bW.Z\u000b\u0003\u0003\u001b\fab\u001d8baNLe\u000eZ3y\u001d\u0006lW-\u0001\tt]\u0006\u00048o\u0016:ji\u0016\u001c\u0016MZ3usV\u00111q\u000e\t\u0004\u0007c\u001aaBA@\u0001\u00035\u0019h.\u00199t/RKW.Z8viV\u00111q\u000f\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)!1Q\u0010B-\u0003!!WO]1uS>t\u0017\u0002BBA\u0007w\u0012aBR5oSR,G)\u001e:bi&|g.\u0001\u0006t]\u0006\u00048OR:z]\u000e\fQC[8ve:\fGnQ8mY\u0016\u001cG/[8o\u001d\u0006lW-\u0001\tk_V\u0014h.\u00197J]\u0012,\u0007PT1nK\u0006)\"n\\;s]\u0006d7+Z9Oe&sG-\u001a=OC6,\u0017a\u00056pkJt\u0017\r\u001c+bO&sG-\u001a=OC6,\u0017A\u00056pkJt\u0017\r\\,sSR,7+\u00194fif\fqB[8ve:\fGn\u0016+j[\u0016|W\u000f^\u0001\rU>,(O\\1m\rNLhnY\u0001\u001ae\u0016\fG\u000e^5nK\u0016s\u0017M\u00197f!\u0016\u00148/[:uK:\u001cW-\u0001\fsK\u0006dG/[7f\u0007>dG.Z2uS>tg*Y7f\u0003Y\u0011X-\u00197uS6,7i\u001c7mK\u000e$\u0018n\u001c8TSj,WCABN!\u0011\t9a!(\n\t\r}\u0015\u0011\u0002\u0002\u0005\u0019>tw-\u0001\fnKR\fG-\u0019;b\u0007>dG.Z2uS>tg*Y7f\u0003!iwN\\4p+JL\u0017AF;tK2+w-Y2z'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u00021M,hMZ5y\u0005VLG\u000eZ3s\u00072\f7o](qi&|g.A\btk\u001a4\u0017\u000e_*fa\u0006\u0014\u0018\r^8s\u0003=\u0019XO\u001a4jq\u0012\u0013x\u000e]#naRL\u0018A\u00053fg\u0016\u0014\u0018.\u00197ju\u0016Tu.\u001e:oC2$Ba!-\u0004FR!11WB]!\ry8QW\u0005\u0004\u0007o+(!B#wK:$\bbBB^e\u0002\u000f1QX\u0001\u0003KZ\u0004Ra`B`\u0007\u0007L1a!1v\u0005U\u0019\u0015M\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016Tu.\u001e:oC2\u00042Aa\u00147\u0011\u001d\u00199M\u001da\u0001\u0007\u0007\f1\u0001\u001a2p\u0003A\u0019XM]5bY&TXMS8ve:\fG\u000e\u0006\u0003\u0004N\u000e]G\u0003BBb\u0007\u001fDqaa/t\u0001\b\u0019\t\u000eE\u0003\u0000\u0007'\u001c\u0019-C\u0002\u0004VV\u00141cQ1o'\u0016\u0014\u0018.\u00197ju\u0016Tu.\u001e:oC2Dqa!7t\u0001\u0004\u0019Y.\u0001\u0002boB\u0019qp!8\n\u0007\r}WO\u0001\u0003Bi>l\u0007")
public abstract class MongoPersistenceDriver
extends WithMongoPersistencePluginDispatcher {
    private MongoSettings settings;
    private Seq<IndexSettings> indexes;
    private final ActorSystem as;
    private final Config config;
    private final String DEFAULT_DB_NAME;
    private final Logger logger;
    private final ActorSystem actorSystem;
    private final Option<CanSuffixCollectionNames> canSuffixCollectionNamesBuilder;
    private final MongoCollectionCache<Object> journalCache;
    private final MongoCollectionCache<Object> snapsCache;
    private final MongoCollectionCache<Object> realtimeCache;
    private final MessageDispatcher querySideDispatcher;
    private final MongoCollectionCache<Object> metadataCache;
    private volatile byte bitmap$0;

    public static WriteSafety string2WriteSafety(String string) {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(string);
    }

    public String DEFAULT_DB_NAME() {
        return this.DEFAULT_DB_NAME;
    }

    public Logger logger() {
        return this.logger;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    private MongoSettings settings$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                MongoSettings mongoSettings;
                MongoSettings defaults = MongoSettings$.MODULE$.apply(this.as.settings());
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.config.getConfig("overrides"));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Config overrides = (Config)success.value();
                    this.logger().info("Applying configuration-specific overrides for driver");
                    mongoSettings = defaults.withOverride(overrides);
                } else if (try_ instanceof Failure) {
                    this.logger().debug("No configuration-specific overrides found to apply to driver");
                    mongoSettings = defaults;
                } else {
                    throw new MatchError((Object)try_);
                }
                this.settings = mongoSettings;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.settings;
    }

    public MongoSettings settings() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.settings$lzycompute() : this.settings;
    }

    public abstract Object collection(String var1, ExecutionContext var2);

    public abstract Object ensureCollection(String var1, ExecutionContext var2);

    public abstract Object cappedCollection(String var1, ExecutionContext var2);

    public abstract Function1<Object, Object> ensureIndex(String var1, boolean var2, boolean var3, Seq<Tuple2<String, Object>> var4, ExecutionContext var5);

    public abstract void closeConnections();

    private Option<CanSuffixCollectionNames> canSuffixCollectionNamesBuilder() {
        return this.canSuffixCollectionNamesBuilder;
    }

    private String getSuffixFromPersistenceId(String persistenceId) {
        String string;
        Option<CanSuffixCollectionNames> option = this.canSuffixCollectionNamesBuilder();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanSuffixCollectionNames builderIns = (CanSuffixCollectionNames)some.value();
            string = builderIns.getSuffixFromPersistenceId(persistenceId);
        } else {
            string = "";
        }
        return string;
    }

    private String validateMongoCharacters(String input) {
        String string;
        Option<CanSuffixCollectionNames> option = this.canSuffixCollectionNamesBuilder();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanSuffixCollectionNames builderIns = (CanSuffixCollectionNames)some.value();
            string = builderIns.validateMongoCharacters(input);
        } else {
            string = input;
        }
        return string;
    }

    private String appendSuffixToName(String nameInSettings, String suffix) {
        String string = suffix;
        String string2 = "".equals(string) ? nameInSettings : new StringBuilder(0).append(nameInSettings).append(this.suffixSeparator()).append(this.validateMongoCharacters(suffix)).toString();
        String name = string2;
        this.logger().debug(new StringBuilder(58).append("Suffixed name for value \"").append(nameInSettings).append("\" in settings and suffix \"").append(suffix).append("\" is \"").append(name).append("\"").toString());
        return name;
    }

    public String getJournalCollectionName(String persistenceId) {
        String string = persistenceId;
        String string2 = "".equals(string) ? this.journalCollectionName() : this.appendSuffixToName(this.journalCollectionName(), this.getSuffixFromPersistenceId(persistenceId));
        return string2;
    }

    public String getSnapsCollectionName(String persistenceId) {
        String string = persistenceId;
        String string2 = "".equals(string) ? this.snapsCollectionName() : this.appendSuffixToName(this.snapsCollectionName(), this.getSuffixFromPersistenceId(persistenceId));
        return string2;
    }

    public Object getJournal(String persistenceId) {
        return this.collection(this.getJournalCollectionName(persistenceId), (ExecutionContext)this.pluginDispatcher());
    }

    public Object getSnaps(String persistenceId) {
        return this.collection(this.getSnapsCollectionName(persistenceId), (ExecutionContext)this.pluginDispatcher());
    }

    private Seq<IndexSettings> indexes$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.indexes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexSettings[]{new IndexSettings(this.journalIndexName(), true, false, (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)1))})), new IndexSettings(this.journalSeqNrIndexName(), false, false, (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)-1))})), new IndexSettings(this.journalTagIndexName(), false, true, (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_tg"), (Object)BoxesRunTime.boxToInteger((int)1))}))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.indexes;
    }

    public Seq<IndexSettings> indexes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.indexes$lzycompute() : this.indexes;
    }

    public Object journal() {
        return this.journal("", (ExecutionContext)this.pluginDispatcher());
    }

    public Object journal(String persistenceId, ExecutionContext ec) {
        String collectionName = this.getJournalCollectionName(persistenceId);
        return this.journalCache.getOrElseCreate(collectionName, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)theCollectionName -> {
            Object journalCollection = this.ensureCollection((String)theCollectionName, (ExecutionContext)this.pluginDispatcher());
            return this.indexes().foldLeft(journalCollection, (Function2 & Serializable & scala.Serializable)(acc, index) -> this.ensureIndex(index.name(), index.unique(), index.sparse(), index.fields(), ec).apply(acc));
        });
    }

    public void removeJournalInCache(String persistenceId) {
        String collectionName = this.getJournalCollectionName(persistenceId);
        this.journalCache.invalidate(collectionName);
    }

    public Object snaps() {
        return this.snaps("", (ExecutionContext)this.pluginDispatcher());
    }

    public Object snaps(String persistenceId, ExecutionContext ec) {
        String collectionName = this.getSnapsCollectionName(persistenceId);
        return this.snapsCache.getOrElseCreate(collectionName, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)theCollectionName -> {
            Object snapsCollection = this.ensureCollection((String)theCollectionName, (ExecutionContext)this.pluginDispatcher());
            return this.ensureIndex(this.snapsIndexName(), true, false, (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sn"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ts"), (Object)BoxesRunTime.boxToInteger((int)-1))}), ec).apply(snapsCollection);
        });
    }

    public void removeSnapsInCache(String persistenceId) {
        String collectionName = this.getSnapsCollectionName(persistenceId);
        this.snapsCache.invalidate(collectionName);
    }

    public Object realtime() {
        return this.realtimeCache.getOrElseCreate(this.realtimeCollectionName(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)collectionName -> this.cappedCollection((String)collectionName, (ExecutionContext)this.pluginDispatcher()));
    }

    public MessageDispatcher querySideDispatcher() {
        return this.querySideDispatcher;
    }

    public Object metadata(ExecutionContext ec) {
        return this.metadataCache.getOrElseCreate(this.metadataCollectionName(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)collectionName -> {
            Object metadataCollection = this.ensureCollection((String)collectionName, (ExecutionContext)this.pluginDispatcher());
            return this.ensureIndex("akka_persistence_metadata_pid", true, true, (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1))}), ec).apply(metadataCollection);
        });
    }

    public boolean useSuffixedCollectionNames() {
        return this.suffixBuilderClassOption().isDefined();
    }

    public Option<String> databaseName() {
        return this.settings().Database();
    }

    public String snapsCollectionName() {
        return this.settings().SnapsCollection();
    }

    public String snapsIndexName() {
        return this.settings().SnapsIndex();
    }

    public WriteSafety snapsWriteSafety() {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(this.settings().SnapsWriteConcern());
    }

    public FiniteDuration snapsWTimeout() {
        return this.settings().SnapsWTimeout();
    }

    public boolean snapsFsync() {
        return this.settings().SnapsFSync();
    }

    public String journalCollectionName() {
        return this.settings().JournalCollection();
    }

    public String journalIndexName() {
        return this.settings().JournalIndex();
    }

    public String journalSeqNrIndexName() {
        return this.settings().JournalSeqNrIndex();
    }

    public String journalTagIndexName() {
        return this.settings().JournalTagIndex();
    }

    public WriteSafety journalWriteSafety() {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(this.settings().JournalWriteConcern());
    }

    public FiniteDuration journalWTimeout() {
        return this.settings().JournalWTimeout();
    }

    public boolean journalFsync() {
        return this.settings().JournalFSync();
    }

    public boolean realtimeEnablePersistence() {
        return this.settings().realtimeEnablePersistence();
    }

    public String realtimeCollectionName() {
        return this.settings().realtimeCollectionName();
    }

    public long realtimeCollectionSize() {
        return this.settings().realtimeCollectionSize();
    }

    public String metadataCollectionName() {
        return this.settings().MetadataCollection();
    }

    public String mongoUri() {
        return this.settings().MongoUri();
    }

    public boolean useLegacySerialization() {
        return this.settings().UseLegacyJournalSerialization();
    }

    public Option<String> suffixBuilderClassOption() {
        return Option$.MODULE$.apply((Object)this.settings().SuffixBuilderClass()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MongoPersistenceDriver.$anonfun$suffixBuilderClassOption$1(x$1)));
    }

    public String suffixSeparator() {
        String string = this.settings().SuffixSeparator();
        String string2 = !string.isEmpty() ? this.validateMongoCharacters(this.settings().SuffixSeparator()).substring(0, 1) : "_";
        return string2;
    }

    public boolean suffixDropEmpty() {
        return this.settings().SuffixDropEmptyCollections();
    }

    public Event deserializeJournal(Object dbo, CanDeserializeJournal<Object> ev) {
        return ev.deserializeDocument(dbo);
    }

    public Object serializeJournal(Atom aw, CanSerializeJournal<Object> ev) {
        return ev.serializeAtom(aw);
    }

    public static final /* synthetic */ boolean $anonfun$suffixBuilderClassOption$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).nonEmpty();
    }

    public MongoPersistenceDriver(ActorSystem as, Config config) {
        None$ none$;
        Some some;
        String suffixBuilderClass;
        this.as = as;
        this.config = config;
        super(as, config);
        this.DEFAULT_DB_NAME = "akka-persistence";
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.actorSystem = as;
        as.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeConnections());
        Option<String> option = this.suffixBuilderClassOption();
        if (option instanceof Some && !(suffixBuilderClass = (String)(some = (Some)option).value()).trim().isEmpty()) {
            ReflectiveLookupExtension reflectiveAccess = (ReflectiveLookupExtension)ReflectiveLookupExtension$.MODULE$.apply(this.actorSystem());
            Class builderClass = reflectiveAccess.unsafeReflectClassByName(suffixBuilderClass, ClassTag$.MODULE$.apply(CanSuffixCollectionNames.class));
            Constructor builderCons = builderClass.getConstructor(new Class[0]);
            none$ = new Some(builderCons.newInstance(new Object[0]));
        } else {
            none$ = None$.MODULE$;
        }
        this.canSuffixCollectionNamesBuilder = none$;
        this.journalCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "journal", this.actorSystem());
        this.snapsCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "snaps", this.actorSystem());
        this.realtimeCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "realtime", this.actorSystem());
        this.querySideDispatcher = this.actorSystem().dispatchers().lookup("akka-contrib-persistence-query-dispatcher");
        this.metadataCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "metadata", this.actorSystem());
    }

    public static interface WriteSafety {
    }
}

