/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.Done;
import akka.NotUsed;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.contrib.persistence.mongodb.Atom$;
import akka.contrib.persistence.mongodb.Event;
import akka.contrib.persistence.mongodb.MongoPersistenceJournallingApi;
import akka.contrib.persistence.mongodb.RxStreamsInterop$;
import akka.contrib.persistence.mongodb.ScalaDriverPersistenceJournaller$;
import akka.contrib.persistence.mongodb.ScalaMongoDriver;
import akka.contrib.persistence.mongodb.package;
import akka.contrib.persistence.mongodb.package$;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import akka.stream.ActorMaterializer$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.Completed;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.model.Accumulators$;
import org.mongodb.scala.model.Aggregates$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import org.mongodb.scala.model.Updates$;
import org.mongodb.scala.model.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u0001-\u0011\u0001eU2bY\u0006$%/\u001b<feB+'o]5ti\u0016t7-\u001a&pkJt\u0017\r\u001c7fe*\u00111\u0001B\u0001\b[>twm\u001c3c\u0015\t)a!A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA\u0004\t\u0003\u001d\u0019wN\u001c;sS\nT\u0011!C\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a$T8oO>\u0004VM]:jgR,gnY3K_V\u0014h.\u00197mS:<\u0017\t]5\t\u0011]\u0001!Q1A\u0005\u0002a\ta\u0001\u001a:jm\u0016\u0014X#A\r\u0011\u0005MQ\u0012BA\u000e\u0003\u0005A\u00196-\u00197b\u001b>twm\u001c#sSZ,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u001d!'/\u001b<fe\u0002BQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDCA\u0011#!\t\u0019\u0002\u0001C\u0003\u0018=\u0001\u0007\u0011\u0004C\u0004%\u0001\t\u0007I\u0011C\u0013\u0002\r1|wmZ3s+\u00051\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0013aA8sO&\u0011Q\u0006\u000b\u0002\u0007\u0019><w-\u001a:\t\r=\u0002\u0001\u0015!\u0003'\u0003\u001dawnZ4fe\u0002Ba!\r\u0001!\u0002\u0013\u0011\u0014\u0001D<sSR,7i\u001c8dKJt\u0007CA\u001aB\u001d\t!dH\u0004\u00026y9\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003s)\ta\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0005\rQ\u0013BA\b>\u0015\t\u0019!&\u0003\u0002@\u0001\u00069\u0001/Y2lC\u001e,'BA\b>\u0013\t\u00115I\u0001\u0007Xe&$XmQ8oG\u0016\u0014hN\u0003\u0002@\u0001\"1Q\t\u0001Q\u0005\n\u0019\u000bqA[8ve:\fG\u000e\u0006\u0002H\u0019B\u0011\u0001J\u0013\b\u0003\u0013Zi\u0011\u0001A\u0005\u0003\u0017j\u0011\u0011a\u0011\u0005\u0006\u001b\u0012\u0003\u001dAT\u0001\u0003K\u000e\u0004\"a\u0014*\u000e\u0003AS!!\u0015\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002T!\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0007+\u0002\u0001K\u0011\u0002,\u0002\u0011I,\u0017\r\u001c;j[\u0016,\u0012a\u0012\u0005\u00071\u0002\u0001K\u0011B-\u0002\u00115,G/\u00193bi\u0006$\"a\u0012.\t\u000b5;\u00069\u0001(\t\rq\u0003\u0001\u0015\"\u0003^\u0003EQw.\u001e:oC2\u0014\u0016M\\4f#V,'/\u001f\u000b\u0005=248\u0010\u0005\u0002`S:\u0011\u0001m\u001a\b\u0003C\u0012t!\u0001\u000e2\n\u0005\r\u0004\u0015\u0001\u00022t_:L!!\u001a4\u0002\u0017\r|gN^3sg&|gn\u001d\u0006\u0003G\u0002K!a\u00105\u000b\u0005\u00154\u0017B\u00016l\u0005\u0011\u00115o\u001c8\u000b\u0005}B\u0007\"B7\\\u0001\u0004q\u0017a\u00019jIB\u0011qn\u001d\b\u0003aF\u0004\"a\u000e\b\n\u0005It\u0011A\u0002)sK\u0012,g-\u0003\u0002uk\n11\u000b\u001e:j]\u001eT!A\u001d\b\t\u000b]\\\u0006\u0019\u0001=\u0002\t\u0019\u0014x.\u001c\t\u0003\u001beL!A\u001f\b\u0003\t1{gn\u001a\u0005\u0006yn\u0003\r\u0001_\u0001\u0003i>DaA \u0001!\u0002\u0017y\u0018AB:zgR,W\u000e\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001C\u0001\u0006C\u000e$xN]\u0005\u0005\u0003\u0013\t\u0019AA\u0006BGR|'oU=ti\u0016l\u0007\u0002CA\u0007\u0001\u0001\u0006Y!a\u0004\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\t\u0003\u0019\u0019HO]3b[&!\u0011\u0011DA\n\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0011!\ti\u0002\u0001C\u0001\u0005\u0005}\u0011\u0001\u00046pkJt\u0017\r\u001c*b]\u001e,GCCA\u0011\u0003\u007f\t\t%a\u0011\u0002FQ!\u00111EA\u001f!!\t)#a\u000b\u00020\u0005URBAA\u0014\u0015\u0011\tI#a\u0005\u0002\u0011M\u001c\u0017\r\\1eg2LA!!\f\u0002(\t11k\\;sG\u0016\u00042aEA\u0019\u0013\r\t\u0019D\u0001\u0002\u0006\u000bZ,g\u000e\u001e\t\u0005\u0003o\tI$D\u0001\t\u0013\r\tY\u0004\u0003\u0002\b\u001d>$Xk]3e\u0011\u0019i\u00151\u0004a\u0002\u001d\"1Q.a\u0007A\u00029Daa^A\u000e\u0001\u0004A\bB\u0002?\u0002\u001c\u0001\u0007\u0001\u0010\u0003\u0005\u0002H\u0005m\u0001\u0019AA%\u0003\ri\u0017\r\u001f\t\u0004\u001b\u0005-\u0013bAA'\u001d\t\u0019\u0011J\u001c;\t\u0011\u0005E\u0003\u0001)C\u0005\u0003'\n!BY;jY\u0012\u0014\u0015\r^2i)\u0011\t)&! \u0011\r\u0005]\u0013\u0011MA3\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!C5n[V$\u0018M\u00197f\u0015\r\tyFD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u00033\u00121aU3r!\u0019\t9'!\u001c\u0002r5\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wr\u0011\u0001B;uS2LA!a\u001c\u0002j\t\u0019AK]=\u0011\t\u0005M\u0014q\u000f\b\u0004C\u0006U\u0014BA g\u0013\u0011\tI(a\u001f\u0003\u0019\t\u001bxN\u001c#pGVlWM\u001c;\u000b\u0005}2\u0007\u0002CA@\u0003\u001f\u0002\r!!!\u0002\r]\u0014\u0018\u000e^3t!\u0019\t9&!\u0019\u0002\u0004B!\u0011QQAE\u001b\t\t9I\u0003\u0002\u0006\u0011%!\u00111RAD\u0005-\tEo\\7jG^\u0013\u0018\u000e^3\t\u0011\u0005=\u0005\u0001)C\u0005\u0003#\u000bQ\u0002Z8CCR\u001c\u0007.\u00119qK:$GCBAJ\u0003;\u000b\t\u000b\u0006\u0003\u0002\u0016\u0006m\u0005#B(\u0002\u0018\u0006U\u0013bAAM!\n1a)\u001e;ve\u0016Da!TAG\u0001\bq\u0005\u0002CAP\u0003\u001b\u0003\r!!\u0016\u0002\u000b\t\fGo\u00195\t\u000f\u0005}\u0013Q\u0012a\u0001\u000f\"A\u0011Q\u0015\u0001\u0005B\t\t9+A\u0006cCR\u001c\u0007.\u00119qK:$G\u0003BAU\u0003s#B!a+\u00028B)q*a&\u0002.B1\u0011qKA1\u0003_\u0003b!a\u001a\u0002n\u0005E\u0006cA\u0007\u00024&\u0019\u0011Q\u0017\b\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u001b\u0006\r\u00069\u0001(\t\u0011\u0005}\u00141\u0015a\u0001\u0003\u0003C\u0001\"!0\u0001A\u0013%\u0011qX\u0001\u0017g\u0016$X*\u0019=TKF,XM\\2f\u001b\u0016$\u0018\rZ1uCR1\u0011\u0011YAd\u0003\u0017$B!a1\u0002FB)q*a&\u00022\"1Q*a/A\u00049Cq!!3\u0002<\u0002\u0007a.A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u0005\b\u0003\u001b\fY\f1\u0001y\u00035i\u0017\r_*fcV,gnY3Oe\"A\u0011\u0011\u001b\u0001!\n\u0013\t\u0019.A\bgS:$W*\u0019=TKF,XM\\2f)\u0019\t).!9\u0002dR!\u0011q[Ap!\u0015y\u0015qSAm!\u0011i\u00111\u001c=\n\u0007\u0005ugB\u0001\u0004PaRLwN\u001c\u0005\u0007\u001b\u0006=\u00079\u0001(\t\u000f\u0005%\u0017q\u001aa\u0001]\"9\u0011QZAh\u0001\u0004A\b\u0002CAt\u0001\u0011\u0005#!!;\u0002\u0015\u0011,G.\u001a;f\rJ|W\u000e\u0006\u0004\u0002l\u0006=\u0018\u0011\u001f\u000b\u0005\u0003\u0007\fi\u000f\u0003\u0004N\u0003K\u0004\u001dA\u0014\u0005\b\u0003\u0013\f)\u000f1\u0001o\u0011\u001d\t\u00190!:A\u0002a\fA\u0002^8TKF,XM\\2f\u001dJD\u0001\"a>\u0001A\u0013%\u0011\u0011`\u0001\u0018[\u0006D8+Z9vK:\u001cWM\u0012:p[6+G/\u00193bi\u0006$B!a?\u0003\u0006Q!\u0011Q B\u0001)\u0011\t9.a@\t\r5\u000b)\u0010q\u0001O\u0011!\u0011\u0019!!>A\u0002\u0005e\u0017\u0001\u00039sKZLw.^:\t\r5\f)\u00101\u0001o\u0011!\ti\r\u0001C!\u0005\t%AC\u0002B\u0006\u0005#\u0011\u0019\u0002\u0006\u0003\u0003\u000e\t=\u0001\u0003B(\u0002\u0018bDa!\u0014B\u0004\u0001\bq\u0005BB7\u0003\b\u0001\u0007a\u000e\u0003\u0004x\u0005\u000f\u0001\r\u0001\u001f\u0005\t\u0005/\u0001A\u0011\t\u0002\u0003\u001a\u0005i!/\u001a9mCfTu.\u001e:oC2$\"Ba\u0007\u00032\tM\"Q\u0007B\u001c)\u0011\u0011iB!\t\u0015\t\u0005\r'q\u0004\u0005\u0007\u001b\nU\u00019\u0001(\t\u0011\t\r\"Q\u0003a\u0001\u0005K\taB]3qY\u0006L8)\u00197mE\u0006\u001c7\u000eE\u0004\u000e\u0005O\u0011Y#!-\n\u0007\t%bBA\u0005Gk:\u001cG/[8ocA!\u0011Q\u0011B\u0017\u0013\u0011\u0011y#a\"\u0003\u001dA+'o]5ti\u0016tGOU3qe\"1QN!\u0006A\u00029Daa\u001eB\u000b\u0001\u0004A\bB\u0002?\u0003\u0016\u0001\u0007\u0001\u0010C\u0004\u0002H\tU\u0001\u0019\u0001=")
public class ScalaDriverPersistenceJournaller
implements MongoPersistenceJournallingApi {
    private final ScalaMongoDriver driver;
    private final Logger logger;
    private final WriteConcern writeConcern;
    private final ActorSystem system;
    private final Materializer materializer;

    public <T> scala.collection.immutable.Seq<Try<BoxedUnit>> squashToUnit(scala.collection.immutable.Seq<Try<T>> seq) {
        return MongoPersistenceJournallingApi.squashToUnit$((MongoPersistenceJournallingApi)this, seq);
    }

    public ScalaMongoDriver driver() {
        return this.driver;
    }

    public Logger logger() {
        return this.logger;
    }

    private Future<MongoCollection<BsonDocument>> journal(ExecutionContext ec) {
        return ((Future)this.driver().journal()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withWriteConcern(this.driver().journalWriteConcern()), ec);
    }

    public Future<MongoCollection<BsonDocument>> akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$realtime() {
        return (Future)this.driver().realtime();
    }

    private Future<MongoCollection<BsonDocument>> metadata(ExecutionContext ec) {
        return ((Future)this.driver().metadata()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.withWriteConcern(this.driver().metadataWriteConcern()), ec);
    }

    private Bson journalRangeQuery(String pid, long from, long to) {
        return Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)pid), Filters$.MODULE$.gte("from", (Object)BoxesRunTime.boxToLong((long)from)), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)to))}));
    }

    public Source<Event, NotUsed> journalRange(String pid, long from, long to, int max, ExecutionContext ec) {
        Future journal = (Future)this.driver().getJournal(pid);
        Source source2 = (Source)Source$.MODULE$.fromFuture(journal).flatMapConcat((Function1 & Serializable & scala.Serializable)x$3 -> (Source)RxStreamsInterop$.MODULE$.ObservableAdapter(x$3.find(this.journalRangeQuery(pid, from, to), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).sort(Sorts$.MODULE$.ascending((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to"}))).projection(Projections$.MODULE$.include((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"events"})))).asAkka().take((long)max));
        Flow flow = (Flow)Flow$.MODULE$.apply().mapConcat((Function1 & Serializable & scala.Serializable)e -> (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)e.get((Object)"events")).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isArray())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.asArray()).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getValues()).asScala()).toList().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaDriverPersistenceJournaller $outer;

            public final <A1 extends BsonValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BsonDocument) {
                    BsonDocument bsonDocument = (BsonDocument)A1;
                    object = this.$outer.driver().deserializeJournal(bsonDocument, this.$outer.driver().ScalaSerializers().Deserializer());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(BsonValue x1) {
                BsonValue bsonValue = x1;
                boolean bl = bsonValue instanceof BsonDocument;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Seq)Seq$.MODULE$.empty())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ScalaDriverPersistenceJournaller.$anonfun$journalRange$7(from, x$7))).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ScalaDriverPersistenceJournaller.$anonfun$journalRange$8(to, x$8)));
        return source2.via((Graph)flow);
    }

    private scala.collection.immutable.Seq<Try<BsonDocument>> buildBatch(scala.collection.immutable.Seq<AtomicWrite> writes) {
        return (scala.collection.immutable.Seq)writes.map((Function1 & Serializable & scala.Serializable)aw -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (BsonDocument)this.driver().serializeJournal(Atom$.MODULE$.apply(aw, this.driver().useLegacySerialization(), this.driver().ScalaSerializers().serialization(), ManifestFactory$.MODULE$.classType(BsonValue.class), this.driver().ScalaSerializers().dt(), this.driver().ScalaSerializers().loader()), this.driver().ScalaSerializers().Serializer())), Seq$.MODULE$.canBuildFrom());
    }

    public Future<scala.collection.immutable.Seq<Try<BsonDocument>>> akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend(scala.collection.immutable.Seq<Try<BsonDocument>> batch, Future<MongoCollection<BsonDocument>> collection, ExecutionContext ec) {
        Future future;
        if (batch.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isSuccess()))) {
            scala.collection.immutable.Seq collected = (scala.collection.immutable.Seq)batch.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Try<BsonDocument>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof Success) {
                        Success success = (Success)A1;
                        BsonDocument doc = (BsonDocument)success.value();
                        object = package.InsertOneModel$.MODULE$.apply((Object)doc);
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Try<BsonDocument> x2) {
                    Try<BsonDocument> try_ = x2;
                    boolean bl = try_ instanceof Success;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            future = collection.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(x$10.withWriteConcern($this.writeConcern).bulkWrite((Seq)collected, new BulkWriteOptions().ordered(true))).toFuture().map((Function1 & Serializable & scala.Serializable)x$11 -> batch, ec), ec);
        } else {
            future = Future$.MODULE$.sequence((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Future future;
                Success success;
                BsonDocument document;
                Try try_ = x0$1;
                if (try_ instanceof Success && (document = (BsonDocument)(success = (Success)try_).value()) != null) {
                    BsonDocument bsonDocument = document;
                    future = collection.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(x$12.withWriteConcern($this.writeConcern).insertOne((Object)bsonDocument)).toFuture().map((Function1 & Serializable & scala.Serializable)x$13 -> new Success((Object)bsonDocument), ec), ec);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    future = Future$.MODULE$.successful((Object)new Failure(failure.exception()));
                } else {
                    throw new MatchError((Object)try_);
                }
                return future;
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ec);
        }
        return future;
    }

    public Future<scala.collection.immutable.Seq<Try<BoxedUnit>>> batchAppend(scala.collection.immutable.Seq<AtomicWrite> writes, ExecutionContext ec) {
        Future future;
        if (this.driver().useSuffixedCollectionNames()) {
            Future fZero = Future$.MODULE$.successful((Object)Seq$.MODULE$.empty());
            future = (Future)writes.groupBy((Function1 & Serializable & scala.Serializable)write -> this.driver().getJournalCollectionName(write.persistenceId())).foldLeft((Object)fZero, (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                Tuple2 tuple2;
                Future future;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$2, x1$1);
                        if (tuple22 == null) break block2;
                        future = (Future)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                scala.collection.immutable.Seq hunk = (scala.collection.immutable.Seq)tuple2._2();
                Future future2 = future.map((Function1 & Serializable & scala.Serializable)prev -> {
                    scala.collection.immutable.Seq<Try<BsonDocument>> batch = this.buildBatch((scala.collection.immutable.Seq<AtomicWrite>)hunk);
                    return new Tuple2(prev, batch);
                }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
                    Tuple2 tuple2 = x$14;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    scala.collection.immutable.Seq prev = (scala.collection.immutable.Seq)tuple2._1();
                    scala.collection.immutable.Seq batch = (scala.collection.immutable.Seq)tuple2._2();
                    Future future = this.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend((scala.collection.immutable.Seq<Try<BsonDocument>>)batch, (Future<MongoCollection<BsonDocument>>)((Future)this.driver().journal(((AtomicWrite)hunk.head()).persistenceId())), ec).map((Function1 & Serializable & scala.Serializable)next -> (scala.collection.immutable.Seq)prev.$plus$plus((GenTraversableOnce)next, Seq$.MODULE$.canBuildFrom()), ec);
                    return future;
                }, ec);
                return future2;
            });
        } else {
            scala.collection.immutable.Seq<Try<BsonDocument>> batch = this.buildBatch(writes);
            future = this.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend(batch, this.journal(ec), ec);
        }
        Future batchFuture = future;
        return this.driver().realtimeEnablePersistence() ? batchFuture.andThen((PartialFunction)new scala.Serializable(this, ec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaDriverPersistenceJournaller $outer;
            private final ExecutionContext ec$2;

            public final <A1 extends Try<scala.collection.immutable.Seq<Try<BsonDocument>>>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Future<scala.collection.immutable.Seq<Try<BsonDocument>>> future;
                A1 A1 = x3;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    scala.collection.immutable.Seq batch = (scala.collection.immutable.Seq)success.value();
                    Future<scala.collection.immutable.Seq<Try<BsonDocument>>> f = this.$outer.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend((scala.collection.immutable.Seq<Try<BsonDocument>>)batch, this.$outer.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$realtime(), this.ec$2);
                    f.onFailure((PartialFunction)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$batchAppend$8 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                            A1 A1 = x4;
                            this.$outer.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$anonfun$$$outer().logger().error("Error during write to realtime collection", A1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return (B1)boxedUnit;
                        }

                        public final boolean isDefinedAt(Throwable x4) {
                            Throwable throwable = x4;
                            boolean bl = true;
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, this.ec$2);
                    future = f;
                } else {
                    future = function1.apply(x3);
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Try<scala.collection.immutable.Seq<Try<BsonDocument>>> x3) {
                Try<scala.collection.immutable.Seq<Try<BsonDocument>>> try_ = x3;
                boolean bl = try_ instanceof Success;
                return bl;
            }

            public /* synthetic */ ScalaDriverPersistenceJournaller akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ec$2 = ec$2;
            }
        }, ec).map((Function1 & Serializable & scala.Serializable)seq -> this.squashToUnit((scala.collection.immutable.Seq)seq), ec) : batchFuture.map((Function1 & Serializable & scala.Serializable)seq -> this.squashToUnit((scala.collection.immutable.Seq)seq), ec);
    }

    private Future<BoxedUnit> setMaxSequenceMetadata(String persistenceId, long maxSequenceNr, ExecutionContext ec) {
        return this.metadata(ec).flatMap((Function1 & Serializable & scala.Serializable)md -> org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(md.updateOne(Filters$.MODULE$.equal("pid", (Object)persistenceId), Updates$.MODULE$.combine((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.setOnInsert("pid", (Object)persistenceId), Updates$.MODULE$.setOnInsert("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))})), new UpdateOptions().upsert(true))).toFuture().flatMap((Function1 & Serializable & scala.Serializable)_2 -> org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(md.updateOne(Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))})), Updates$.MODULE$.set("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)), new UpdateOptions().upsert(false))).toFuture().map((Function1 & Serializable & scala.Serializable)_ -> {
            ScalaDriverPersistenceJournaller.$anonfun$setMaxSequenceMetadata$3(_);
            return BoxedUnit.UNIT;
        }, ec), ec), ec);
    }

    private Future<Option<Object>> findMaxSequence(String persistenceId, long maxSequenceNr, ExecutionContext ec) {
        return ((Future)this.driver().getJournal(persistenceId)).flatMap((Function1 & Serializable & scala.Serializable)j -> ScalaDriverPersistenceJournaller.performAggregation$1(j, persistenceId, maxSequenceNr, ec).map((Function1 & Serializable & scala.Serializable)rez -> rez, ec), ec);
    }

    public Future<BoxedUnit> deleteFrom(String persistenceId, long toSequenceNr, ExecutionContext ec) {
        return ((Future)this.driver().getJournal(persistenceId)).flatMap((Function1 & Serializable & scala.Serializable)journal -> this.findMaxSequence(persistenceId, toSequenceNr, ec).flatMap((Function1 & Serializable & scala.Serializable)ms -> ((Future)ms.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable & scala.Serializable)x$22 -> this.setMaxSequenceMetadata(persistenceId, BoxesRunTime.unboxToLong((Object)x$22), ec))).map((Function1 & Serializable & scala.Serializable)x$26 -> {
            Bson docWithAllEventsToRemove = Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)toSequenceNr))}));
            return new Tuple2(x$26, (Object)docWithAllEventsToRemove);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Bson docWithAllEventsToRemove = (Bson)tuple2._2();
            Future future = org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(journal.deleteMany(docWithAllEventsToRemove)).toFuture().map((Function1 & Serializable & scala.Serializable)removed -> {
                Bson query = this.journalRangeQuery(persistenceId, toSequenceNr, toSequenceNr);
                Bson update = Updates$.MODULE$.combine((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.pull("events", (Object)Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("sn", (Object)BoxesRunTime.boxToLong((long)toSequenceNr))}))), Updates$.MODULE$.set("from", (Object)BoxesRunTime.boxToLong((long)(toSequenceNr + 1L)))}));
                return new Tuple3(removed, (Object)query, (Object)update);
            }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$27 -> {
                Tuple3 tuple3 = x$27;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                DeleteResult removed = (DeleteResult)tuple3._1();
                Bson query = (Bson)tuple3._2();
                Bson update = (Bson)tuple3._3();
                Future future = org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(journal.withWriteConcern($this.writeConcern).updateMany(query, update, new UpdateOptions().upsert(false))).toFuture().recover((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x5;
                        if (A1 instanceof MongoWriteException) {
                            MongoWriteException mongoWriteException = (MongoWriteException)A1;
                            ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                            ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                            if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) {
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x5);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Throwable x5) {
                        Throwable throwable = x5;
                        if (!(throwable instanceof MongoWriteException)) return false;
                        MongoWriteException mongoWriteException = (MongoWriteException)throwable;
                        ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                        ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                        if (errorCategory != null) {
                            if (!errorCategory.equals(errorCategory2)) return false;
                            return true;
                        }
                        if (errorCategory2 == null) return true;
                        return false;
                    }
                }, ec).map((Function1 & Serializable & scala.Serializable)_ -> {
                    object = this.driver().useSuffixedCollectionNames() && this.driver().suffixDropEmpty() && removed.wasAcknowledged() ? org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(journal.countDocuments()).toFuture().withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)n -> n == 0L, ec).flatMap((Function1 & Serializable & scala.Serializable)n -> ScalaDriverPersistenceJournaller.$anonfun$deleteFrom$11($this, persistenceId$3, ec$5, journal$1, BoxesRunTime.unboxToLong((Object)n)), ec) : BoxedUnit.UNIT;
                    return BoxedUnit.UNIT;
                }, ec);
                return future;
            }, ec);
            return future;
        }, ec), ec), ec);
    }

    private Future<Option<Object>> maxSequenceFromMetadata(String pid, Option<Object> previous, ExecutionContext ec) {
        return (Future)previous.fold((Function0 & Serializable & scala.Serializable)() -> this.metadata(ec).flatMap((Function1 & Serializable & scala.Serializable)x$29 -> org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(x$29.find((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).projection((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_sn"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).first()).toFutureOption().map((Function1 & Serializable & scala.Serializable)d -> d.flatMap((Function1 & Serializable & scala.Serializable)l -> Option$.MODULE$.apply((Object)l.asDocument().get((Object)"max_sn")).filter((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.isInt64())).map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.asInt64()).map((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToLong((long)x$32.getValue()))), ec), ec), (Function1 & Serializable & scala.Serializable)l -> Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)l)))));
    }

    public Future<Object> maxSequenceNr(String pid, long from, ExecutionContext ec) {
        Future journal = (Future)this.driver().getJournal(pid);
        return journal.flatMap((Function1 & Serializable & scala.Serializable)x$33 -> org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(x$33.find((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).projection((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).sort((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)-1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).first()).toFutureOption().map((Function1 & Serializable & scala.Serializable)d -> d.flatMap((Function1 & Serializable & scala.Serializable)a -> Option$.MODULE$.apply((Object)a.asDocument().get((Object)"to")).filter((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)x$34.isInt64())).map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.asInt64()).map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToLong((long)x$36.getValue()))), ec).flatMap((Function1 & Serializable & scala.Serializable)x$37 -> this.maxSequenceFromMetadata(pid, (Option<Object>)x$37, ec), ec).map((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToLong((long)ScalaDriverPersistenceJournaller.$anonfun$maxSequenceNr$8(x$38)), ec), ec);
    }

    public Future<BoxedUnit> replayJournal(String pid, long from, long to, long max, Function1<PersistentRepr, BoxedUnit> replayCallback, ExecutionContext ec) {
        Future future;
        if (max == 0L) {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            int maxInt = package.NonWrappingLongToInt$.MODULE$.toIntWithoutWrapping$extension(package$.MODULE$.NonWrappingLongToInt(max));
            future = ((Future)((Source)this.journalRange(pid, from, to, maxInt, ec).map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.toRepr())).runWith((Graph)Sink$.MODULE$.foreach(replayCallback), this.materializer)).map((Function1 & Serializable & scala.Serializable)x$40 -> {
                ScalaDriverPersistenceJournaller.$anonfun$replayJournal$2(x$40);
                return BoxedUnit.UNIT;
            }, ec);
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$journalRange$7(long from$1, Event x$7) {
        return x$7.sn() >= from$1;
    }

    public static final /* synthetic */ boolean $anonfun$journalRange$8(long to$1, Event x$8) {
        return x$8.sn() <= to$1;
    }

    public static final /* synthetic */ void $anonfun$setMaxSequenceMetadata$3(UpdateResult _) {
    }

    private static final Future performAggregation$1(MongoCollection j, String persistenceId$2, long maxSequenceNr$2, ExecutionContext ec$4) {
        Bson bson = Aggregates$.MODULE$.match(Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId$2), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr$2))})));
        Bson bson2 = Aggregates$.MODULE$.group((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"pid"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonField[]{Accumulators$.MODULE$.max("max", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"to"})))}));
        return org.mongodb.scala.package$.MODULE$.ScalaObservable((Observable)j.aggregate((Seq)Nil$.MODULE$.$colon$colon((Object)bson2).$colon$colon((Object)bson), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class))).toFuture().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.headOption(), ec$4).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.flatMap((Function1 & Serializable & scala.Serializable)l -> Option$.MODULE$.apply((Object)l.asDocument().get((Object)"max")).filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isInt64())).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.asInt64()).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.getValue()))), ec$4);
    }

    public static final /* synthetic */ void $anonfun$deleteFrom$13(Tuple2 x$25) {
        Tuple2 tuple2 = x$25;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$deleteFrom$11(ScalaDriverPersistenceJournaller $this, String persistenceId$3, ExecutionContext ec$5, MongoCollection journal$1, long n) {
        return org.mongodb.scala.package$.MODULE$.ScalaSingleObservable(journal$1.drop()).toFuture().recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                Completed completed = new Completed();
                return (B1)completed;
            }

            public final boolean isDefinedAt(Throwable x6) {
                Throwable throwable = x6;
                boolean bl = true;
                return bl;
            }
        }, ec$5).map((Function1 & Serializable & scala.Serializable)x$23 -> {
            Option x$24 = $this.driver().removeJournalInCache(persistenceId$3);
            return new Tuple2(x$23, (Object)x$24);
        }, ec$5).map((Function1 & Serializable & scala.Serializable)x$25 -> {
            ScalaDriverPersistenceJournaller.$anonfun$deleteFrom$13(x$25);
            return BoxedUnit.UNIT;
        }, ec$5);
    }

    public static final /* synthetic */ long $anonfun$maxSequenceNr$8(Option x$38) {
        return BoxesRunTime.unboxToLong((Object)x$38.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$replayJournal$2(Done x$40) {
    }

    public ScalaDriverPersistenceJournaller(ScalaMongoDriver driver) {
        this.driver = driver;
        MongoPersistenceJournallingApi.$init$((MongoPersistenceJournallingApi)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.writeConcern = driver.journalWriteConcern();
        this.system = driver.actorSystem();
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.system);
    }
}

