/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.Done;
import akka.NotUsed;
import akka.contrib.persistence.mongodb.Atom$;
import akka.contrib.persistence.mongodb.Event;
import akka.contrib.persistence.mongodb.MongoPersistenceJournallingApi;
import akka.contrib.persistence.mongodb.RxStreamsInterop$;
import akka.contrib.persistence.mongodb.ScalaDriverPersistenceJournaller$;
import akka.contrib.persistence.mongodb.ScalaMongoDriver;
import akka.contrib.persistence.mongodb.package;
import akka.contrib.persistence.mongodb.package$;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.model.Accumulators$;
import org.mongodb.scala.model.Aggregates$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import org.mongodb.scala.model.Updates$;
import org.mongodb.scala.model.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!)\u0001\u0007\u0001C\u0001c!9A\u0007\u0001b\u0001\n#)\u0004B\u0002 \u0001A\u0003%a\u0007\u0003\u0004@\u0001\u0001\u0006I\u0001\u0011\u0005\u0007%\u0002\u0001K\u0011B*\t\r}\u0003\u0001\u0015\"\u0003T\u0011\u0019\u0001\u0007\u0001)C\u0005'\"1\u0011\r\u0001Q\u0005\n\tDq!!\u0002\u0001\t\u0003\t9\u0001\u0003\u0005\u00028\u0001\u0001K\u0011BA\u001d\u0011!\t\u0019\b\u0001Q\u0005\n\u0005U\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\t\u0003#\u0003\u0001\u0015\"\u0003\u0002\u0014\"A\u0011q\u0014\u0001!\n\u0013\t\t\u000bC\u0004\u00020\u0002!\t%!-\t\u0011\u0005e\u0006\u0001)C\u0005\u0003wCq!!(\u0001\t\u0003\n)\rC\u0004\u0002N\u0002!\t%a4\u0003AM\u001b\u0017\r\\1Ee&4XM\u001d)feNL7\u000f^3oG\u0016Tu.\u001e:oC2dWM\u001d\u0006\u0003/a\tq!\\8oO>$'M\u0003\u0002\u001a5\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\tYB$A\u0004d_:$(/\u001b2\u000b\u0003u\tA!Y6lC\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003YI!!\u000b\f\u0003=5{gnZ8QKJ\u001c\u0018n\u001d;f]\u000e,'j\\;s]\u0006dG.\u001b8h\u0003BL\u0017A\u00023sSZ,'/F\u0001-!\t9S&\u0003\u0002/-\t\u00012kY1mC6{gnZ8Ee&4XM]\u0001\bIJLg/\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0011!g\r\t\u0003O\u0001AQAK\u0002A\u00021\na\u0001\\8hO\u0016\u0014X#\u0001\u001c\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014!B:mMRR'\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>q\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0007xe&$XmQ8oG\u0016\u0014h\u000e\u0005\u0002B\u001f:\u0011!\t\u0014\b\u0003\u0007*s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001ds\u0012A\u0002\u001fs_>$h(C\u0001<\u0013\t9\"(\u0003\u0002$\u0017*\u0011qCO\u0005\u0003\u001b:\u000bq\u0001]1dW\u0006<WM\u0003\u0002$\u0017&\u0011\u0001+\u0015\u0002\r/JLG/Z\"p]\u000e,'O\u001c\u0006\u0003\u001b:\u000bqA[8ve:\fG.F\u0001U!\r)\u0006LW\u0007\u0002-*\u0011qKI\u0001\u000bG>t7-\u001e:sK:$\u0018BA-W\u0005\u00191U\u000f^;sKB\u00111,\u0018\b\u00039\u0006i\u0011\u0001A\u0005\u0003=6\u0012\u0011aQ\u0001\te\u0016\fG\u000e^5nK\u0006AQ.\u001a;bI\u0006$\u0018-A\tk_V\u0014h.\u00197SC:<W-U;fef$RaY9|\u0003\u0003\u0001\"\u0001\u001a8\u000f\u0005\u0015dgB\u00014j\u001d\t\u0011u-\u0003\u0002i\u001d\u0006!!m]8o\u0013\tQ7.A\u0006d_:4XM]:j_:\u001c(B\u00015O\u0013\tiUN\u0003\u0002kW&\u0011q\u000e\u001d\u0002\u0005\u0005N|gN\u0003\u0002N[\")!O\u0003a\u0001g\u0006\u0019\u0001/\u001b3\u0011\u0005QDhBA;w!\t)%%\u0003\u0002xE\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9(\u0005C\u0003}\u0015\u0001\u0007Q0\u0001\u0003ge>l\u0007CA\u0011\u007f\u0013\ty(E\u0001\u0003M_:<\u0007BBA\u0002\u0015\u0001\u0007Q0\u0001\u0002u_\u0006a!n\\;s]\u0006d'+\u00198hKRQ\u0011\u0011BA\u0014\u0003S\tY#!\f\u0011\u0011\u0005-\u0011QCA\r\u0003?i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\tg\u000e\fG.\u00193tY*\u0019\u00111\u0003\u000f\u0002\rM$(/Z1n\u0013\u0011\t9\"!\u0004\u0003\rM{WO]2f!\r9\u00131D\u0005\u0004\u0003;1\"!B#wK:$\b\u0003BA\u0011\u0003Gi\u0011\u0001H\u0005\u0004\u0003Ka\"a\u0002(piV\u001bX\r\u001a\u0005\u0006e.\u0001\ra\u001d\u0005\u0006y.\u0001\r! \u0005\u0007\u0003\u0007Y\u0001\u0019A?\t\u000f\u0005=2\u00021\u0001\u00022\u0005\u0019Q.\u0019=\u0011\u0007\u0005\n\u0019$C\u0002\u00026\t\u00121!\u00138u\u0003)\u0011W/\u001b7e\u0005\u0006$8\r\u001b\u000b\u0005\u0003w\t\u0019\u0007\u0005\u0004\u0002>\u0005\u001d\u00131J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000b\u0012\u0013AC2pY2,7\r^5p]&!\u0011\u0011JA \u0005\r\u0019V-\u001d\t\u0007\u0003\u001b\n\u0019&a\u0016\u000e\u0005\u0005=#bAA)E\u0005!Q\u000f^5m\u0013\u0011\t)&a\u0014\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002Z\u0005ucb\u00014\u0002\\%\u0011Qj[\u0005\u0005\u0003?\n\tG\u0001\u0007Cg>tGi\\2v[\u0016tGO\u0003\u0002NW\"9\u0011Q\r\u0007A\u0002\u0005\u001d\u0014AB<sSR,7\u000f\u0005\u0004\u0002>\u0005\u001d\u0013\u0011\u000e\t\u0005\u0003W\ny'\u0004\u0002\u0002n)\u0011\u0011\u0004H\u0005\u0005\u0003c\niGA\u0006Bi>l\u0017nY,sSR,\u0017!\u00043p\u0005\u0006$8\r[!qa\u0016tG\r\u0006\u0004\u0002x\u0005e\u0014Q\u0010\t\u0005+b\u000bY\u0004C\u0004\u0002|5\u0001\r!a\u000f\u0002\u000b\t\fGo\u00195\t\r\u0005\u0015S\u00021\u0001U\u0003-\u0011\u0017\r^2i\u0003B\u0004XM\u001c3\u0015\t\u0005\r\u0015q\u0012\t\u0005+b\u000b)\t\u0005\u0004\u0002>\u0005\u001d\u0013q\u0011\t\u0007\u0003\u001b\n\u0019&!#\u0011\u0007\u0005\nY)C\u0002\u0002\u000e\n\u0012A!\u00168ji\"9\u0011Q\r\bA\u0002\u0005\u001d\u0014AF:fi6\u000b\u0007pU3rk\u0016t7-Z'fi\u0006$\u0017\r^1\u0015\r\u0005U\u0015qSAN!\u0011)\u0006,!#\t\r\u0005eu\u00021\u0001t\u00035\u0001XM]:jgR,gnY3JI\"1\u0011QT\bA\u0002u\fQ\"\\1y'\u0016\fX/\u001a8dK:\u0013\u0018a\u00044j]\u0012l\u0015\r_*fcV,gnY3\u0015\r\u0005\r\u00161VAW!\u0011)\u0006,!*\u0011\t\u0005\n9+`\u0005\u0004\u0003S\u0013#AB(qi&|g\u000e\u0003\u0004\u0002\u001aB\u0001\ra\u001d\u0005\u0007\u0003;\u0003\u0002\u0019A?\u0002\u0015\u0011,G.\u001a;f\rJ|W\u000e\u0006\u0004\u0002\u0016\u0006M\u0016Q\u0017\u0005\u0007\u00033\u000b\u0002\u0019A:\t\r\u0005]\u0016\u00031\u0001~\u00031!xnU3rk\u0016t7-\u001a(s\u0003]i\u0017\r_*fcV,gnY3Ge>lW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002>\u0006\rG\u0003BAR\u0003\u007fCq!!1\u0013\u0001\u0004\t)+\u0001\u0005qe\u00164\u0018n\\;t\u0011\u0015\u0011(\u00031\u0001t)\u0019\t9-!3\u0002LB\u0019Q\u000bW?\t\u000bI\u001c\u0002\u0019A:\t\u000bq\u001c\u0002\u0019A?\u0002\u001bI,\u0007\u000f\\1z\u0015>,(O\\1m))\t\t.a9\u0002f\u0006\u001d\u0018\u0011\u001e\u000b\u0005\u0003+\u000b\u0019\u000eC\u0004\u0002VR\u0001\r!a6\u0002\u001dI,\u0007\u000f\\1z\u0007\u0006dGNY1dWB9\u0011%!7\u0002^\u0006%\u0015bAAnE\tIa)\u001e8di&|g.\r\t\u0005\u0003W\ny.\u0003\u0003\u0002b\u00065$A\u0004)feNL7\u000f^3oiJ+\u0007O\u001d\u0005\u0006eR\u0001\ra\u001d\u0005\u0006yR\u0001\r! \u0005\u0007\u0003\u0007!\u0002\u0019A?\t\r\u0005=B\u00031\u0001~\u0001")
public class ScalaDriverPersistenceJournaller
implements MongoPersistenceJournallingApi {
    private final ScalaMongoDriver driver;
    private final Logger logger;
    private final WriteConcern writeConcern;

    public <T> scala.collection.immutable.Seq<Try<BoxedUnit>> squashToUnit(scala.collection.immutable.Seq<Try<T>> seq) {
        return MongoPersistenceJournallingApi.squashToUnit$((MongoPersistenceJournallingApi)this, seq);
    }

    public ScalaMongoDriver driver() {
        return this.driver;
    }

    public Logger logger() {
        return this.logger;
    }

    private Future<MongoCollection<BsonDocument>> journal() {
        return this.driver().journal().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withWriteConcern(this.driver().journalWriteConcern()), this.driver().pluginDispatcher());
    }

    public Future<MongoCollection<BsonDocument>> akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$realtime() {
        return this.driver().realtime();
    }

    private Future<MongoCollection<BsonDocument>> metadata() {
        return this.driver().metadata().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.withWriteConcern(this.driver().metadataWriteConcern()), this.driver().pluginDispatcher());
    }

    private Bson journalRangeQuery(String pid, long from, long to) {
        return Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)pid), Filters$.MODULE$.gte("from", (Object)BoxesRunTime.boxToLong((long)from)), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)to))}));
    }

    public Source<Event, NotUsed> journalRange(String pid, long from, long to, int max) {
        Future journal = this.driver().getJournal(pid);
        Source source2 = (Source)Source$.MODULE$.future(journal).flatMapConcat((Function1 & Serializable & scala.Serializable)x$3 -> (Source)RxStreamsInterop$.MODULE$.ObservableAdapter(x$3.find(this.journalRangeQuery(pid, from, to), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).sort(Sorts$.MODULE$.ascending((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to"}))).projection(Projections$.MODULE$.include((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"events"})))).asAkka().take((long)max));
        Flow flow = (Flow)Flow$.MODULE$.apply().mapConcat((Function1 & Serializable & scala.Serializable)e -> (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)e.get((Object)"events")).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isArray())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.asArray()).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getValues()).asScala()).toList().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaDriverPersistenceJournaller $outer;

            public final <A1 extends BsonValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BsonDocument) {
                    BsonDocument bsonDocument = (BsonDocument)A1;
                    return (B1)this.$outer.driver().deserializeJournal(bsonDocument, this.$outer.driver().ScalaSerializers().Deserializer());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(BsonValue x1) {
                BsonValue bsonValue = x1;
                return bsonValue instanceof BsonDocument;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ScalaDriverPersistenceJournaller.$anonfun$journalRange$7(from, x$7))).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ScalaDriverPersistenceJournaller.$anonfun$journalRange$8(to, x$8)));
        return source2.via((Graph)flow);
    }

    private scala.collection.immutable.Seq<Try<BsonDocument>> buildBatch(scala.collection.immutable.Seq<AtomicWrite> writes) {
        return (scala.collection.immutable.Seq)writes.map((Function1 & Serializable & scala.Serializable)aw -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (BsonDocument)this.driver().serializeJournal(Atom$.MODULE$.apply(aw, this.driver().useLegacySerialization(), this.driver().ScalaSerializers().serialization(), ManifestFactory$.MODULE$.classType(BsonValue.class), this.driver().ScalaSerializers().dt(), this.driver().ScalaSerializers().loader()), this.driver().ScalaSerializers().Serializer())), Seq$.MODULE$.canBuildFrom());
    }

    public Future<scala.collection.immutable.Seq<Try<BsonDocument>>> akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend(scala.collection.immutable.Seq<Try<BsonDocument>> batch, Future<MongoCollection<BsonDocument>> collection) {
        if (batch.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isSuccess()))) {
            scala.collection.immutable.Seq collected = (scala.collection.immutable.Seq)batch.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Try<BsonDocument>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        Success success = (Success)A1;
                        BsonDocument doc = (BsonDocument)success.value();
                        return (B1)package.InsertOneModel$.MODULE$.apply((Object)doc);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Try<BsonDocument> x1) {
                    Try<BsonDocument> try_ = x1;
                    return try_ instanceof Success;
                }
            }, Seq$.MODULE$.canBuildFrom());
            return collection.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> x$10.withWriteConcern($this.writeConcern).bulkWrite((Seq)collected, new BulkWriteOptions().ordered(true))).toFuture().map((Function1 & Serializable & scala.Serializable)x$11 -> batch, this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
        }
        return Future$.MODULE$.sequence((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Success success;
            BsonDocument document;
            Try try_ = x0$1;
            if (try_ instanceof Success && (document = (BsonDocument)(success = (Success)try_).value()) != null) {
                BsonDocument bsonDocument = document;
                return collection.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> x$12.withWriteConcern($this.writeConcern).insertOne((Object)bsonDocument)).toFuture().map((Function1 & Serializable & scala.Serializable)x$13 -> new Success((Object)bsonDocument), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                return Future$.MODULE$.successful((Object)new Failure(failure.exception()));
            }
            throw new MatchError((Object)try_);
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), this.driver().pluginDispatcher());
    }

    public Future<scala.collection.immutable.Seq<Try<BoxedUnit>>> batchAppend(scala.collection.immutable.Seq<AtomicWrite> writes) {
        Future batchFuture;
        Future future;
        if (this.driver().useSuffixedCollectionNames()) {
            Future fZero = Future$.MODULE$.successful((Object)Nil$.MODULE$);
            future = (Future)writes.groupBy((Function1 & Serializable & scala.Serializable)write -> this.driver().getJournalCollectionName(write.persistenceId())).foldLeft((Object)fZero, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Future future = (Future)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        scala.collection.immutable.Seq hunk = (scala.collection.immutable.Seq)tuple22._2();
                        return future.map((Function1 & Serializable & scala.Serializable)prev -> {
                            scala.collection.immutable.Seq<Try<BsonDocument>> batch = this.buildBatch((scala.collection.immutable.Seq<AtomicWrite>)hunk);
                            return new Tuple2(prev, batch);
                        }, this.driver().pluginDispatcher()).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
                            Tuple2 tuple2 = x$14;
                            if (tuple2 != null) {
                                scala.collection.immutable.Seq prev = (scala.collection.immutable.Seq)tuple2._1();
                                scala.collection.immutable.Seq batch = (scala.collection.immutable.Seq)tuple2._2();
                                return this.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend((scala.collection.immutable.Seq<Try<BsonDocument>>)batch, (Future<MongoCollection<BsonDocument>>)this.driver().journal(((AtomicWrite)hunk.head()).persistenceId())).map((Function1 & Serializable & scala.Serializable)next -> (scala.collection.immutable.Seq)prev.$plus$plus((GenTraversableOnce)next, Seq$.MODULE$.canBuildFrom()), this.driver().pluginDispatcher());
                            }
                            throw new MatchError((Object)tuple2);
                        }, this.driver().pluginDispatcher());
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            scala.collection.immutable.Seq<Try<BsonDocument>> batch = this.buildBatch(writes);
            future = batchFuture = this.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend(batch, this.journal());
        }
        if (this.driver().realtimeEnablePersistence()) {
            return batchFuture.andThen((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ScalaDriverPersistenceJournaller $outer;

                public final <A1 extends Try<scala.collection.immutable.Seq<Try<BsonDocument>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        Success success = (Success)A1;
                        scala.collection.immutable.Seq batch = (scala.collection.immutable.Seq)success.value();
                        Future<scala.collection.immutable.Seq<Try<BsonDocument>>> f = this.$outer.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$doBatchAppend((scala.collection.immutable.Seq<Try<BsonDocument>>)batch, this.$outer.akka$contrib$persistence$mongodb$ScalaDriverPersistenceJournaller$$realtime());
                        f.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            $anonfun$batchAppend$6.$anonfun$applyOrElse$1(this, x0$1);
                            return BoxedUnit.UNIT;
                        }, this.$outer.driver().pluginDispatcher());
                        return (B1)f;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Try<scala.collection.immutable.Seq<Try<BsonDocument>>> x1) {
                    Try<scala.collection.immutable.Seq<Try<BsonDocument>>> try_ = x1;
                    return try_ instanceof Success;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$batchAppend$6 $this, Try x0$1) {
                    Try try_ = x0$1;
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        $this.$outer.logger().error("Error during write to realtime collection", t);
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(akka.contrib.persistence.mongodb.ScalaDriverPersistenceJournaller$$anonfun$batchAppend$6 scala.util.Try )}, serializedLambda);
                }
            }, this.driver().pluginDispatcher()).map((Function1 & Serializable & scala.Serializable)seq -> this.squashToUnit((scala.collection.immutable.Seq)seq), this.driver().pluginDispatcher());
        }
        return batchFuture.map((Function1 & Serializable & scala.Serializable)seq -> this.squashToUnit((scala.collection.immutable.Seq)seq), this.driver().pluginDispatcher());
    }

    private Future<BoxedUnit> setMaxSequenceMetadata(String persistenceId, long maxSequenceNr) {
        return this.metadata().flatMap((Function1 & Serializable & scala.Serializable)md -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> md.updateOne(Filters$.MODULE$.equal("pid", (Object)persistenceId), Updates$.MODULE$.combine((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.setOnInsert("pid", (Object)persistenceId), Updates$.MODULE$.setOnInsert("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))})), new UpdateOptions().upsert(true))).toFuture().flatMap((Function1 & Serializable & scala.Serializable)_2 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> md.updateOne(Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))})), Updates$.MODULE$.set("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)), new UpdateOptions().upsert(false))).toFuture().map((Function1 & Serializable & scala.Serializable)_ -> {
            ScalaDriverPersistenceJournaller.$anonfun$setMaxSequenceMetadata$5(_);
            return BoxedUnit.UNIT;
        }, this.driver().pluginDispatcher()), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    private Future<Option<Object>> findMaxSequence(String persistenceId, long maxSequenceNr) {
        return this.driver().getJournal(persistenceId).flatMap((Function1 & Serializable & scala.Serializable)j -> this.performAggregation$1((MongoCollection)j, persistenceId, maxSequenceNr).map((Function1 & Serializable & scala.Serializable)rez -> rez, this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    public Future<BoxedUnit> deleteFrom(String persistenceId, long toSequenceNr) {
        return this.driver().getJournal(persistenceId).flatMap((Function1 & Serializable & scala.Serializable)journal -> this.findMaxSequence(persistenceId, toSequenceNr).flatMap((Function1 & Serializable & scala.Serializable)ms -> ((Future)ms.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable & scala.Serializable)x$22 -> this.setMaxSequenceMetadata(persistenceId, BoxesRunTime.unboxToLong((Object)x$22)))).map((Function1 & Serializable & scala.Serializable)x$24 -> {
            Bson docWithAllEventsToRemove = Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)toSequenceNr))}));
            return new Tuple2(x$24, (Object)docWithAllEventsToRemove);
        }, this.driver().pluginDispatcher()).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> {
            Tuple2 tuple2 = x$26;
            if (tuple2 != null) {
                Bson docWithAllEventsToRemove = (Bson)tuple2._2();
                return org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> journal.deleteMany(docWithAllEventsToRemove)).toFuture().map((Function1 & Serializable & scala.Serializable)removed -> {
                    Bson query = this.journalRangeQuery(persistenceId, toSequenceNr, toSequenceNr);
                    Bson update = Updates$.MODULE$.combine((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.pull("events", (Object)Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("sn", (Object)BoxesRunTime.boxToLong((long)toSequenceNr))}))), Updates$.MODULE$.set("from", (Object)BoxesRunTime.boxToLong((long)(toSequenceNr + 1L)))}));
                    return new Tuple3(removed, (Object)query, (Object)update);
                }, this.driver().pluginDispatcher()).flatMap((Function1 & Serializable & scala.Serializable)x$25 -> {
                    Tuple3 tuple3 = x$25;
                    if (tuple3 != null) {
                        DeleteResult removed = (DeleteResult)tuple3._1();
                        Bson query = (Bson)tuple3._2();
                        Bson update = (Bson)tuple3._3();
                        return org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> journal.withWriteConcern($this.writeConcern).updateMany(query, update, new UpdateOptions().upsert(false))).toFuture().recover((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof MongoWriteException) {
                                    MongoWriteException mongoWriteException = (MongoWriteException)A1;
                                    ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                                    ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                                    if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) {
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable = x1;
                                if (throwable instanceof MongoWriteException) {
                                    MongoWriteException mongoWriteException = (MongoWriteException)throwable;
                                    ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                                    ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                                    if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        }, this.driver().pluginDispatcher()).map((Function1 & Serializable & scala.Serializable)_ -> {
                            object = this.driver().useSuffixedCollectionNames() && this.driver().suffixDropEmpty() && removed.wasAcknowledged() ? this.driver().removeEmptyJournal(journal).map((Function1 & Serializable & scala.Serializable)x$23 -> {
                                ScalaDriverPersistenceJournaller.$anonfun$deleteFrom$12($this, persistenceId$3, x$23);
                                return BoxedUnit.UNIT;
                            }, this.driver().pluginDispatcher()) : BoxedUnit.UNIT;
                            return BoxedUnit.UNIT;
                        }, this.driver().pluginDispatcher());
                    }
                    throw new MatchError((Object)tuple3);
                }, this.driver().pluginDispatcher());
            }
            throw new MatchError((Object)tuple2);
        }, this.driver().pluginDispatcher()), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    private Future<Option<Object>> maxSequenceFromMetadata(String pid, Option<Object> previous) {
        return (Future)previous.fold((Function0 & Serializable & scala.Serializable)() -> this.metadata().flatMap((Function1 & Serializable & scala.Serializable)x$27 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> x$27.find((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).projection((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_sn"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).first()).toFutureOption().map((Function1 & Serializable & scala.Serializable)d -> d.flatMap((Function1 & Serializable & scala.Serializable)l -> Option$.MODULE$.apply((Object)l.asDocument().get((Object)"max_sn")).filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)x$28.isInt64())).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.asInt64()).map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToLong((long)x$30.getValue()))), this.driver().pluginDispatcher()), this.driver().pluginDispatcher()), (Function1 & Serializable & scala.Serializable)l -> Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)l)))));
    }

    public Future<Object> maxSequenceNr(String pid, long from) {
        Future journal = this.driver().getJournal(pid);
        return journal.flatMap((Function1 & Serializable & scala.Serializable)x$31 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> x$31.find((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).projection((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).sort((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt()), BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)-1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).first()).toFutureOption().map((Function1 & Serializable & scala.Serializable)d -> d.flatMap((Function1 & Serializable & scala.Serializable)a -> Option$.MODULE$.apply((Object)a.asDocument().get((Object)"to")).filter((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.isInt64())).map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.asInt64()).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.getValue()))), this.driver().pluginDispatcher()).flatMap((Function1 & Serializable & scala.Serializable)x$35 -> this.maxSequenceFromMetadata(pid, (Option<Object>)x$35), this.driver().pluginDispatcher()).map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToLong((long)ScalaDriverPersistenceJournaller.$anonfun$maxSequenceNr$9(x$36)), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    public Future<BoxedUnit> replayJournal(String pid, long from, long to, long max, Function1<PersistentRepr, BoxedUnit> replayCallback) {
        if (max == 0L) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        int maxInt = package.NonWrappingLongToInt$.MODULE$.toIntWithoutWrapping$extension(package$.MODULE$.NonWrappingLongToInt(max));
        return ((Future)((Source)this.journalRange(pid, from, to, maxInt).map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.toRepr())).runWith((Graph)Sink$.MODULE$.foreach(replayCallback), this.driver().materializer())).map((Function1 & Serializable & scala.Serializable)x$38 -> {
            ScalaDriverPersistenceJournaller.$anonfun$replayJournal$2(x$38);
            return BoxedUnit.UNIT;
        }, this.driver().pluginDispatcher());
    }

    public static final /* synthetic */ boolean $anonfun$journalRange$7(long from$1, Event x$7) {
        return x$7.sn() >= from$1;
    }

    public static final /* synthetic */ boolean $anonfun$journalRange$8(long to$1, Event x$8) {
        return x$8.sn() <= to$1;
    }

    public static final /* synthetic */ void $anonfun$setMaxSequenceMetadata$5(UpdateResult _) {
    }

    private final Future performAggregation$1(MongoCollection j, String persistenceId$2, long maxSequenceNr$2) {
        return org.mongodb.scala.package$.MODULE$.ObservableFuture((Function0 & Serializable & scala.Serializable)() -> {
            Bson bson = Aggregates$.MODULE$.match(Filters$.MODULE$.and((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId$2), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr$2))})));
            Bson bson2 = Aggregates$.MODULE$.group((Object)new StringBuilder(4).append("$").append("pid").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonField[]{Accumulators$.MODULE$.max("max", (Object)new StringBuilder(3).append("$").append("to").toString())}));
            return j.aggregate((Seq)Nil$.MODULE$.$colon$colon((Object)bson2).$colon$colon((Object)bson), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class));
        }).toFuture().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.headOption(), this.driver().pluginDispatcher()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.flatMap((Function1 & Serializable & scala.Serializable)l -> Option$.MODULE$.apply((Object)l.asDocument().get((Object)"max")).filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isInt64())).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.asInt64()).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.getValue()))), this.driver().pluginDispatcher());
    }

    public static final /* synthetic */ void $anonfun$deleteFrom$12(ScalaDriverPersistenceJournaller $this, String persistenceId$3, BoxedUnit x$23) {
        $this.driver().removeJournalInCache(persistenceId$3);
    }

    public static final /* synthetic */ long $anonfun$maxSequenceNr$9(Option x$36) {
        return BoxesRunTime.unboxToLong((Object)x$36.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$replayJournal$2(Done x$38) {
    }

    public ScalaDriverPersistenceJournaller(ScalaMongoDriver driver) {
        this.driver = driver;
        MongoPersistenceJournallingApi.$init$((MongoPersistenceJournallingApi)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.writeConcern = driver.journalWriteConcern();
    }
}

