/*
 * Decompiled with CFR 0.152.
 */
package akka.contrib.persistence.mongodb;

import akka.actor.ActorSystem;
import akka.contrib.persistence.mongodb.MongoErrors;
import akka.contrib.persistence.mongodb.MongoPersistenceDriver;
import akka.contrib.persistence.mongodb.ScalaDriverSerializers;
import akka.contrib.persistence.mongodb.ScalaDriverSerializersExtension$;
import akka.contrib.persistence.mongodb.ScalaDriverSettings;
import akka.contrib.persistence.mongodb.ScalaDriverSettings$;
import akka.contrib.persistence.mongodb.ServerVersion;
import akka.contrib.persistence.mongodb.ServerVersion$;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.IndexOptions;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.WriteConcern$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Indexes$;
import org.mongodb.scala.model.package;
import org.mongodb.scala.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001\u0002\u0010 \u0001!B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)a\b\u0001C\u0001\u007f\u0015!1\t\u0001\u0011E\u000b\u0011\t\u0007\u0001I'\t\u000f\t\u0004!\u0019!C\u0001G\"1q\r\u0001Q\u0001\n\u0011Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u00191\b\u0001)A\u0005a\"Aq\u000f\u0001EC\u0002\u0013\u0005\u0001\u0010\u0003\u0005}\u0001!\u0015\r\u0011\"\u0001~\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\f\u0001\t\u0003\ny\u0003\u0003\u0005\u0002.\u0001\u0001K\u0011BA\u001a\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!a\u0019\u0001\t\u0003\tY\u0006C\u0004\u0002f\u0001!\t!a\u0017\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u0015\u0001\u0005B\u0005%\u0006\u0002CAW\u0001\u0001&I!a,\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007\u0002CAj\u0001\u0001&I!!6\t\u0011\u0005\u0015\b\u0001)C\u0005\u0003ODq!a>\u0001\t\u0003\nI\u0010C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\t5\u0002\u0001\"\u0011\u00030\t\u00012kY1mC6{gnZ8Ee&4XM\u001d\u0006\u0003A\u0005\nq!\\8oO>$'M\u0003\u0002#G\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t!S%A\u0004d_:$(/\u001b2\u000b\u0003\u0019\nA!Y6lC\u000e\u00011C\u0001\u0001*!\tQ3&D\u0001 \u0013\tasD\u0001\fN_:<w\u000eU3sg&\u001cH/\u001a8dK\u0012\u0013\u0018N^3s\u0003\u0019\u0019\u0018p\u001d;f[B\u0011qFM\u0007\u0002a)\u0011\u0011'J\u0001\u0006C\u000e$xN]\u0005\u0003gA\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u000611m\u001c8gS\u001e\u0004\"A\u000e\u001f\u000e\u0003]R!\u0001\u000e\u001d\u000b\u0005eR\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\n1aY8n\u0013\titG\u0001\u0004D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\u000b%\t\u0005\u0002+\u0001!)Qf\u0001a\u0001]!)Ag\u0001a\u0001k\t\t1\tE\u0002F\u00176k\u0011A\u0012\u0006\u0003\u000f\"\u000bQa]2bY\u0006T!\u0001I%\u000b\u0003)\u000b1a\u001c:h\u0013\taeIA\bN_:<wnQ8mY\u0016\u001cG/[8o!\tqeL\u0004\u0002P7:\u0011\u0001+\u0017\b\u0003#bs!AU,\u000f\u0005M3V\"\u0001+\u000b\u0005U;\u0013A\u0002\u001fs_>$h(C\u0001K\u0013\t\u0001\u0013*\u0003\u0002H\u0011&\u0011!LR\u0001\u0005EN|g.\u0003\u0002];\u00069\u0001/Y2lC\u001e,'B\u0001.G\u0013\ty\u0006M\u0001\u0007Cg>tGi\\2v[\u0016tGO\u0003\u0002];\n\tA)\u0001\tTG\u0006d\u0017mU3sS\u0006d\u0017N_3sgV\tA\r\u0005\u0002+K&\u0011am\b\u0002\u0017'\u000e\fG.\u0019#sSZ,'oU3sS\u0006d\u0017N_3sg\u0006\t2kY1mCN+'/[1mSj,'o\u001d\u0011\u0002'M\u001c\u0017\r\\1Ee&4XM]*fiRLgnZ:\u0016\u0003)\u0004\"AK6\n\u00051|\"aE*dC2\fGI]5wKJ\u001cV\r\u001e;j]\u001e\u001c\u0018\u0001F:dC2\fGI]5wKJ\u001cV\r\u001e;j]\u001e\u001c\b%A\nn_:<wn\u00117jK:$8+\u001a;uS:<7/F\u0001q!\t\t8O\u0004\u0002Qe&\u0011ALR\u0005\u0003iV\u00141#T8oO>\u001cE.[3oiN+G\u000f^5oONT!\u0001\u0018$\u0002)5|gnZ8DY&,g\u000e^*fiRLgnZ:!\u0003\u0019\u0019G.[3oiV\t\u0011\u0010\u0005\u0002Fu&\u00111P\u0012\u0002\f\u001b>twm\\\"mS\u0016tG/\u0001\u0002eEV\ta\u0010\u0005\u0002F\u007f&\u0019\u0011\u0011\u0001$\u0003\u001b5{gnZ8ECR\f'-Y:f\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u000b\u0005\u0003\u000f\tI\u0002\u0005\u0004\u0002\n\u0005E\u0011QC\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003\u001dKA!a\u0005\u0002\f\t1a)\u001e;ve\u0016\u00042!a\u0006\u0005\u001b\u0005\u0001\u0001bBA\u000e\u001d\u0001\u0007\u0011QD\u0001\u0005]\u0006lW\r\u0005\u0003\u0002 \u0005\u001db\u0002BA\u0011\u0003G\u00012aUA\b\u0013\u0011\t)#a\u0004\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\u0011\t)#a\u0004\u0002!\u0015t7/\u001e:f\u0007>dG.Z2uS>tG\u0003BA\u0004\u0003cAq!a\u0007\u0010\u0001\u0004\ti\u0002\u0006\u0004\u0002\b\u0005U\u0012q\u0007\u0005\b\u00037\u0001\u0002\u0019AA\u000f\u0011\u001d\tI\u0004\u0005a\u0001\u0003w\t\u0011cY8mY\u0016\u001cG/[8o\u0007J,\u0017\r^8s!!\ti$a\u0010\u0002\u001e\u0005\rSBAA\b\u0013\u0011\t\t%a\u0004\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#B#\u0002F\u0005%\u0013bAA$\r\n\u00012+\u001b8hY\u0016|%m]3sm\u0006\u0014G.\u001a\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0016\u0002N\t!ak\\5e\u0003MQw.\u001e:oC2<&/\u001b;f\u0007>t7-\u001a:o+\t\ti\u0006E\u0002r\u0003?J1!!\u0019v\u000519&/\u001b;f\u0007>t7-\u001a:o\u0003E\u0019h.\u00199t/JLG/Z\"p]\u000e,'O\\\u0001\u0015[\u0016$\u0018\rZ1uC^\u0013\u0018\u000e^3D_:\u001cWM\u001d8\u0002\u001dQ|wK]5uK\u000e{gnY3s]RA\u0011QLA6\u0003\u001b\u000bi\nC\u0004\u0002nQ\u0001\r!a\u001c\u0002\u0017]\u0014\u0018\u000e^3TC\u001a,G/\u001f\t\u0005\u0003c\n9I\u0004\u0003\u0002t\u0005\re\u0002BA;\u0003\u0003sA!a\u001e\u0002\u00009!\u0011\u0011PA?\u001d\r\u0019\u00161P\u0005\u0002M%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0007\u0005\u0015u$\u0001\fN_:<w\u000eU3sg&\u001cH/\u001a8dK\u0012\u0013\u0018N^3s\u0013\u0011\tI)a#\u0003\u0017]\u0013\u0018\u000e^3TC\u001a,G/\u001f\u0006\u0004\u0003\u000b{\u0002bBAH)\u0001\u0007\u0011\u0011S\u0001\toRLW.Z8viB!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006-\u0011\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011q\u0014\u000bA\u0002\u0005\u0005\u0016!\u00024ts:\u001c\u0007\u0003BA\u001f\u0003GKA!!*\u0002\u0010\t9!i\\8mK\u0006t\u0017\u0001E2baB,GmQ8mY\u0016\u001cG/[8o)\u0011\t9!a+\t\u000f\u0005mQ\u00031\u0001\u0002\u001e\u0005\u0011\u0012n]\"baB,GmQ8mY\u0016\u001cG/[8o)\u0011\t\t,a-\u0011\r\u0005%\u0011\u0011CAQ\u0011\u001d\t)L\u0006a\u0001\u0003;\tabY8mY\u0016\u001cG/[8o\u001d\u0006lW-A\bd_2dWm\u0019;j_:t\u0015-\\3t+\t\tY\f\u0005\u0004\u0002\n\u0005E\u0011Q\u0018\t\u0007\u0003\u007f\u000b9-!\b\u000f\t\u0005\u0005\u0017Q\u0019\b\u0004'\u0006\r\u0017\"A$\n\u0007q\u000by!\u0003\u0003\u0002J\u0006-'\u0001\u0002'jgRT1\u0001XA\b\u0003q9W\r^'p]\u001e|g+\u001a:tS>tgI]8n\u0005VLG\u000eZ%oM>,\"!!5\u0011\r\u0005%\u0011\u0011CA\u000f\u000359W\r\u001e'pG\u0006d7i\\;oiR!\u0011q[Ap!\u0019\tI!!\u0005\u0002ZB!\u0011QHAn\u0013\u0011\ti.a\u0004\u0003\t1{gn\u001a\u0005\b\u0003\u0007I\u0002\u0019AAq!\u0011)5*a9\u0011\u0007\u0005]Q!\u0001\bhKRLe\u000eZ3y\u0003N\u00145o\u001c8\u0015\r\u0005%\u0018\u0011_Az!\u0019\tI!!\u0005\u0002lB)\u0011QHAw\u001b&!\u0011q^A\b\u0005\u0019y\u0005\u000f^5p]\"9\u00111\u0001\u000eA\u0002\u0005\u0005\bbBA{5\u0001\u0007\u0011QD\u0001\nS:$W\r\u001f(b[\u0016\fQC]3n_Z,W)\u001c9us\u000e{G\u000e\\3di&|g\u000e\u0006\u0004\u0002|\n\r!Q\u0001\t\u0007\u0003\u0013\t\t\"!@\u0011\t\u0005u\u0012q`\u0005\u0005\u0005\u0003\tyA\u0001\u0003V]&$\bbBA\u00027\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003k\\\u0002\u0019AA\u000f\u0003-)gn];sK&sG-\u001a=\u0015\u0015\t-!Q\u0002B\b\u0005'\u00119\u0002\u0005\u0005\u0002>\u0005}\u0012QCA\u0004\u0011\u001d\t)\u0010\ba\u0001\u0003;AqA!\u0005\u001d\u0001\u0004\t\t+\u0001\u0004v]&\fX/\u001a\u0005\b\u0005+a\u0002\u0019AAQ\u0003\u0019\u0019\b/\u0019:tK\"9!\u0011\u0004\u000fA\u0002\tm\u0011A\u00024jK2$7\u000f\u0005\u0004\u0002>\tu!\u0011E\u0005\u0005\u0005?\tyA\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\u0002\"!\u0010\u0003$\u0005u!qE\u0005\u0005\u0005K\tyA\u0001\u0004UkBdWM\r\t\u0005\u0003{\u0011I#\u0003\u0003\u0003,\u0005=!aA%oi\u0006\u00012\r\\8tK\u000e{gN\\3di&|gn\u001d\u000b\u0003\u0003{\u0004")
public class ScalaMongoDriver
extends MongoPersistenceDriver {
    private MongoClient client;
    private MongoDatabase db;
    private final ScalaDriverSerializers ScalaSerializers;
    private final ScalaDriverSettings scalaDriverSettings;
    private final MongoClientSettings mongoClientSettings;
    private volatile byte bitmap$0;

    public ScalaDriverSerializers ScalaSerializers() {
        return this.ScalaSerializers;
    }

    public ScalaDriverSettings scalaDriverSettings() {
        return this.scalaDriverSettings;
    }

    public MongoClientSettings mongoClientSettings() {
        return this.mongoClientSettings;
    }

    private MongoClient client$lzycompute() {
        ScalaMongoDriver scalaMongoDriver = this;
        synchronized (scalaMongoDriver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.client = MongoClient$.MODULE$.apply(this.mongoClientSettings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.client;
    }

    public MongoClient client() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.client$lzycompute();
        }
        return this.client;
    }

    private MongoDatabase db$lzycompute() {
        ScalaMongoDriver scalaMongoDriver = this;
        synchronized (scalaMongoDriver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String dbName = (String)this.databaseName().orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)new ConnectionString(this.mongoUri()).getDatabase())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.DEFAULT_DB_NAME());
                this.db = this.client().getDatabase(dbName);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    public MongoDatabase db() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.db$lzycompute();
        }
        return this.db;
    }

    public Future<MongoCollection<BsonDocument>> collection(String name) {
        return Future$.MODULE$.successful((Object)this.db().getCollection(name, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)));
    }

    public Future<MongoCollection<BsonDocument>> ensureCollection(String name) {
        return this.ensureCollection(name, (Function1<String, SingleObservable<Void>>)(Function1 & Serializable & scala.Serializable)collectionName -> this.db().createCollection(collectionName));
    }

    private Future<MongoCollection<BsonDocument>> ensureCollection(String name, Function1<String, SingleObservable<Void>> collectionCreator) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> (SingleObservable)collectionCreator.apply((Object)name)).toFuture().recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                MongoCommandException mongoCommandException;
                A1 A1 = x1;
                if (A1 instanceof MongoCommandException && MongoErrors.NamespaceExists$.MODULE$.unapply(mongoCommandException = (MongoCommandException)A1)) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                MongoCommandException mongoCommandException;
                Throwable throwable = x1;
                return throwable instanceof MongoCommandException && MongoErrors.NamespaceExists$.MODULE$.unapply(mongoCommandException = (MongoCommandException)throwable);
            }
        }, this.pluginDispatcher()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.collection(name).map((Function1 & Serializable & scala.Serializable)mongoCollection -> mongoCollection, this.pluginDispatcher()), this.pluginDispatcher());
    }

    public WriteConcern journalWriteConcern() {
        return this.toWriteConcern(this.journalWriteSafety(), (Duration)this.journalWTimeout(), this.journalFsync());
    }

    public WriteConcern snapsWriteConcern() {
        return this.toWriteConcern(this.snapsWriteSafety(), (Duration)this.snapsWTimeout(), this.snapsFsync());
    }

    public WriteConcern metadataWriteConcern() {
        return this.toWriteConcern(this.journalWriteSafety(), (Duration)this.journalWTimeout(), this.journalFsync());
    }

    private WriteConcern toWriteConcern(MongoPersistenceDriver.WriteSafety writeSafety, Duration wtimeout, boolean fsync) {
        Tuple3 tuple3 = new Tuple3((Object)writeSafety, (Object)BoxesRunTime.boxToLong((long)wtimeout.toMillis()), (Object)BoxesRunTime.boxToBoolean((boolean)fsync));
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety2 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver.Unacknowledged$.MODULE$.equals(writeSafety2)) {
                return WriteConcern$.MODULE$.UNACKNOWLEDGED().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety3 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver.Acknowledged$.MODULE$.equals(writeSafety3)) {
                return WriteConcern$.MODULE$.ACKNOWLEDGED().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety4 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver.Journaled$.MODULE$.equals(writeSafety4)) {
                return WriteConcern$.MODULE$.JOURNALED().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety5 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            boolean f = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (MongoPersistenceDriver.ReplicaAcknowledged$.MODULE$.equals(writeSafety5)) {
                return WriteConcern$.MODULE$.MAJORITY().withWTimeout(w, TimeUnit.MILLISECONDS).withJournal(Predef$.MODULE$.boolean2Boolean(!f));
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public Future<MongoCollection<BsonDocument>> cappedCollection(String name) {
        Function1 & Serializable & scala.Serializable cappedCollectionCreator = (Function1 & Serializable & scala.Serializable)ccName -> this.db().createCollection(ccName, new CreateCollectionOptions().capped(true).sizeInBytes(this.realtimeCollectionSize()));
        return this.ensureCollection(name, (Function1<String, SingleObservable<Void>>)cappedCollectionCreator).flatMap((Function1 & Serializable & scala.Serializable)collection -> this.isCappedCollection(name).flatMap((Function1 & Serializable & scala.Serializable)capped -> ScalaMongoDriver.$anonfun$cappedCollection$6(this, collection, name, cappedCollectionCreator, BoxesRunTime.unboxToBoolean((Object)capped)), this.pluginDispatcher()), this.pluginDispatcher());
    }

    private Future<Object> isCappedCollection(String collectionName) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> this.db().runCommand((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collStats"), (Object)collectionName), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture().map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToBoolean((boolean)ScalaMongoDriver.$anonfun$isCappedCollection$2(stats)), this.pluginDispatcher());
    }

    public Future<List<String>> collectionNames() {
        return package$.MODULE$.ObservableFuture((Function0 & Serializable & scala.Serializable)() -> this.db().listCollectionNames()).toFuture().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toList(), this.pluginDispatcher());
    }

    public Future<String> getMongoVersionFromBuildInfo() {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> this.db().runCommand((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildInfo"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture().map((Function1 & Serializable & scala.Serializable)x$3 -> ((BsonValue)x$3.get("version", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).getOrElse((Function0 & Serializable & scala.Serializable)() -> BsonString$.MODULE$.apply(""))).asString().getValue(), this.pluginDispatcher());
    }

    private Future<Object> getLocalCount(MongoCollection<BsonDocument> collection) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> this.db().runCommand((Bson)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)String.valueOf(collection.namespace().getCollectionName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformString()), BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readConcern"), (Object)BsonDocument$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"level"), (Object)"local"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())}))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ScalaMongoDriver.$anonfun$getLocalCount$2(x$4)), this.pluginDispatcher());
    }

    private Future<Option<BsonDocument>> getIndexAsBson(MongoCollection<BsonDocument> collection, String indexName) {
        return package$.MODULE$.ObservableFuture((Function0 & Serializable & scala.Serializable)() -> collection.listIndexes(DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class))).toFuture().map((Function1 & Serializable & scala.Serializable)indexList -> {
            None$ none$;
            Option indexDoc = indexList.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScalaMongoDriver.$anonfun$getIndexAsBson$3(indexName, x$5)));
            Option option = indexDoc;
            if (option instanceof Some) {
                Some some = (Some)option;
                BsonDocument doc = (BsonDocument)some.value();
                none$ = new Some((Object)doc.get((Object)"key").asDocument());
            } else if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            None$ indexKey = none$;
            return new Tuple3(indexList, (Object)indexDoc, (Object)indexKey);
        }, this.pluginDispatcher()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple3 tuple3 = x$6;
            if (tuple3 != null) {
                Option indexKey = (Option)tuple3._3();
                return indexKey;
            }
            throw new MatchError((Object)tuple3);
        }, this.pluginDispatcher());
    }

    public Future<BoxedUnit> removeEmptyCollection(MongoCollection<BsonDocument> collection, String indexName) {
        return this.mongoVersion().flatMap((Function1 & Serializable & scala.Serializable)version -> (version.atLeast((ServerVersion)new ServerVersion.4$u002E0("3")) ? package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> collection.estimatedDocumentCount()).toFuture() : this.getLocalCount(collection)).flatMap((Function1 & Serializable & scala.Serializable)firstCount -> ScalaMongoDriver.$anonfun$removeEmptyCollection$3(this, collection, indexName, version, BoxesRunTime.unboxToLong((Object)firstCount)), this.pluginDispatcher()), this.pluginDispatcher());
    }

    public Function1<MongoCollection<BsonDocument>, Future<MongoCollection<BsonDocument>>> ensureIndex(String indexName, boolean unique, boolean sparse, Seq<Tuple2<String, Object>> fields) {
        return (Function1 & Serializable & scala.Serializable)collection -> package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> collection.createIndex(Indexes$.MODULE$.compoundIndex((Seq)fields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                int d = tuple2._2$mcI$sp();
                if (d > 0) {
                    return Indexes$.MODULE$.ascending((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                }
            }
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return Indexes$.MODULE$.descending((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())), new IndexOptions().unique(unique).sparse(sparse).name(indexName))).toFuture().map((Function1 & Serializable & scala.Serializable)_ -> collection, this.pluginDispatcher());
    }

    public void closeConnections() {
        this.client().close();
    }

    private final Future recreate$1(MongoCollection collection, String name$2, Function1 cappedCollectionCreator$1) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> collection.drop()).toFuture().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.ensureCollection(name$2, (Function1<String, SingleObservable<Void>>)cappedCollectionCreator$1).map((Function1 & Serializable & scala.Serializable)recreatedCappedCollection -> recreatedCappedCollection, this.pluginDispatcher()), this.pluginDispatcher());
    }

    public static final /* synthetic */ Future $anonfun$cappedCollection$6(ScalaMongoDriver $this, MongoCollection collection$2, String name$2, Function1 cappedCollectionCreator$1, boolean capped) {
        return (capped ? Future$.MODULE$.successful((Object)collection$2) : $this.recreate$1(collection$2, name$2, cappedCollectionCreator$1)).map((Function1 & Serializable & scala.Serializable)cc -> cc, $this.pluginDispatcher());
    }

    public static final /* synthetic */ boolean $anonfun$isCappedCollection$3(BsonValue x$1) {
        return x$1.asBoolean().getValue();
    }

    public static final /* synthetic */ boolean $anonfun$isCappedCollection$2(Document stats) {
        return stats.get("capped", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaMongoDriver.$anonfun$isCappedCollection$3(x$1)));
    }

    public static final /* synthetic */ long $anonfun$getLocalCount$2(Document x$4) {
        return ((BsonValue)x$4.getOrElse("n", BsonMagnets$.MODULE$.singleToCanBeBsonValue((Object)BoxesRunTime.boxToLong((long)0L), (BsonTransformer)BsonTransformer$.MODULE$.TransformLong()))).asInt32().longValue();
    }

    public static final /* synthetic */ boolean $anonfun$getIndexAsBson$3(String indexName$1, BsonDocument x$5) {
        return x$5.get((Object)"name").asString().getValue().equals(indexName$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$removeEmptyCollection$10(ScalaMongoDriver $this, MongoCollection collection$5, long secondCount) {
        BoxedUnit x$7 = secondCount == 0L ? package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> collection$5.drop()).toFuture().recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, $this.pluginDispatcher()) : BoxedUnit.UNIT;
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)secondCount), (Object)x$7);
    }

    public static final /* synthetic */ void $anonfun$removeEmptyCollection$12(Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Future $anonfun$removeEmptyCollection$3(ScalaMongoDriver $this, MongoCollection collection$5, String indexName$2, ServerVersion version$1, long firstCount) {
        return (firstCount == 0L ? $this.getIndexAsBson((MongoCollection<BsonDocument>)collection$5, indexName$2).flatMap((Function1 & Serializable & scala.Serializable)indexKey -> (version$1.atLeast((ServerVersion)ServerVersion$.MODULE$.3$u002E6$u002E0()) ? package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> (SingleObservable)indexKey.fold((Function0 & Serializable & scala.Serializable)() -> collection$5.countDocuments(), (Function1 & Serializable & scala.Serializable)index -> collection$5.countDocuments((Bson)BsonDocument$.MODULE$.apply(), package.CountOptions$.MODULE$.apply().hint((Bson)index)))).toFuture() : package$.MODULE$.SingleObservableFuture((Function0 & Serializable & scala.Serializable)() -> collection$5.countDocuments()).toFuture()).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)count -> count, $this.pluginDispatcher()), $this.pluginDispatcher()) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)firstCount))).map((Function1 & Serializable & scala.Serializable)secondCount -> ScalaMongoDriver.$anonfun$removeEmptyCollection$10($this, collection$5, BoxesRunTime.unboxToLong((Object)secondCount)), $this.pluginDispatcher()).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            ScalaMongoDriver.$anonfun$removeEmptyCollection$12(x$8);
            return BoxedUnit.UNIT;
        }, $this.pluginDispatcher());
    }

    public ScalaMongoDriver(ActorSystem system, Config config) {
        super(system, config);
        this.ScalaSerializers = (ScalaDriverSerializers)ScalaDriverSerializersExtension$.MODULE$.apply(system);
        this.scalaDriverSettings = (ScalaDriverSettings)ScalaDriverSettings$.MODULE$.apply(system);
        this.mongoClientSettings = this.scalaDriverSettings().configure(this.mongoUri()).build();
    }
}

