/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdcxy.modules.common.util;

import com.github.sdcxy.modules.common.entity.DataSource;
import com.github.sdcxy.modules.common.enums.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DataBaseXmlUtils {
    private static final String MYSQL_URL = "jdbc:mysql://IP:PORT/DB_NAME?characterEncoding=utf8&useSSL=false&useUnicode=true&autoReconnect=true&serverTimezone=Asia/Shanghai";
    private static final String SQL_SERVER_URL = "jdbc:sqlserver://IP:PORT;DatabaseName=DB_NAME";

    private static String getDataBaseXmlPath() {
        return System.getProperty("user.dir") + "/src/main/resources/" + Constants.DEFAULT_DATABASE_XML_PATH.getValue();
    }

    @Deprecated
    public static DataSource readDataBaseXml(String dbType) {
        DataSource dataSource = new DataSource();
        String filePath = DataBaseXmlUtils.getDataBaseXmlPath();
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            catch (FileNotFoundException e) {
                System.out.println(filePath + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
        }
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            Element root = document.getRootElement();
            if (dbType.equals("mysql")) {
                Element dbTypeName = root.element("mysql");
                dataSource.setDriverClassName(Constants.MYSQL.getValue());
                dataSource.setUrl(MYSQL_URL.replace("IP", dbTypeName.elementText("ip")).replace("PORT", dbTypeName.elementText("port")).replace("DB_NAME", dbTypeName.elementText("dbName")));
                dataSource.setUsername(dbTypeName.elementText("username"));
                dataSource.setPassword(dbTypeName.elementText("password"));
            } else if (dbType.equals("sqlserver")) {
                Element dbTypeName = root.element("sqlserver");
                dataSource.setDriverClassName(Constants.SQLSERVER.getValue());
                dataSource.setUrl(SQL_SERVER_URL.replace("IP", dbTypeName.elementText("ip")).replace("PORT", dbTypeName.elementText("port")).replace("DB_NAME", dbTypeName.elementText("dbName")));
                dataSource.setUsername(dbTypeName.elementText("username"));
                dataSource.setPassword(dbTypeName.elementText("password"));
            }
        }
        catch (DocumentException e) {
            System.out.println(e.getMessage());
        }
        return dataSource;
    }

    @Deprecated
    public static void writeDataBaseXml(String dbType, DataSource dataSource) {
        String filePath = DataBaseXmlUtils.getDataBaseXmlPath();
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            catch (FileNotFoundException e) {
                System.out.println(filePath + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
        }
        try {
            String subUrl;
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            Element root = document.getRootElement();
            String url = dataSource.getUrl();
            String username = dataSource.getUsername();
            String password = dataSource.getPassword();
            if (dbType.equals("mysql")) {
                Element dbTypeName = root.element(dbType);
                subUrl = url.substring(url.indexOf("//") + 2, url.indexOf("?"));
                String ip = subUrl.substring(0, subUrl.indexOf(":"));
                String port = subUrl.substring(subUrl.indexOf(":") + 1, subUrl.indexOf("/"));
                String dbName = subUrl.substring(subUrl.indexOf("/") + 1);
                dbTypeName.element("ip").setText(ip);
                dbTypeName.element("port").setText(port);
                dbTypeName.element("dbName").setText(dbName);
                dbTypeName.element("username").setText(username);
                dbTypeName.element("password").setText(password);
            } else if (dbType.equals("sqlserver")) {
                Element dbTypeName = root.element(dbType);
                subUrl = url.substring(url.indexOf("//") + 2);
                String ip = subUrl.substring(0, subUrl.indexOf(":"));
                String port = subUrl.substring(subUrl.indexOf(":") + 1, subUrl.indexOf(";"));
                String dbName = subUrl.substring(subUrl.indexOf("=") + 1);
                dbTypeName.element("ip").setText(ip);
                dbTypeName.element("port").setText(port);
                dbTypeName.element("dbName").setText(dbName);
                dbTypeName.element("username").setText(username);
                dbTypeName.element("password").setText(password);
            }
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(file));
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

