/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdcxy.modules.generator;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqlServerTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.github.sdcxy.modules.common.entity.DataSource;
import com.github.sdcxy.modules.common.enums.Constants;
import com.github.sdcxy.modules.common.util.DataBaseXmlUtils;
import com.github.sdcxy.modules.common.util.YamlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SuperGenerator {
    private static final String MAPPER_XML_TEMPLATE = "/templates/mapper.xml.vm";
    private static final String AUTHOR = "lxx";

    private String getRootPath() {
        return System.getProperty("user.dir");
    }

    protected String getJavaPath() {
        return this.getRootPath() + "/src/main/java";
    }

    protected String getResourcePath() {
        return this.getRootPath() + "/src/main/resources";
    }

    @Deprecated
    protected DataSourceConfig getDataSourceConfig(DbType dbType) {
        DataSource dataSource = YamlUtils.readDataSourceYaml();
        if (dataSource == null) {
            dataSource = DataBaseXmlUtils.readDataBaseXml(dbType.getDb());
        }
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDbType(dbType).setDriverName(dataSource.getDriverClassName()).setUrl(dataSource.getUrl()).setUsername(dataSource.getUsername()).setPassword(dataSource.getPassword());
        if (dbType.equals((Object)DbType.MYSQL)) {
            dataSourceConfig.setTypeConvert((ITypeConvert)new MySqlTypeConvert(){

                public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                    if (fieldType.toLowerCase().equals("bit")) {
                        return DbColumnType.BOOLEAN;
                    }
                    if (fieldType.toLowerCase().equals("tinyint")) {
                        return DbColumnType.BOOLEAN;
                    }
                    if (fieldType.toLowerCase().equals("date")) {
                        return DbColumnType.LOCAL_DATE;
                    }
                    if (fieldType.toLowerCase().equals("time")) {
                        return DbColumnType.LOCAL_TIME;
                    }
                    if (fieldType.toLowerCase().equals("datetime")) {
                        return DbColumnType.LOCAL_DATE_TIME;
                    }
                    return super.processTypeConvert(globalConfig, fieldType);
                }
            });
        } else if (dbType.equals((Object)DbType.SQL_SERVER)) {
            dataSourceConfig.setTypeConvert((ITypeConvert)new SqlServerTypeConvert(){

                public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                    return super.processTypeConvert(globalConfig, fieldType);
                }
            });
        }
        return dataSourceConfig;
    }

    protected DataSourceConfig getDataSourceConfig() {
        DataSource dataSource = YamlUtils.readDataSourceYaml();
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        if (dataSource != null) {
            if (dataSource.getDriverClassName().equals(Constants.MYSQL.getValue()) || dataSource.getDriverClassName().equals(Constants.MYSQL_PLUS.getValue())) {
                dataSourceConfig.setDbType(DbType.MYSQL);
                dataSourceConfig.setTypeConvert((ITypeConvert)new MySqlTypeConvert(){

                    public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                        if (fieldType.toLowerCase().equals("bit")) {
                            return DbColumnType.BOOLEAN;
                        }
                        if (fieldType.toLowerCase().equals("date")) {
                            return DbColumnType.LOCAL_DATE;
                        }
                        if (fieldType.toLowerCase().equals("time")) {
                            return DbColumnType.LOCAL_TIME;
                        }
                        if (fieldType.toLowerCase().equals("tinyint")) {
                            return DbColumnType.BOOLEAN;
                        }
                        if (fieldType.toLowerCase().equals("datetime")) {
                            return DbColumnType.LOCAL_DATE_TIME;
                        }
                        return super.processTypeConvert(globalConfig, fieldType);
                    }
                });
            } else if (dataSource.getDriverClassName().equals(Constants.SQLSERVER.getValue())) {
                dataSourceConfig.setDbType(DbType.SQL_SERVER);
                dataSourceConfig.setTypeConvert((ITypeConvert)new SqlServerTypeConvert(){

                    public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                        return super.processTypeConvert(globalConfig, fieldType);
                    }
                });
            } else {
                throw new RuntimeException("NotFound Driver-Class-Name,Please Check It");
            }
            dataSourceConfig.setUrl(dataSource.getUrl()).setUsername(dataSource.getUsername()).setPassword(dataSource.getPassword()).setDriverName(dataSource.getDriverClassName());
        } else {
            dataSourceConfig = this.getDataSourceConfig(DbType.MYSQL);
        }
        return dataSourceConfig;
    }

    protected List<TableFill> getTableFills() {
        ArrayList<TableFill> tableFillList = new ArrayList<TableFill>();
        tableFillList.add(new TableFill("createTime", FieldFill.INSERT));
        tableFillList.add(new TableFill("updateTime", FieldFill.INSERT_UPDATE));
        tableFillList.add(new TableFill("createUid", FieldFill.INSERT));
        tableFillList.add(new TableFill("updateUid", FieldFill.INSERT_UPDATE));
        return tableFillList;
    }

    protected StrategyConfig getStrategyConfig(String[] tableNames, String[] tablePrefix) {
        List<TableFill> tableFillList = this.getTableFills();
        StrategyConfig strategyConfig = new StrategyConfig();
        strategyConfig.setCapitalMode(false).setInclude(tableNames).setNaming(NamingStrategy.underline_to_camel).setTableFillList(tableFillList).setEntityLombokModel(true).setEntityBooleanColumnRemoveIsPrefix(true).setRestControllerStyle(false).setEntityColumnConstant(true).setEntityBuilderModel(false);
        if (tablePrefix != null) {
            strategyConfig.setTablePrefix(tablePrefix);
        }
        return strategyConfig;
    }

    protected StrategyConfig getStrategyConfig(String tableNames, String tablePrefix) {
        List<TableFill> tableFillList = this.getTableFills();
        StrategyConfig strategyConfig = new StrategyConfig();
        strategyConfig.setCapitalMode(false).setInclude(new String[]{tableNames}).setNaming(NamingStrategy.underline_to_camel).setTableFillList(tableFillList).setEntityLombokModel(true).setEntityBooleanColumnRemoveIsPrefix(true).setRestControllerStyle(false).setEntityColumnConstant(true).setEntityBuilderModel(false);
        if (StringUtils.isNotEmpty((CharSequence)tablePrefix)) {
            strategyConfig.setTablePrefix(new String[]{tablePrefix});
        }
        return strategyConfig;
    }

    protected PackageConfig getPackageConfig(String parentPackageName, String moduleName) {
        PackageConfig packageConfig = new PackageConfig();
        packageConfig.setEntity("entity").setMapper("mapper").setService("service").setServiceImpl("service.impl").setController("controller");
        if (StringUtils.isNotEmpty((CharSequence)parentPackageName)) {
            packageConfig.setParent(parentPackageName);
        } else {
            packageConfig.setParent("com.github.sdcxy");
        }
        if (StringUtils.isNotEmpty((CharSequence)moduleName)) {
            packageConfig.setModuleName(moduleName);
        }
        return packageConfig;
    }

    protected GlobalConfig getGlobalConfig() {
        return new GlobalConfig().setAuthor(AUTHOR).setOutputDir(this.getJavaPath()).setActiveRecord(true).setBaseResultMap(false).setBaseColumnList(false).setEnableCache(false).setKotlin(false).setFileOverride(true).setOpen(false).setSwagger2(true).setEntityName("%s").setXmlName("%sMapper").setMapperName("%sMapper").setServiceName("I%sService").setServiceImplName("%sServiceImpl").setControllerName("%sRestController");
    }

    protected TemplateConfig getTemplateConfig() {
        return new TemplateConfig().setXml(null);
    }

    protected InjectionConfig getInjectionConfig() {
        return new InjectionConfig(){

            public void initMap() {
                HashMap map = new HashMap();
                this.setMap(map);
            }
        }.setFileOutConfigList(Collections.singletonList(new FileOutConfig(MAPPER_XML_TEMPLATE){

            public String outputFile(TableInfo tableInfo) {
                return SuperGenerator.this.getResourcePath() + "/mapper/" + tableInfo.getEntityName() + "Mapper.xml";
            }
        }));
    }

    @Deprecated
    public AutoGenerator getAutoGenerator(String parentPackageName, String moduleName, String[] tableNames, String[] tablePrefix, DbType dbType) {
        return new AutoGenerator().setGlobalConfig(this.getGlobalConfig()).setPackageInfo(this.getPackageConfig(parentPackageName, moduleName)).setTemplate(this.getTemplateConfig()).setCfg(this.getInjectionConfig()).setStrategy(this.getStrategyConfig(tableNames, tablePrefix)).setDataSource(this.getDataSourceConfig(dbType));
    }

    @Deprecated
    public AutoGenerator getAutoGenerator(String parentPackageName, String moduleName, String tableNames, String tablePrefix, DbType dbType) {
        return new AutoGenerator().setGlobalConfig(this.getGlobalConfig()).setPackageInfo(this.getPackageConfig(parentPackageName, moduleName)).setTemplate(this.getTemplateConfig()).setCfg(this.getInjectionConfig()).setStrategy(this.getStrategyConfig(tableNames, tablePrefix)).setDataSource(this.getDataSourceConfig(dbType));
    }

    public AutoGenerator getAutoGenerator(String parentPackageName, String moduleName, String[] tableNames, String[] tablePrefix) {
        return new AutoGenerator().setGlobalConfig(this.getGlobalConfig()).setPackageInfo(this.getPackageConfig(parentPackageName, moduleName)).setTemplate(this.getTemplateConfig()).setCfg(this.getInjectionConfig()).setStrategy(this.getStrategyConfig(tableNames, tablePrefix)).setDataSource(this.getDataSourceConfig());
    }

    public AutoGenerator getAutoGenerator(String parentPackageName, String moduleName, String tableNames, String tablePrefix) {
        return new AutoGenerator().setGlobalConfig(this.getGlobalConfig()).setPackageInfo(this.getPackageConfig(parentPackageName, moduleName)).setTemplate(this.getTemplateConfig()).setCfg(this.getInjectionConfig()).setStrategy(this.getStrategyConfig(tableNames, tablePrefix)).setDataSource(this.getDataSourceConfig());
    }
}

