/*
 * Decompiled with CFR 0.152.
 */
package com.github.sebruck.opencensus.akka.http;

import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.stream.FanInShape2;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.UnzipWith$;
import akka.stream.scaladsl.UnzipWithApply;
import akka.stream.scaladsl.Zip$;
import com.github.sebruck.opencensus.Tracing;
import com.github.sebruck.opencensus.akka.http.Propagation;
import com.github.sebruck.opencensus.akka.http.StatusTranslator$;
import com.github.sebruck.opencensus.akka.http.trace.HttpAttributes$;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\reaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u000e)J\f7-\u001b8h\u00072LWM\u001c;\u000b\u0005\r!\u0011\u0001\u00025uiBT!!\u0002\u0004\u0002\t\u0005\\7.\u0019\u0006\u0003\u000f!\t!b\u001c9f]\u000e,gn];t\u0015\tI!\"A\u0004tK\n\u0014XoY6\u000b\u0005-a\u0011AB4ji\",(MC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003e\u0001\"!\u0005\u000e\n\u0005m\u0011\"\u0001B+oSRDq!\b\u0001C\u0002\u001bEa$A\u0004ue\u0006\u001c\u0017N\\4\u0016\u0003}\u0001\"\u0001I\u0011\u000e\u0003\u0019I!A\t\u0004\u0003\u000fQ\u0013\u0018mY5oO\"9A\u0005\u0001b\u0001\u000e#)\u0013a\u00039s_B\fw-\u0019;j_:,\u0012A\n\t\u0003O!j\u0011AA\u0005\u0003S\t\u00111\u0002\u0015:pa\u0006<\u0017\r^5p]\"91\u0006\u0001b\u0001\u000e'a\u0013AA3d+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0013\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003e=\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bQ\u0002A\u0011A\u001b\u0002\u0019Q\u0014\u0018mY3SKF,Xm\u001d;\u0015\u0007YJ5\n\u0005\u0003\u0012oe\u001a\u0015B\u0001\u001d\u0013\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002;\u00036\t1H\u0003\u0002={\u0005)Qn\u001c3fY*\u0011ahP\u0001\tg\u000e\fG.\u00193tY*\u00111\u0001\u0011\u0006\u0002\u000b%\u0011!i\u000f\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000fE\u0002/\t\u001aK!!R\u0018\u0003\r\u0019+H/\u001e:f!\tQt)\u0003\u0002Iw\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")!j\ra\u0001m\u0005IAm\u001c*fcV,7\u000f\u001e\u0005\u0006\u0019N\u0002\r!T\u0001\u000ba\u0006\u0014XM\u001c;Ta\u0006t\u0007C\u0001(U\u001b\u0005y%B\u0001)R\u0003\u0015!(/Y2f\u0015\t9!KC\u0001T\u0003\tIw.\u0003\u0002V\u001f\n!1\u000b]1o\u0011\u00159\u0006\u0001\"\u0001Y\u0003e!(/Y2f%\u0016\fX/Z:u\r>\u00148i\u001c8oK\u000e$\u0018n\u001c8\u0016\u0005e\u001bGc\u0001.m]B)1lX\u001dGC6\tAL\u0003\u0002?;*\u0011a\fQ\u0001\u0007gR\u0014X-Y7\n\u0005\u0001d&\u0001\u0002$m_^\u0004\"AY2\r\u0001\u0011)AM\u0016b\u0001K\n\u0019Q*\u0019;\u0012\u0005\u0019L\u0007CA\th\u0013\tA'CA\u0004O_RD\u0017N\\4\u0011\u0005EQ\u0017BA6\u0013\u0005\r\te.\u001f\u0005\u0006[Z\u0003\rAW\u0001\u000bG>tg.Z2uS>t\u0007\"\u0002'W\u0001\u0004i\u0005\"\u00029\u0001\t\u0003\t\u0018a\u0005;sC\u000e,'+Z9vKN$hi\u001c:Q_>dW\u0003\u0002:y\u0003\u000b!Ra]A\u0004\u0003\u0017\u0001baW0uu\u0006\r\u0001\u0003B\tvs]L!A\u001e\n\u0003\rQ+\b\u000f\\33!\t\u0011\u0007\u0010B\u0003z_\n\u0007QMA\u0001U!\u0011\tRo_<\u0011\u0007q|h)D\u0001~\u0015\tq(#\u0001\u0003vi&d\u0017bAA\u0001{\n\u0019AK]=\u0011\u0007\t\f)\u0001B\u0003e_\n\u0007Q\r\u0003\u0004\u0002\n=\u0004\ra]\u0001\u000fG>tg.Z2uS>t\u0007k\\8m\u0011\u0015au\u000e1\u0001N\u0011\u001d\ty\u0001\u0001C\u0005\u0003#\t!c\u001d9b]\u001a{'o^1sI&twM\u00127poVA\u00111CA\u000e\u0003G\tI\u0003\u0006\u0003\u0002\u0016\u0005-\u0002\u0003C.`\u0003/\ty\"a\n\u0011\u000bE)\u0018\u0011D'\u0011\u0007\t\fY\u0002B\u0004\u0002\u001e\u00055!\u0019A3\u0003\u0005%s\u0007#B\tv\u0003Ci\u0005c\u00012\u0002$\u00119\u0011QEA\u0007\u0005\u0004)'aA(viB\u0019!-!\u000b\u0005\r\u0011\fiA1\u0001f\u0011!\ti#!\u0004A\u0002\u0005=\u0012AC;oI\u0016\u0014H._5oOBA1lXA\r\u0003C\t9\u0003C\u0004\u00024\u0001!I!!\u000e\u00023M$\u0018M\u001d;Ta\u0006t\u0017I\u001c3F]JL7\r\u001b*fcV,7\u000f\u001e\u000b\u0007\u0003o\tI$!\u0010\u0011\tE)\u0018(\u0014\u0005\b\u0003w\t\t\u00041\u0001:\u0003\u001d\u0011X-];fgRDa\u0001TA\u0019\u0001\u0004i\u0005bBA!\u0001\u0011%\u00111I\u0001\u000fK:$7\u000b]1o'V\u001c7-Z:t)\u0015I\u0012QIA%\u0011\u001d\t9%a\u0010A\u0002\u0019\u000b\u0001B]3ta>t7/\u001a\u0005\b\u0003\u0017\ny\u00041\u0001N\u0003\u0011\u0019\b/\u00198\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R\u0005aQM\u001c3Ta\u0006tWI\u001d:peR\u0019\u0011$a\u0015\t\u000f\u0005-\u0013Q\na\u0001\u001b\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013a\u0006:fcV,7\u000f^,ji\"$&/Y2f\u0007>tG/\u001a=u)\u0015I\u00141LA/\u0011\u001d\tY$!\u0016A\u0002eBq!a\u0013\u0002V\u0001\u0007QjB\u0004\u0002b\tA\t!a\u0019\u0002\u001bQ\u0013\u0018mY5oO\u000ec\u0017.\u001a8u!\r9\u0013Q\r\u0004\u0007\u0003\tA\t!a\u001a\u0014\u000b\u0005\u0015\u0004#!\u001b\u0011\u0005\u001d\u0002\u0001\u0002CA7\u0003K\"\t!a\u001c\u0002\rqJg.\u001b;?)\t\t\u0019\u0007\u0003\u0005\u001e\u0003K\u0012\r\u0011\"\u0015\u001f\u0011!\t)(!\u001a!\u0002\u0013y\u0012\u0001\u0003;sC\u000eLgn\u001a\u0011\t\u0011\u0011\n)G1A\u0005R\u0015B\u0001\"a\u001f\u0002f\u0001\u0006IAJ\u0001\raJ|\u0007/Y4bi&|g\u000e\t\u0005\tW\u0005\u0015$\u0019!C*Y!A\u0011\u0011QA3A\u0003%Q&A\u0002fG\u0002\u0002")
public interface TracingClient {
    public Tracing tracing();

    public Propagation propagation();

    public ExecutionContext ec();

    public static /* synthetic */ Function1 traceRequest$(TracingClient $this, Function1 doRequest, Span parentSpan) {
        return $this.traceRequest((Function1<HttpRequest, Future<HttpResponse>>)doRequest, parentSpan);
    }

    default public Function1<HttpRequest, Future<HttpResponse>> traceRequest(Function1<HttpRequest, Future<HttpResponse>> doRequest, Span parentSpan) {
        return (Function1 & Serializable & scala.Serializable)request -> {
            Tuple2<HttpRequest, Span> tuple2 = this.startSpanAndEnrichRequest((HttpRequest)request, parentSpan);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HttpRequest enrichedRequest = (HttpRequest)tuple2._1();
            Span span = (Span)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)enrichedRequest, (Object)span);
            Tuple2 tuple23 = tuple22;
            HttpRequest enrichedRequest2 = (HttpRequest)tuple23._1();
            Span span2 = (Span)tuple23._2();
            Future result = (Future)doRequest.apply((Object)enrichedRequest2);
            result.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TracingClient.$anonfun$traceRequest$2(this, span2, x0$1);
                return BoxedUnit.UNIT;
            }, this.ec());
            return result;
        };
    }

    public static /* synthetic */ Flow traceRequestForConnection$(TracingClient $this, Flow connection, Span parentSpan) {
        return $this.traceRequestForConnection(connection, parentSpan);
    }

    default public <Mat> Flow<HttpRequest, HttpResponse, Mat> traceRequestForConnection(Flow<HttpRequest, HttpResponse, Mat> connection, Span parentSpan) {
        Flow startSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x$2 -> this.startSpanAndEnrichRequest((HttpRequest)x$2, parentSpan));
        Flow errorToTry = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x$3 -> new Success(x$3)).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    object = new Failure(e);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
        });
        Flow doRequest = this.spanForwardingFlow(connection.via((Graph)errorToTry));
        Flow endSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Span span;
            Try try_;
            block6: {
                Tuple2 tuple2;
                block5: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block5;
                    try_ = (Try)tuple2._1();
                    span = (Span)tuple2._2();
                    if (try_ instanceof Success) break block6;
                }
                if (tuple2 != null) {
                    Try try_2 = (Try)tuple2._1();
                    Span span2 = (Span)tuple2._2();
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable e = failure.exception();
                        this.endSpanError(span2);
                        throw e;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            this.endSpanSuccess(response, span);
            HttpResponse httpResponse = response;
            return httpResponse;
        });
        return startSpan.viaMat(doRequest, Keep$.MODULE$.right()).viaMat((Graph)endSpan, Keep$.MODULE$.left());
    }

    public static /* synthetic */ Flow traceRequestForPool$(TracingClient $this, Flow connectionPool, Span parentSpan) {
        return $this.traceRequestForPool(connectionPool, parentSpan);
    }

    default public <T, Mat> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> traceRequestForPool(Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> connectionPool, Span parentSpan) {
        Flow startSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2;
            Object context;
            Tuple2 tuple22 = x0$3;
            if (tuple22 != null) {
                HttpRequest request = (HttpRequest)tuple22._1();
                context = tuple22._2();
                Tuple2<HttpRequest, Span> tuple23 = this.startSpanAndEnrichRequest(request, parentSpan);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                HttpRequest enrichedRequest = (HttpRequest)tuple23._1();
                Span span = (Span)tuple23._2();
                tuple2 = new Tuple2((Object)enrichedRequest, (Object)span);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            HttpRequest enrichedRequest = (HttpRequest)tuple24._1();
            Span span = (Span)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)new Tuple2((Object)enrichedRequest, context), (Object)span);
            return tuple25;
        });
        Flow<Tuple2<Tuple2<HttpRequest, T>, Span>, Tuple2<Tuple2<Try<HttpResponse>, T>, Span>, Mat> doRequest = this.spanForwardingFlow(connectionPool);
        Flow endSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Span span = (Span)tuple2._2();
                if (tuple22 != null) {
                    Try try_ = (Try)tuple22._1();
                    Object context = tuple22._2();
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        HttpResponse response = (HttpResponse)success.value();
                        this.endSpanSuccess(response, span);
                        return new Tuple2((Object)new Success((Object)response), context);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple23 = (Tuple2)tuple2._1();
            Span span = (Span)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            Try try_ = (Try)tuple23._1();
            Object context = tuple23._2();
            if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple2);
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            this.endSpanError(span);
            return new Tuple2((Object)new Failure(error), context);
        });
        return startSpan.viaMat(doRequest, Keep$.MODULE$.right()).viaMat((Graph)endSpan, Keep$.MODULE$.left());
    }

    private <In, Out, Mat> Flow<Tuple2<In, Span>, Tuple2<Out, Span>, Mat> spanForwardingFlow(Flow<In, Out, Mat> underlying) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(underlying, (Function1 & Serializable & scala.Serializable)b -> (Function1 & Serializable & scala.Serializable)under -> {
            FanOutShape2 bcast = (FanOutShape2)b.add((Graph)UnzipWith$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), (UnzipWithApply.UnzipWithCreator2)UnzipWithApply.UnzipWithCreatorObject2$.MODULE$));
            FanInShape2 zip = (FanInShape2)b.add((Graph)Zip$.MODULE$.apply());
            Flow bufferForZip = (Flow)Flow$.MODULE$.apply().buffer(1000, OverflowStrategy$.MODULE$.backpressure());
            GraphDSL.Implicits$.MODULE$.port2flow(bcast.out0(), b).$tilde$greater(under, b).$tilde$greater(zip.in0(), b);
            GraphDSL.Implicits$.MODULE$.port2flow(bcast.out1(), b).$tilde$greater((Graph)bufferForZip, b).$tilde$greater(zip.in1(), b);
            return new FlowShape(bcast.in(), zip.out());
        }));
    }

    private Tuple2<HttpRequest, Span> startSpanAndEnrichRequest(HttpRequest request, Span parentSpan) {
        Span span = this.tracing().startSpanWithParent(request.uri().path().toString(), parentSpan);
        HttpAttributes$.MODULE$.setAttributesForRequest(span, request);
        HttpRequest enrichedRequest = this.requestWithTraceContext(request, span);
        return new Tuple2((Object)enrichedRequest, (Object)span);
    }

    private void endSpanSuccess(HttpResponse response, Span span) {
        HttpAttributes$.MODULE$.setAttributesForResponse(span, response);
        this.tracing().endSpan(span, StatusTranslator$.MODULE$.translate(response.status()));
    }

    private void endSpanError(Span span) {
        this.tracing().endSpan(span, Status.INTERNAL);
    }

    private HttpRequest requestWithTraceContext(HttpRequest request, Span span) {
        Seq<HttpHeader> traceHeaders = this.propagation().headersWithTracingContext(span);
        return (HttpRequest)request.mapHeaders((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)x$5.$plus$plus((GenTraversableOnce)traceHeaders, Seq$.MODULE$.canBuildFrom()));
    }

    public static /* synthetic */ void $anonfun$traceRequest$2(TracingClient $this, Span span$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            $this.endSpanSuccess(response, span$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            $this.endSpanError(span$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static void $init$(TracingClient $this) {
    }
}

