/*
 * Decompiled with CFR 0.152.
 */
package com.github.sebruck.opencensus.akka.http;

import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.stream.FanInShape2;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.UnzipWith$;
import akka.stream.scaladsl.UnzipWithApply;
import akka.stream.scaladsl.Zip$;
import com.github.sebruck.opencensus.Tracing;
import com.github.sebruck.opencensus.akka.http.trace.HttpAttributes$;
import com.github.sebruck.opencensus.http.StatusTranslator$;
import com.github.sebruck.opencensus.http.propagation.Propagation;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=eaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u000e)J\f7-\u001b8h\u00072LWM\u001c;\u000b\u0005\r!\u0011\u0001\u00025uiBT!!\u0002\u0004\u0002\t\u0005\\7.\u0019\u0006\u0003\u000f!\t!b\u001c9f]\u000e,gn];t\u0015\tI!\"A\u0004tK\n\u0014XoY6\u000b\u0005-a\u0011AB4ji\",(MC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003e\u0001\"!\u0005\u000e\n\u0005m\u0011\"\u0001B+oSRDq!\b\u0001C\u0002\u001bEa$A\u0004ue\u0006\u001c\u0017N\\4\u0016\u0003}\u0001\"\u0001I\u0011\u000e\u0003\u0019I!A\t\u0004\u0003\u000fQ\u0013\u0018mY5oO\"9A\u0005\u0001b\u0001\u000e#)\u0013a\u00039s_B\fw-\u0019;j_:,\u0012A\n\t\u0005O)bc'D\u0001)\u0015\t!\u0013F\u0003\u0002\u0004\r%\u00111\u0006\u000b\u0002\f!J|\u0007/Y4bi&|g\u000e\u0005\u0002.i5\taF\u0003\u00020a\u0005)Qn\u001c3fY*\u0011\u0011GM\u0001\tg\u000e\fG.\u00193tY*\u00111a\r\u0006\u0002\u000b%\u0011QG\f\u0002\u000b\u0011R$\b\u000fS3bI\u0016\u0014\bCA\u00178\u0013\tAdFA\u0006IiR\u0004(+Z9vKN$\bb\u0002\u001e\u0001\u0005\u00045\u0019bO\u0001\u0003K\u000e,\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fI\t!bY8oGV\u0014(/\u001a8u\u0013\t\teH\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")1\t\u0001C\u0001\t\u0006aAO]1dKJ+\u0017/^3tiR\u0019QI\u0014)\u0011\tE1e\u0007S\u0005\u0003\u000fJ\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007uJ5*\u0003\u0002K}\t1a)\u001e;ve\u0016\u0004\"!\f'\n\u00055s#\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0007\"B(C\u0001\u0004)\u0015!\u00033p%\u0016\fX/Z:u\u0011\u0015\t&\t1\u0001S\u0003)\u0001\u0018M]3oiN\u0003\u0018M\u001c\t\u0003'fk\u0011\u0001\u0016\u0006\u0003+Z\u000bQ\u0001\u001e:bG\u0016T!aB,\u000b\u0003a\u000b!![8\n\u0005i#&\u0001B*qC:DQ\u0001\u0018\u0001\u0005\u0002u\u000b\u0011\u0004\u001e:bG\u0016\u0014V-];fgR4uN]\"p]:,7\r^5p]V\u0011a\f\u001b\u000b\u0004?F\u001c\b#\u00021em-3W\"A1\u000b\u0005E\u0012'BA24\u0003\u0019\u0019HO]3b[&\u0011Q-\u0019\u0002\u0005\r2|w\u000f\u0005\u0002hQ2\u0001A!B5\\\u0005\u0004Q'aA'biF\u00111N\u001c\t\u0003#1L!!\u001c\n\u0003\u000f9{G\u000f[5oOB\u0011\u0011c\\\u0005\u0003aJ\u00111!\u00118z\u0011\u0015\u00118\f1\u0001`\u0003)\u0019wN\u001c8fGRLwN\u001c\u0005\u0006#n\u0003\rA\u0015\u0005\u0006k\u0002!\tA^\u0001\u0014iJ\f7-\u001a*fcV,7\u000f\u001e$peB{w\u000e\\\u000b\u0005ov\fy\u0001F\u0003y\u0003#\t)\u0002\u0005\u0004aIf|\u0018Q\u0002\t\u0005#i4D0\u0003\u0002|%\t1A+\u001e9mKJ\u0002\"aZ?\u0005\u000by$(\u0019\u00016\u0003\u0003Q\u0003R!\u0005>\u0002\u0002q\u0004R!a\u0001\u0002\n-k!!!\u0002\u000b\u0007\u0005\u001d!#\u0001\u0003vi&d\u0017\u0002BA\u0006\u0003\u000b\u00111\u0001\u0016:z!\r9\u0017q\u0002\u0003\u0006SR\u0014\rA\u001b\u0005\u0007\u0003'!\b\u0019\u0001=\u0002\u001d\r|gN\\3di&|g\u000eU8pY\")\u0011\u000b\u001ea\u0001%\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011AE:qC:4uN]<be\u0012Lgn\u001a$m_^,\u0002\"!\b\u0002&\u00055\u00121\u0007\u000b\u0005\u0003?\t)\u0004\u0005\u0005aI\u0006\u0005\u0012\u0011FA\u0019!\u0015\t\"0a\tS!\r9\u0017Q\u0005\u0003\b\u0003O\t9B1\u0001k\u0005\tIe\u000eE\u0003\u0012u\u0006-\"\u000bE\u0002h\u0003[!q!a\f\u0002\u0018\t\u0007!NA\u0002PkR\u00042aZA\u001a\t\u0019I\u0017q\u0003b\u0001U\"A\u0011qGA\f\u0001\u0004\tI$\u0001\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0002\u0002\u00193\u0002$\u0005-\u0012\u0011\u0007\u0005\b\u0003{\u0001A\u0011BA \u0003e\u0019H/\u0019:u'B\fg.\u00118e\u000b:\u0014\u0018n\u00195SKF,Xm\u001d;\u0015\r\u0005\u0005\u00131IA$!\u0011\t\"P\u000e*\t\u000f\u0005\u0015\u00131\ba\u0001m\u00059!/Z9vKN$\bBB)\u0002<\u0001\u0007!\u000bC\u0004\u0002L\u0001!I!!\u0014\u0002\u001d\u0015tGm\u00159b]N+8mY3tgR)\u0011$a\u0014\u0002T!9\u0011\u0011KA%\u0001\u0004Y\u0015\u0001\u0003:fgB|gn]3\t\u000f\u0005U\u0013\u0011\na\u0001%\u0006!1\u000f]1o\u0011\u001d\tI\u0006\u0001C\u0005\u00037\nA\"\u001a8e'B\fg.\u0012:s_J$2!GA/\u0011\u001d\t)&a\u0016A\u0002ICq!!\u0019\u0001\t\u0013\t\u0019'A\fsKF,Xm\u001d;XSRDGK]1dK\u000e{g\u000e^3yiR)a'!\u001a\u0002h!9\u0011QIA0\u0001\u00041\u0004bBA+\u0003?\u0002\rAU\u0004\b\u0003W\u0012\u0001\u0012AA7\u00035!&/Y2j]\u001e\u001cE.[3oiB!\u0011qNA9\u001b\u0005\u0011aAB\u0001\u0003\u0011\u0003\t\u0019hE\u0003\u0002rA\t)\bE\u0002\u0002p\u0001A\u0001\"!\u001f\u0002r\u0011\u0005\u00111P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00055\u0004\u0002C\u000f\u0002r\t\u0007I\u0011\u000b\u0010\t\u0011\u0005\u0005\u0015\u0011\u000fQ\u0001\n}\t\u0001\u0002\u001e:bG&tw\r\t\u0005\tI\u0005E$\u0019!C)K!A\u0011qQA9A\u0003%a%\u0001\u0007qe>\u0004\u0018mZ1uS>t\u0007\u0005\u0003\u0005;\u0003c\u0012\r\u0011b\u0015<\u0011!\ti)!\u001d!\u0002\u0013a\u0014aA3dA\u0001")
public interface TracingClient {
    public Tracing tracing();

    public Propagation<HttpHeader, HttpRequest> propagation();

    public ExecutionContext ec();

    public static /* synthetic */ Function1 traceRequest$(TracingClient $this, Function1 doRequest, Span parentSpan) {
        return $this.traceRequest((Function1<HttpRequest, Future<HttpResponse>>)doRequest, parentSpan);
    }

    default public Function1<HttpRequest, Future<HttpResponse>> traceRequest(Function1<HttpRequest, Future<HttpResponse>> doRequest, Span parentSpan) {
        return (Function1 & Serializable & scala.Serializable)request -> {
            Tuple2<HttpRequest, Span> tuple2 = this.startSpanAndEnrichRequest((HttpRequest)request, parentSpan);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HttpRequest enrichedRequest = (HttpRequest)tuple2._1();
            Span span = (Span)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)enrichedRequest, (Object)span);
            Tuple2 tuple23 = tuple22;
            HttpRequest enrichedRequest2 = (HttpRequest)tuple23._1();
            Span span2 = (Span)tuple23._2();
            Future result = (Future)doRequest.apply((Object)enrichedRequest2);
            result.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TracingClient.$anonfun$traceRequest$2(this, span2, x0$1);
                return BoxedUnit.UNIT;
            }, this.ec());
            return result;
        };
    }

    public static /* synthetic */ Flow traceRequestForConnection$(TracingClient $this, Flow connection, Span parentSpan) {
        return $this.traceRequestForConnection(connection, parentSpan);
    }

    default public <Mat> Flow<HttpRequest, HttpResponse, Mat> traceRequestForConnection(Flow<HttpRequest, HttpResponse, Mat> connection, Span parentSpan) {
        Flow startSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x$2 -> this.startSpanAndEnrichRequest((HttpRequest)x$2, parentSpan));
        Flow errorToTry = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x$3 -> new Success(x$3)).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    object = new Failure(e);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
        });
        Flow doRequest = this.spanForwardingFlow(connection.via((Graph)errorToTry));
        Flow endSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Span span;
            Try try_;
            block6: {
                Tuple2 tuple2;
                block5: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block5;
                    try_ = (Try)tuple2._1();
                    span = (Span)tuple2._2();
                    if (try_ instanceof Success) break block6;
                }
                if (tuple2 != null) {
                    Try try_2 = (Try)tuple2._1();
                    Span span2 = (Span)tuple2._2();
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable e = failure.exception();
                        this.endSpanError(span2);
                        throw e;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            this.endSpanSuccess(response, span);
            HttpResponse httpResponse = response;
            return httpResponse;
        });
        return startSpan.viaMat(doRequest, Keep$.MODULE$.right()).viaMat((Graph)endSpan, Keep$.MODULE$.left());
    }

    public static /* synthetic */ Flow traceRequestForPool$(TracingClient $this, Flow connectionPool, Span parentSpan) {
        return $this.traceRequestForPool(connectionPool, parentSpan);
    }

    default public <T, Mat> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> traceRequestForPool(Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> connectionPool, Span parentSpan) {
        Flow startSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2;
            Object context;
            Tuple2 tuple22 = x0$3;
            if (tuple22 != null) {
                HttpRequest request = (HttpRequest)tuple22._1();
                context = tuple22._2();
                Tuple2<HttpRequest, Span> tuple23 = this.startSpanAndEnrichRequest(request, parentSpan);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                HttpRequest enrichedRequest = (HttpRequest)tuple23._1();
                Span span = (Span)tuple23._2();
                tuple2 = new Tuple2((Object)enrichedRequest, (Object)span);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            HttpRequest enrichedRequest = (HttpRequest)tuple24._1();
            Span span = (Span)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)new Tuple2((Object)enrichedRequest, context), (Object)span);
            return tuple25;
        });
        Flow<Tuple2<Tuple2<HttpRequest, T>, Span>, Tuple2<Tuple2<Try<HttpResponse>, T>, Span>, Mat> doRequest = this.spanForwardingFlow(connectionPool);
        Flow endSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Span span = (Span)tuple2._2();
                if (tuple22 != null) {
                    Try try_ = (Try)tuple22._1();
                    Object context = tuple22._2();
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        HttpResponse response = (HttpResponse)success.value();
                        this.endSpanSuccess(response, span);
                        return new Tuple2((Object)new Success((Object)response), context);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple23 = (Tuple2)tuple2._1();
            Span span = (Span)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            Try try_ = (Try)tuple23._1();
            Object context = tuple23._2();
            if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple2);
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            this.endSpanError(span);
            return new Tuple2((Object)new Failure(error), context);
        });
        return startSpan.viaMat(doRequest, Keep$.MODULE$.right()).viaMat((Graph)endSpan, Keep$.MODULE$.left());
    }

    private <In, Out, Mat> Flow<Tuple2<In, Span>, Tuple2<Out, Span>, Mat> spanForwardingFlow(Flow<In, Out, Mat> underlying) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(underlying, (Function1 & Serializable & scala.Serializable)b -> (Function1 & Serializable & scala.Serializable)under -> {
            FanOutShape2 bcast = (FanOutShape2)b.add((Graph)UnzipWith$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), (UnzipWithApply.UnzipWithCreator2)UnzipWithApply.UnzipWithCreatorObject2$.MODULE$));
            FanInShape2 zip = (FanInShape2)b.add((Graph)Zip$.MODULE$.apply());
            Flow bufferForZip = (Flow)Flow$.MODULE$.apply().buffer(1000, OverflowStrategy$.MODULE$.backpressure());
            GraphDSL.Implicits$.MODULE$.port2flow(bcast.out0(), b).$tilde$greater(under, b).$tilde$greater(zip.in0(), b);
            GraphDSL.Implicits$.MODULE$.port2flow(bcast.out1(), b).$tilde$greater((Graph)bufferForZip, b).$tilde$greater(zip.in1(), b);
            return new FlowShape(bcast.in(), zip.out());
        }));
    }

    private Tuple2<HttpRequest, Span> startSpanAndEnrichRequest(HttpRequest request, Span parentSpan) {
        Span span = this.tracing().startSpanWithParent(request.uri().path().toString(), parentSpan);
        HttpAttributes$.MODULE$.setAttributesForRequest(span, request);
        HttpRequest enrichedRequest = this.requestWithTraceContext(request, span);
        return new Tuple2((Object)enrichedRequest, (Object)span);
    }

    private void endSpanSuccess(HttpResponse response, Span span) {
        HttpAttributes$.MODULE$.setAttributesForResponse(span, response);
        this.tracing().endSpan(span, StatusTranslator$.MODULE$.translate(response.status().intValue()));
    }

    private void endSpanError(Span span) {
        this.tracing().endSpan(span, Status.INTERNAL);
    }

    private HttpRequest requestWithTraceContext(HttpRequest request, Span span) {
        Seq traceHeaders = this.propagation().headersWithTracingContext(span);
        return (HttpRequest)request.mapHeaders((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)x$5.$plus$plus((GenTraversableOnce)traceHeaders, Seq$.MODULE$.canBuildFrom()));
    }

    public static /* synthetic */ void $anonfun$traceRequest$2(TracingClient $this, Span span$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            $this.endSpanSuccess(response, span$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            $this.endSpanError(span$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static void $init$(TracingClient $this) {
    }
}

