/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.scala.akka.http;

import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.stream.FanInShape2;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.UnzipWith$;
import akka.stream.scaladsl.UnzipWithApply;
import akka.stream.scaladsl.Zip$;
import io.opencensus.scala.Tracing;
import io.opencensus.scala.akka.http.trace.HttpAttributes$;
import io.opencensus.scala.akka.http.utils.EndSpanResponse$;
import io.opencensus.scala.http.propagation.Propagation;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]gaB\u000e\u001d!\u0003\r\ta\n\u0005\u0006[\u0001!\tA\f\u0005\be\u0001\u0011\rQ\"\u00054\u0011\u001dA\u0004A1A\u0007\u0012eBq!\u0014\u0001C\u0002\u001bMa\nC\u0003V\u0001\u0011\u0005a\u000bC\u0003V\u0001\u0011\u0005!\u000eC\u0003m\u0001\u0011\u0005Q\u000e\u0003\u0004m\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0002\u0001C\u0001\u0003\u0003Ba!\u0016\u0001\u0005\n\u0005U\u0003B\u00027\u0001\t\u0013\t\t\u0007C\u0004\u0002\u0016\u0001!\t!a\u001c\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003w\u0003A\u0011BA_\u000f\u001d\t\u0019\r\bE\u0001\u0003\u000b4aa\u0007\u000f\t\u0002\u0005%\u0007bBAg'\u0011\u0005\u0011q\u001a\u0005\beM\u0011\r\u0011\"\u00154\u0011\u001d\t\tn\u0005Q\u0001\nQBq\u0001O\nC\u0002\u0013E\u0013\bC\u0004\u0002TN\u0001\u000b\u0011\u0002\u001e\t\u000f5\u001b\"\u0019!C*\u001d\"9\u0011Q[\n!\u0002\u0013y%!\u0004+sC\u000eLgnZ\"mS\u0016tGO\u0003\u0002\u001e=\u0005!\u0001\u000e\u001e;q\u0015\ty\u0002%\u0001\u0003bW.\f'BA\u0011#\u0003\u0015\u00198-\u00197b\u0015\t\u0019C%\u0001\u0006pa\u0016t7-\u001a8tkNT\u0011!J\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011fK\u0007\u0002U)\t\u0011%\u0003\u0002-U\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0018\u0011\u0005%\u0002\u0014BA\u0019+\u0005\u0011)f.\u001b;\u0002\u000fQ\u0014\u0018mY5oOV\tA\u0007\u0005\u00026m5\t\u0001%\u0003\u00028A\t9AK]1dS:<\u0017a\u00039s_B\fw-\u0019;j_:,\u0012A\u000f\t\u0005wy\u0002%*D\u0001=\u0015\tATH\u0003\u0002\u001eA%\u0011q\b\u0010\u0002\f!J|\u0007/Y4bi&|g\u000e\u0005\u0002B\u00116\t!I\u0003\u0002D\t\u0006)Qn\u001c3fY*\u0011QIR\u0001\tg\u000e\fG.\u00193tY*\u0011Qd\u0012\u0006\u0002?%\u0011\u0011J\u0011\u0002\u000b\u0011R$\b\u000fS3bI\u0016\u0014\bCA!L\u0013\ta%IA\u0006IiR\u0004(+Z9vKN$\u0018AA3d+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*+\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003)F\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0019Q\u0014\u0018mY3SKF,Xm\u001d;\u0015\u0007]\u0003'\r\u0005\u0003*1*S\u0016BA-+\u0005%1UO\\2uS>t\u0017\u0007E\u0002Q7vK!\u0001X)\u0003\r\u0019+H/\u001e:f!\t\te,\u0003\u0002`\u0005\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")\u0011-\u0002a\u0001/\u0006IAm\u001c*fcV,7\u000f\u001e\u0005\u0006G\u0016\u0001\r\u0001Z\u0001\u000ba\u0006\u0014XM\u001c;Ta\u0006t\u0007CA3i\u001b\u00051'BA4#\u0003\u0015!(/Y2f\u0013\tIgM\u0001\u0003Ta\u0006tGCA,l\u0011\u0015\tg\u00011\u0001X\u0003e!(/Y2f%\u0016\fX/Z:u\r>\u00148i\u001c8oK\u000e$\u0018n\u001c8\u0016\u00059DH#B8\u0002\u0004\u0005\u001d\u0001#\u00029u\u0015v3X\"A9\u000b\u0005\u0015\u0013(BA:H\u0003\u0019\u0019HO]3b[&\u0011Q/\u001d\u0002\u0005\r2|w\u000f\u0005\u0002xq2\u0001A!B=\b\u0005\u0004Q(aA'biF\u00111P \t\u0003SqL!! \u0016\u0003\u000f9{G\u000f[5oOB\u0011\u0011f`\u0005\u0004\u0003\u0003Q#aA!os\"1\u0011QA\u0004A\u0002=\f!bY8o]\u0016\u001cG/[8o\u0011\u0015\u0019w\u00011\u0001e+\u0011\tY!!\u0005\u0015\t\u00055\u00111\u0003\t\u0007aRTU,a\u0004\u0011\u0007]\f\t\u0002B\u0003z\u0011\t\u0007!\u0010C\u0004\u0002\u0006!\u0001\r!!\u0004\u0002'Q\u0014\u0018mY3SKF,Xm\u001d;G_J\u0004vn\u001c7\u0016\r\u0005e\u0011QEA\u001d)\u0019\tY\"a\u000f\u0002@AA\u0001\u000f^A\u000f\u0003S\t9\u0004\u0005\u0004*\u0003?Q\u00151E\u0005\u0004\u0003CQ#A\u0002+va2,'\u0007E\u0002x\u0003K!a!a\n\n\u0005\u0004Q(!\u0001+\u0011\u000f%\ny\"a\u000b\u0002$A)\u0011QFA\u001a;6\u0011\u0011q\u0006\u0006\u0004\u0003cQ\u0013\u0001B;uS2LA!!\u000e\u00020\t\u0019AK]=\u0011\u0007]\fI\u0004B\u0003z\u0013\t\u0007!\u0010C\u0004\u0002>%\u0001\r!a\u0007\u0002\u001d\r|gN\\3di&|g\u000eU8pY\")1-\u0003a\u0001IV1\u00111IA&\u0003#\"B!!\u0012\u0002TAA\u0001\u000f^A$\u0003\u001b\ny\u0005\u0005\u0004*\u0003?Q\u0015\u0011\n\t\u0004o\u0006-CABA\u0014\u0015\t\u0007!\u0010E\u0004*\u0003?\tY#!\u0013\u0011\u0007]\f\t\u0006B\u0003z\u0015\t\u0007!\u0010C\u0004\u0002>)\u0001\r!!\u0012\u0015\u000b]\u000b9&!\u0017\t\u000b\u0005\\\u0001\u0019A,\t\r\r\\\u0001\u0019AA.!\u0011I\u0013Q\f3\n\u0007\u0005}#F\u0001\u0004PaRLwN\\\u000b\u0005\u0003G\nI\u0007\u0006\u0004\u0002f\u0005-\u0014Q\u000e\t\u0007aRTU,a\u001a\u0011\u0007]\fI\u0007B\u0003z\u0019\t\u0007!\u0010C\u0004\u0002\u00061\u0001\r!!\u001a\t\r\rd\u0001\u0019AA.+\u0019\t\t(!\u001f\u0002\u0000Q1\u00111OAA\u0003\u0007\u0003\u0002\u0002\u001d;\u0002v\u0005m\u0014Q\u0010\t\u0007S\u0005}!*a\u001e\u0011\u0007]\fI\b\u0002\u0004\u0002(5\u0011\rA\u001f\t\bS\u0005}\u00111FA<!\r9\u0018q\u0010\u0003\u0006s6\u0011\rA\u001f\u0005\b\u0003{i\u0001\u0019AA:\u0011\u0019\u0019W\u00021\u0001\u0002\\\u0005\u00112\u000f]1o\r>\u0014x/\u0019:eS:<g\t\\8x+!\tI)!%\u0002\u001a\u0006}E\u0003BAF\u0003C\u0003\u0002\u0002\u001d;\u0002\u000e\u0006U\u0015Q\u0014\t\u0007S\u0005}\u0011q\u00123\u0011\u0007]\f\t\n\u0002\u0004\u0002\u0014:\u0011\rA\u001f\u0002\u0003\u0013:\u0004b!KA\u0010\u0003/#\u0007cA<\u0002\u001a\u00121\u00111\u0014\bC\u0002i\u00141aT;u!\r9\u0018q\u0014\u0003\u0006s:\u0011\rA\u001f\u0005\b\u0003Gs\u0001\u0019AAS\u0003))h\u000eZ3sYfLgn\u001a\t\taR\fy)a&\u0002\u001e\u0006I2\u000f^1siN\u0003\u0018M\\!oI\u0016s'/[2i%\u0016\fX/Z:u)\u0019\tY+!,\u00022B)\u0011&a\bKI\"1\u0011qV\bA\u0002)\u000bqA]3rk\u0016\u001cH\u000f\u0003\u0004d\u001f\u0001\u0007\u00111L\u0001\rK:$7\u000b]1o\u000bJ\u0014xN\u001d\u000b\u0004_\u0005]\u0006BBA]!\u0001\u0007A-\u0001\u0003ta\u0006t\u0017a\u0006:fcV,7\u000f^,ji\"$&/Y2f\u0007>tG/\u001a=u)\u0015Q\u0015qXAa\u0011\u0019\ty+\u0005a\u0001\u0015\"1\u0011\u0011X\tA\u0002\u0011\fQ\u0002\u0016:bG&twm\u00117jK:$\bcAAd'5\tAd\u0005\u0003\u0014Q\u0005-\u0007cAAd\u0001\u00051A(\u001b8jiz\"\"!!2\u0002\u0011Q\u0014\u0018mY5oO\u0002\nA\u0002\u001d:pa\u0006<\u0017\r^5p]\u0002\n1!Z2!\u0001")
public interface TracingClient {
    public Tracing tracing();

    public Propagation<HttpHeader, HttpRequest> propagation();

    public ExecutionContext ec();

    public static /* synthetic */ Function1 traceRequest$(TracingClient $this, Function1 doRequest, Span parentSpan) {
        return $this.traceRequest((Function1<HttpRequest, Future<HttpResponse>>)doRequest, parentSpan);
    }

    default public Function1<HttpRequest, Future<HttpResponse>> traceRequest(Function1<HttpRequest, Future<HttpResponse>> doRequest, Span parentSpan) {
        return this.traceRequest(doRequest, (Option<Span>)new Some((Object)parentSpan));
    }

    public static /* synthetic */ Function1 traceRequest$(TracingClient $this, Function1 doRequest) {
        return $this.traceRequest((Function1<HttpRequest, Future<HttpResponse>>)doRequest);
    }

    default public Function1<HttpRequest, Future<HttpResponse>> traceRequest(Function1<HttpRequest, Future<HttpResponse>> doRequest) {
        return this.traceRequest(doRequest, (Option<Span>)None$.MODULE$);
    }

    public static /* synthetic */ Flow traceRequestForConnection$(TracingClient $this, Flow connection, Span parentSpan) {
        return $this.traceRequestForConnection(connection, parentSpan);
    }

    default public <Mat> Flow<HttpRequest, HttpResponse, Mat> traceRequestForConnection(Flow<HttpRequest, HttpResponse, Mat> connection, Span parentSpan) {
        return this.traceRequestForConnection(connection, (Option<Span>)new Some((Object)parentSpan));
    }

    public static /* synthetic */ Flow traceRequestForConnection$(TracingClient $this, Flow connection) {
        return $this.traceRequestForConnection(connection);
    }

    default public <Mat> Flow<HttpRequest, HttpResponse, Mat> traceRequestForConnection(Flow<HttpRequest, HttpResponse, Mat> connection) {
        return this.traceRequestForConnection(connection, (Option<Span>)None$.MODULE$);
    }

    public static /* synthetic */ Flow traceRequestForPool$(TracingClient $this, Flow connectionPool, Span parentSpan) {
        return $this.traceRequestForPool(connectionPool, parentSpan);
    }

    default public <T, Mat> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> traceRequestForPool(Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> connectionPool, Span parentSpan) {
        return this.traceRequestForPool(connectionPool, (Option<Span>)new Some((Object)parentSpan));
    }

    public static /* synthetic */ Flow traceRequestForPool$(TracingClient $this, Flow connectionPool) {
        return $this.traceRequestForPool(connectionPool);
    }

    default public <T, Mat> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> traceRequestForPool(Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> connectionPool) {
        return this.traceRequestForPool(connectionPool, (Option<Span>)None$.MODULE$);
    }

    private Function1<HttpRequest, Future<HttpResponse>> traceRequest(Function1<HttpRequest, Future<HttpResponse>> doRequest, Option<Span> parentSpan) {
        return (Function1 & Serializable)request -> {
            Tuple2<HttpRequest, Span> tuple2 = this.startSpanAndEnrichRequest((HttpRequest)request, parentSpan);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HttpRequest enrichedRequest = (HttpRequest)tuple2._1();
            Span span = (Span)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)enrichedRequest, (Object)span);
            Tuple2 tuple23 = tuple22;
            HttpRequest enrichedRequest2 = (HttpRequest)tuple23._1();
            Span span2 = (Span)tuple23._2();
            return ((Future)doRequest.apply((Object)enrichedRequest2)).transform((Function1 & Serializable)x$2 -> EndSpanResponse$.MODULE$.forClient(this.tracing(), (HttpResponse)x$2, span2), (Function1 & Serializable)err -> {
                this.endSpanError(span2);
                return err;
            }, this.ec());
        };
    }

    private <Mat> Flow<HttpRequest, HttpResponse, Mat> traceRequestForConnection(Flow<HttpRequest, HttpResponse, Mat> connection, Option<Span> parentSpan) {
        Flow startSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$3 -> this.startSpanAndEnrichRequest((HttpRequest)x$3, parentSpan));
        Flow errorToTry = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$4 -> new Success(x$4)).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    object = new Failure(e);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
        });
        Flow doRequest = this.spanForwardingFlow(connection.via((Graph)errorToTry));
        Flow endSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x0$1 -> {
            Span span;
            Try try_;
            block6: {
                Tuple2 tuple2;
                block5: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block5;
                    try_ = (Try)tuple2._1();
                    span = (Span)tuple2._2();
                    if (try_ instanceof Success) break block6;
                }
                if (tuple2 != null) {
                    Try try_2 = (Try)tuple2._1();
                    Span span2 = (Span)tuple2._2();
                    if (try_2 instanceof Failure) {
                        Failure failure = (Failure)try_2;
                        Throwable e = failure.exception();
                        this.endSpanError(span2);
                        throw e;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            HttpResponse httpResponse = EndSpanResponse$.MODULE$.forClient(this.tracing(), response, span);
            return httpResponse;
        });
        return startSpan.viaMat(doRequest, Keep$.MODULE$.right()).viaMat((Graph)endSpan, Keep$.MODULE$.left());
    }

    public static /* synthetic */ Flow traceRequestForPool$(TracingClient $this, Flow connectionPool, Option parentSpan) {
        return $this.traceRequestForPool(connectionPool, (Option<Span>)parentSpan);
    }

    default public <T, Mat> Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> traceRequestForPool(Flow<Tuple2<HttpRequest, T>, Tuple2<Try<HttpResponse>, T>, Mat> connectionPool, Option<Span> parentSpan) {
        Flow startSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Object context;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                HttpRequest request = (HttpRequest)tuple22._1();
                context = tuple22._2();
                Tuple2<HttpRequest, Span> tuple23 = this.startSpanAndEnrichRequest(request, parentSpan);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                HttpRequest enrichedRequest = (HttpRequest)tuple23._1();
                Span span = (Span)tuple23._2();
                tuple2 = new Tuple2((Object)enrichedRequest, (Object)span);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple24 = tuple2;
            HttpRequest enrichedRequest = (HttpRequest)tuple24._1();
            Span span = (Span)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)new Tuple2((Object)enrichedRequest, context), (Object)span);
            return tuple25;
        });
        Flow<Tuple2<Tuple2<HttpRequest, T>, Span>, Tuple2<Tuple2<Try<HttpResponse>, T>, Span>, Mat> doRequest = this.spanForwardingFlow(connectionPool);
        Flow endSpan = (Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Span span = (Span)tuple2._2();
                if (tuple22 != null) {
                    Try try_ = (Try)tuple22._1();
                    Object context = tuple22._2();
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        HttpResponse response = (HttpResponse)success.value();
                        return new Tuple2((Object)new Success((Object)EndSpanResponse$.MODULE$.forClient(this.tracing(), response, span)), context);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple23 = (Tuple2)tuple2._1();
            Span span = (Span)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            Try try_ = (Try)tuple23._1();
            Object context = tuple23._2();
            if (!(try_ instanceof Failure)) throw new MatchError((Object)tuple2);
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            this.endSpanError(span);
            return new Tuple2((Object)new Failure(error), context);
        });
        return startSpan.viaMat(doRequest, Keep$.MODULE$.right()).viaMat((Graph)endSpan, Keep$.MODULE$.left());
    }

    private <In, Out, Mat> Flow<Tuple2<In, Span>, Tuple2<Out, Span>, Mat> spanForwardingFlow(Flow<In, Out, Mat> underlying) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(underlying, (Function1 & Serializable)b -> (Function1 & Serializable)under -> {
            FanOutShape2 bcast = (FanOutShape2)b.add((Graph)UnzipWith$.MODULE$.apply((Function1 & Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), (UnzipWithApply.UnzipWithCreator2)UnzipWithApply.UnzipWithCreatorObject2$.MODULE$));
            FanInShape2 zip = (FanInShape2)b.add((Graph)Zip$.MODULE$.apply());
            Flow bufferForZip = (Flow)Flow$.MODULE$.apply().buffer(1000, OverflowStrategy$.MODULE$.backpressure());
            GraphDSL.Implicits$.MODULE$.port2flow(bcast.out0(), b).$tilde$greater(under, b).$tilde$greater(zip.in0(), b);
            GraphDSL.Implicits$.MODULE$.port2flow(bcast.out1(), b).$tilde$greater((Graph)bufferForZip, b).$tilde$greater(zip.in1(), b);
            return new FlowShape(bcast.in(), zip.out());
        }));
    }

    private Tuple2<HttpRequest, Span> startSpanAndEnrichRequest(HttpRequest request, Option<Span> parentSpan) {
        String name = request.uri().path().toString();
        Span span = (Span)parentSpan.fold((Function0 & Serializable)() -> this.tracing().startSpan(name), (Function1 & Serializable)x$6 -> this.tracing().startSpanWithParent(name, x$6));
        io.opencensus.scala.http.HttpAttributes$.MODULE$.setAttributesForRequest(span, (Object)request, HttpAttributes$.MODULE$.requestExtractor());
        HttpRequest enrichedRequest = this.requestWithTraceContext(request, span);
        return new Tuple2((Object)enrichedRequest, (Object)span);
    }

    private void endSpanError(Span span) {
        this.tracing().endSpan(span, Status.INTERNAL);
    }

    private HttpRequest requestWithTraceContext(HttpRequest request, Span span) {
        Seq traceHeaders = this.propagation().headersWithTracingContext(span);
        return (HttpRequest)request.mapHeaders((Function1 & Serializable)x$7 -> (Seq)x$7.$plus$plus((IterableOnce)traceHeaders));
    }

    public static void $init$(TracingClient $this) {
    }
}

