/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.scala.akka.http;

import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler$;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.http.scaladsl.server.util.Tupler$;
import com.typesafe.scalalogging.LazyLogging;
import io.opencensus.scala.Tracing;
import io.opencensus.scala.akka.http.trace.HttpAttributes$;
import io.opencensus.scala.akka.http.utils.EndSpanResponse$;
import io.opencensus.scala.http.ServiceAttributes$;
import io.opencensus.scala.http.ServiceData;
import io.opencensus.scala.http.ServiceData$;
import io.opencensus.scala.http.propagation.Propagation;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rbaB\t\u0013!\u0003\r\t!\b\u0005\u0006[\u0001!\tA\f\u0005\u0006e\u00011\tb\r\u0005\u0006q\u00011\t\"\u000f\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006S\u0002!\tA\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006m\u0002!\ta\u001e\u0005\u0006\u001b\u0002!I!\u001f\u0005\u0006w\u0002!I\u0001 \u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\ty\u0001\u0001C\u0005\u0003#9q!!\u0006\u0013\u0011\u0003\t9B\u0002\u0004\u0012%!\u0005\u00111\u0004\u0005\b\u0003?iA\u0011AA\u0011\u0011\u0015\u0011T\u0002\"\u00154\u0011\u0015AT\u0002\"\u0015:\u0005A!&/Y2j]\u001e$\u0015N]3di&4XM\u0003\u0002\u0014)\u0005!\u0001\u000e\u001e;q\u0015\t)b#\u0001\u0003bW.\f'BA\f\u0019\u0003\u0015\u00198-\u00197b\u0015\tI\"$\u0001\u0006pa\u0016t7-\u001a8tkNT\u0011aG\u0001\u0003S>\u001c\u0001aE\u0002\u0001=\r\u0002\"aH\u0011\u000e\u0003\u0001R\u0011aF\u0005\u0003E\u0001\u0012a!\u00118z%\u00164\u0007C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tA\u0013&\u0001\u0005usB,7/\u00194f\u0015\u0005Q\u0013aA2p[&\u0011A&\n\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002_A\u0011q\u0004M\u0005\u0003c\u0001\u0012A!\u00168ji\u00069AO]1dS:<W#\u0001\u001b\u0011\u0005U2T\"\u0001\f\n\u0005]2\"a\u0002+sC\u000eLgnZ\u0001\faJ|\u0007/Y4bi&|g.F\u0001;!\u0011Yd\b\u0011&\u000e\u0003qR!\u0001O\u001f\u000b\u0005M1\u0012BA =\u0005-\u0001&o\u001c9bO\u0006$\u0018n\u001c8\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015!B7pI\u0016d'BA#G\u0003!\u00198-\u00197bINd'BA\nH\u0015\u0005)\u0012BA%C\u0005)AE\u000f\u001e9IK\u0006$WM\u001d\t\u0003\u0003.K!\u0001\u0014\"\u0003\u0017!#H\u000f\u001d*fcV,7\u000f^\u0001\riJ\f7-\u001a*fcV,7\u000f^\u000b\u0002\u001fB\u0019\u0001\u000bY2\u000f\u0005EkfB\u0001*\\\u001d\t\u0019&L\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bH\u0001\u0007yI|w\u000e\u001e \n\u0003UI!aE$\n\u0005\u00153\u0015B\u0001/E\u0003\u0019\u0019XM\u001d<fe&\u0011alX\u0001\ba\u0006\u001c7.Y4f\u0015\taF)\u0003\u0002bE\nQA)\u001b:fGRLg/Z\u0019\u000b\u0005y{\u0006C\u00013h\u001b\u0005)'B\u00014\u0019\u0003\u0015!(/Y2f\u0013\tAWM\u0001\u0003Ta\u0006t\u0017A\u0005;sC\u000e,'+Z9vKN$hj\\*qC:,\u0012a\u001b\t\u0003!2L!!\u001c2\u0003\u0015\u0011K'/Z2uSZ,\u0007'\u0001\fue\u0006\u001cWMU3rk\u0016\u001cHOR8s'\u0016\u0014h/[2f)\ty\u0005\u000fC\u0003r\r\u0001\u0007!/A\u0006tKJ4\u0018nY3ECR\f\u0007CA:u\u001b\u0005i\u0014BA;>\u0005-\u0019VM\u001d<jG\u0016$\u0015\r^1\u00029Q\u0014\u0018mY3SKF,Xm\u001d;G_J\u001cVM\u001d<jG\u0016tun\u00159b]R\u00111\u000e\u001f\u0005\u0006c\u001e\u0001\rA\u001d\u000b\u0003\u001fjDQ!\u001d\u0005A\u0002I\f\u0011BY;jY\u0012\u001c\u0006/\u00198\u0015\u0007\rlx\u0010C\u0003\u007f\u0013\u0001\u0007!*A\u0002sKFDQ!]\u0005A\u0002I\fQB]3d_J$7+^2dKN\u001cH\u0003BA\u0003\u0003\u0017\u00012!a\u0002m\u001d\r\tI!X\u0007\u0002?\"1\u0011Q\u0002\u0006A\u0002\r\fAa\u001d9b]\u0006y!/Z2pe\u0012,\u0005pY3qi&|g\u000e\u0006\u0003\u0002\u0006\u0005M\u0001BBA\u0007\u0017\u0001\u00071-\u0001\tUe\u0006\u001c\u0017N\\4ESJ,7\r^5wKB\u0019\u0011\u0011D\u0007\u000e\u0003I\u0019B!\u0004\u0010\u0002\u001eA\u0019\u0011\u0011\u0004\u0001\u0002\rqJg.\u001b;?)\t\t9\u0002")
public interface TracingDirective
extends LazyLogging {
    public Tracing tracing();

    public Propagation<HttpHeader, HttpRequest> propagation();

    public static /* synthetic */ Directive traceRequest$(TracingDirective $this) {
        return $this.traceRequest();
    }

    default public Directive<Tuple1<Span>> traceRequest() {
        return this.traceRequest(ServiceData$.MODULE$.apply());
    }

    public static /* synthetic */ Directive traceRequestNoSpan$(TracingDirective $this) {
        return $this.traceRequestNoSpan();
    }

    default public Directive<BoxedUnit> traceRequestNoSpan() {
        return Directive.SingleValueTransformers$.MODULE$.map$extension(Directive$.MODULE$.SingleValueTransformers(this.traceRequest(ServiceData$.MODULE$.apply())), (Function1 & Serializable)x$1 -> {
            TracingDirective.$anonfun$traceRequestNoSpan$1(x$1);
            return BoxedUnit.UNIT;
        }, Tupler$.MODULE$.forTuple(Tuple$.MODULE$.forUnit()));
    }

    public static /* synthetic */ Directive traceRequestForService$(TracingDirective $this, ServiceData serviceData) {
        return $this.traceRequestForService(serviceData);
    }

    default public Directive<Tuple1<Span>> traceRequestForService(ServiceData serviceData) {
        return this.traceRequest(serviceData);
    }

    public static /* synthetic */ Directive traceRequestForServiceNoSpan$(TracingDirective $this, ServiceData serviceData) {
        return $this.traceRequestForServiceNoSpan(serviceData);
    }

    default public Directive<BoxedUnit> traceRequestForServiceNoSpan(ServiceData serviceData) {
        return Directive.SingleValueTransformers$.MODULE$.map$extension(Directive$.MODULE$.SingleValueTransformers(this.traceRequest(serviceData)), (Function1 & Serializable)x$2 -> {
            TracingDirective.$anonfun$traceRequestForServiceNoSpan$1(x$2);
            return BoxedUnit.UNIT;
        }, Tupler$.MODULE$.forTuple(Tuple$.MODULE$.forUnit()));
    }

    private Directive<Tuple1<Span>> traceRequest(ServiceData serviceData) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(Directives$.MODULE$.extractRequest()), (Function1 & Serializable)req -> {
            Span span = this.buildSpan((HttpRequest)req, serviceData);
            return (Directive)((Directive)this.recordSuccess(span).$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.recordException(span), TupleOps.Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directives$.MODULE$.provide((Object)span), TupleOps.Join$.MODULE$.join0P()));
        }, Tuple$.MODULE$.forTuple1());
    }

    private Span buildSpan(HttpRequest req, ServiceData serviceData) {
        String name = req.uri().path().toString();
        Span span = (Span)this.propagation().extractContext((Object)req).fold((Function1 & Serializable)error -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Extracting of parent context failed", error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.tracing().startSpan(name);
        }, (Function1 & Serializable)x$3 -> this.tracing().startSpanWithRemoteParent(name, x$3));
        ServiceAttributes$.MODULE$.setAttributesForService(span, serviceData);
        io.opencensus.scala.http.HttpAttributes$.MODULE$.setAttributesForRequest(span, (Object)req, HttpAttributes$.MODULE$.requestExtractor());
        return span;
    }

    private Directive<BoxedUnit> recordSuccess(Span span) {
        return Directives$.MODULE$.mapResponse((Function1 & Serializable)x$4 -> EndSpanResponse$.MODULE$.forServer(this.tracing(), (HttpResponse)x$4, span));
    }

    private Directive<BoxedUnit> recordException(Span span) {
        return Directives$.MODULE$.handleExceptions(ExceptionHandler$.MODULE$.apply((PartialFunction)new Serializable(this, span){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TracingDirective $outer;
            private final Span span$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    this.$outer.tracing().endSpan(this.span$2, Status.INTERNAL);
                    throw ex;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.span$2 = span$2;
            }
        }));
    }

    public static /* synthetic */ void $anonfun$traceRequestNoSpan$1(Span x$1) {
    }

    public static /* synthetic */ void $anonfun$traceRequestForServiceNoSpan$1(Span x$2) {
    }

    public static void $init$(TracingDirective $this) {
    }
}

