/*
 * Decompiled with CFR 0.152.
 */
package com.github.segator.jbinary.maven.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="jbinary")
public class JBinaryBuildMojo
extends AbstractMojo {
    @Parameter(property="jreVersion", defaultValue="1.8.0_131")
    private String jreVersion;
    @Parameter(property="jBinaryVersion", defaultValue="0.0.5-ALPHA3")
    private String jBinaryVersion;
    @Parameter(property="JBinaryURLWindows", defaultValue="https://github.com/segator/jbinary/releases/download/%s/windows_amd64_jbinary_%s.exe")
    private String JBinaryURLWindows;
    @Parameter(property="JBinaryURLLinux", defaultValue="https://github.com/segator/jbinary/releases/download/%s/linux_amd64_jbinary_%s")
    private String JBinaryURLLinux;
    @Parameter(property="useMavenRepositoryJavaDownload")
    private boolean useMavenRepositoryJavaDownload = false;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String[] osList;
            File jBinaryExecutable = this.deployJBinary(SystemUtils.IS_OS_WINDOWS ? "windows" : "linux");
            for (String platform : osList = new String[]{"windows", "linux"}) {
                File generatedExecutableArtifact = this.generateExecutable(jBinaryExecutable, platform);
                this.archiveFile(generatedExecutableArtifact, platform);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoFailureException("unexpected error", (Throwable)ex);
        }
    }

    private void archiveFile(File file, String platform) {
        String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        this.projectHelper.attachArtifact(this.project, extension, platform, file);
    }

    private File deployJBinary(String platform) throws MalformedURLException, FileNotFoundException, IOException {
        String JBinaryURL = "";
        switch (platform) {
            case "windows": {
                JBinaryURL = this.JBinaryURLWindows;
                break;
            }
            case "linux": {
                JBinaryURL = this.JBinaryURLLinux;
            }
        }
        URL jbinaryURL = new URL(String.format(JBinaryURL, this.jBinaryVersion, this.jBinaryVersion));
        String JBinaryNameFile = FilenameUtils.getName((String)jbinaryURL.getPath());
        Path jbinaryPath = Paths.get(System.getProperty("java.io.tmpdir"), JBinaryNameFile);
        if (!jbinaryPath.toFile().exists()) {
            this.getLog().info((CharSequence)("Download -->" + jbinaryURL));
            ReadableByteChannel rbc = Channels.newChannel(jbinaryURL.openStream());
            try (FileOutputStream fos = new FileOutputStream(jbinaryPath.toFile());){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.flush();
            }
        }
        File jBinaryFile = jbinaryPath.toFile();
        jBinaryFile.setExecutable(true);
        return jBinaryFile;
    }

    private File generateExecutable(File jBinaryExecutable, String platform) throws IOException, InterruptedException {
        File resultBuildFile;
        this.getLog().info((CharSequence)("building executable file with embeded JRE version" + this.jreVersion));
        List repositories = this.project.getRepositories();
        boolean executed = false;
        for (Repository repository : repositories) {
            String serverURLParam = this.useMavenRepositoryJavaDownload ? String.format("-java-server-url \"%s\"", repository.getUrl()) : "";
            String commandString = String.format("\"%s\" -platform \"%s\" -output-name \"%s\" -jar \"%s\" -build \"%s\" %s", jBinaryExecutable.getAbsolutePath(), platform, this.finalName, this.project.getArtifact().getFile().getAbsolutePath(), this.outputDirectory.getAbsolutePath(), serverURLParam);
            CommandLine cmd = CommandLine.parse((String)commandString);
            this.getLog().info((CharSequence)String.format("Execute:%s", commandString));
            ExecuteWatchdog wd = new ExecuteWatchdog(-1L);
            DefaultExecutor exec = new DefaultExecutor();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)System.out);
            exec.setStreamHandler((ExecuteStreamHandler)psh);
            exec.setWatchdog(wd);
            try {
                exec.execute(cmd);
            }
            catch (ExecuteException ex) {
                if (ex.getExitValue() == -4) continue;
                throw ex;
            }
            executed = true;
        }
        if (!executed) {
            this.getLog().error((CharSequence)"No Valid Repository found to download JRE");
        }
        if (!(resultBuildFile = Paths.get(this.outputDirectory.getAbsolutePath(), this.finalName + (platform.equals("windows") ? ".exe" : ".bin")).toFile()).exists()) {
            throw new IOException("Result File " + resultBuildFile.getAbsolutePath() + " hasn't been generated");
        }
        return resultBuildFile;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public void setJreVersion(String jreVersion) {
        this.jreVersion = jreVersion;
    }

    public String getJBinaryURLWindows() {
        return this.JBinaryURLWindows;
    }

    public void setJBinaryURLWindows(String JBinaryURLWindows) {
        this.JBinaryURLWindows = JBinaryURLWindows;
    }

    public String getJBinaryURLLinux() {
        return this.JBinaryURLLinux;
    }

    public void setJBinaryURLLinux(String JBinaryURLLinux) {
        this.JBinaryURLLinux = JBinaryURLLinux;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public MavenArchiveConfiguration getArchive() {
        return this.archive;
    }

    public void setArchive(MavenArchiveConfiguration archive) {
        this.archive = archive;
    }

    public String getjBinaryVersion() {
        return this.jBinaryVersion;
    }

    public void setjBinaryVersion(String jBinaryVersion) {
        this.jBinaryVersion = jBinaryVersion;
    }
}

