/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.arch;

import com.github.seregamorph.maven.arch.JvmArchViolationException;
import com.github.seregamorph.maven.arch.MacOsSupport;
import com.github.seregamorph.maven.arch.Policy;
import com.github.seregamorph.maven.arch.Windows11Support;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="jvm-arch", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class JvmArchMojo
extends AbstractMojo {
    private static final String ANSI_RED = "\u001b[31m";
    private static final String PROP_SKIP_JVM_ARCH = "skipJvmArch";
    @Parameter(property="jvmArchPolicy", defaultValue="FAIL")
    private Policy policy = Policy.FAIL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block10: {
            if (Boolean.parseBoolean(System.getProperty(PROP_SKIP_JVM_ARCH))) {
                this.getLog().info((CharSequence)"Skipping architecture validation");
                return;
            }
            long startTime = System.nanoTime();
            try {
                String osArch = System.getProperty("os.arch");
                String osName = System.getProperty("os.name");
                this.getLog().debug((CharSequence)("os.arch: " + osArch));
                this.getLog().debug((CharSequence)("os.name: " + osName));
                if ("Mac OS X".equals(osName)) {
                    MacOsSupport.checkArch(this.getLog(), osArch);
                } else if ("Windows 11".equals(osName)) {
                    Windows11Support.checkArch(this.getLog(), osArch);
                }
            }
            catch (JvmArchViolationException e) {
                if (this.policy == Policy.WARN) {
                    this.getLog().warn((CharSequence)(ANSI_RED + e.getMessage()));
                    break block10;
                }
                this.getLog().info((CharSequence)"To skip this validation, use '-DskipJvmArch=true' option.");
                throw e;
            }
            finally {
                long executionTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                this.getLog().debug((CharSequence)("Execution time: " + executionTimeMs + "ms"));
            }
        }
    }
}

