/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.arch;

import com.github.seregamorph.maven.arch.JvmArchViolationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;

final class MacOsSupport {
    private static final String CMD_GET_CPU_BRAND = "sysctl -n machdep.cpu.brand_string";

    static void checkArch(Log log, String arch) throws JvmArchViolationException {
        block11: {
            if ("x86_64".equals(arch)) {
                try {
                    log.info((CharSequence)"Executing 'sysctl -n machdep.cpu.brand_string'");
                    Process process = Runtime.getRuntime().exec(CMD_GET_CPU_BRAND);
                    if (process.waitFor(5L, TimeUnit.SECONDS)) {
                        try (InputStream in = process.getInputStream();){
                            String cpuBrand = MacOsSupport.read(in).trim();
                            log.info((CharSequence)("CPU Brand: " + cpuBrand));
                            String javaHome = System.getProperty("java.home");
                            if (cpuBrand.startsWith("Apple ")) {
                                throw new JvmArchViolationException("The Maven is started on macOS x64-based JVM\n" + javaHome + " but the real CPU is '" + cpuBrand + "'. To avoid emulation performance overhead, please use the proper JVM for Apple Silicon (aarch64).");
                            }
                            break block11;
                        }
                    }
                    log.warn((CharSequence)"Timeout waiting for CPU brand");
                }
                catch (IOException | InterruptedException e) {
                    log.error((CharSequence)"Failed to get CPU architecture", (Throwable)e);
                }
            }
        }
    }

    private static String read(InputStream input) throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[1024];
        while ((read = input.read(buffer)) != -1) {
            builder.append(new String(buffer, 0, read));
        }
        return builder.toString();
    }

    private MacOsSupport() {
    }
}

