/*
 * Decompiled with CFR 0.152.
 */
package com.github.seregamorph.maven.arch;

import com.github.seregamorph.maven.arch.JvmArchViolationException;
import org.apache.maven.plugin.logging.Log;

class Windows11Support {
    static void checkArch(Log log, String arch) throws JvmArchViolationException {
        if ("amd64".equals(arch)) {
            String processorIdentifier = System.getenv("PROCESSOR_IDENTIFIER");
            log.info((CharSequence)("Processor identifier: " + processorIdentifier));
            if (processorIdentifier != null && processorIdentifier.contains("ARMv8")) {
                String javaHome = System.getProperty("java.home");
                throw new JvmArchViolationException("The Maven is started on Windows x64-based JVM\n" + javaHome + " but the real CPU is '" + processorIdentifier + "'. To avoid emulation performance overhead, please use the proper JVM for Windows (aarch64).");
            }
        }
    }

    private Windows11Support() {
    }
}

