/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.aws.lambda.cr.ssm;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersResult;
import java.util.List;
import org.apache.log4j.Logger;
import shiver.me.timbers.aws.lambda.cr.ssm.GetParametersResourceRequest;
import shiver.me.timbers.aws.lambda.cr.ssm.InvalidParametersException;
import shiver.me.timbers.aws.lambda.cr.ssm.Parameters;

class ParametersService {
    private final Logger log = Logger.getLogger(this.getClass());
    private final AWSSimpleSystemsManagement simpleSystemsManagement;

    ParametersService(AWSSimpleSystemsManagement simpleSystemsManagement) {
        this.simpleSystemsManagement = simpleSystemsManagement;
    }

    Parameters getParameters(GetParametersResourceRequest request) {
        this.log.info((Object)"Requesting the SSM parameters.");
        GetParametersResult result = this.simpleSystemsManagement.getParameters(new GetParametersRequest().withNames(request.getParameterNames()));
        List invalidParameters = result.getInvalidParameters();
        if (!invalidParameters.isEmpty()) {
            this.log.error((Object)String.format("Invalid parameters supplied: %s", result.getInvalidParameters()));
            throw new InvalidParametersException(invalidParameters);
        }
        return new Parameters(result.getParameters());
    }
}

