/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server;

import java.io.IOException;
import org.apache.log4j.Logger;
import shiver.me.timbers.webservice.stub.server.StubException;
import shiver.me.timbers.webservice.stub.server.StubRepository;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.api.StringStubResponse;
import shiver.me.timbers.webservice.stub.server.digest.Digester;

public class Stub {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Digester digester;
    private final StubRepository repository;

    public Stub(Digester digester, StubRepository repository) {
        this.digester = digester;
        this.repository = repository;
    }

    public StringStubResponse call(StringStubRequest request) {
        this.log.info((Object)String.format("REQUEST:\n%s", new Object[]{request}));
        String hash = this.digester.digestRequest(request);
        this.log.info((Object)String.format("Finding stubbed response for hash (%s).", hash));
        try {
            StringStubResponse response = this.repository.findResponseByHash(hash);
            this.log.info((Object)String.format("Saving stub call for hash (%s).", hash));
            this.repository.recordCall(hash, request);
            return response;
        }
        catch (IOException e) {
            throw new StubException(String.format("Failed to call the stub with hash (%s).", hash), e);
        }
    }
}

