/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import shiver.me.timbers.webservice.stub.api.Stubbing;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.api.StringStubResponse;

public abstract class StubRepository {
    static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSSS").withZone(ZoneId.systemDefault());
    private final Logger log = Logger.getLogger(this.getClass());
    private final ObjectMapper mapper;
    private final String directory;
    private final Clock clock;

    protected StubRepository(ObjectMapper mapper, String directory, Clock clock) {
        this.mapper = mapper;
        this.directory = directory;
        this.clock = clock;
    }

    public void save(String hash, Stubbing stubbing) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("request", this.mapper.writeValueAsString((Object)stubbing.getRequest()));
        map.put("response", this.mapper.writeValueAsString((Object)stubbing.getResponse()));
        map.entrySet().parallelStream().forEach(entry -> {
            String fileName = String.format("%s%s-%s.json", this.directory, hash, entry.getKey());
            this.log.info((Object)String.format("Saving the stubbing to (%s).", fileName));
            this.saveWithPath(fileName, (String)entry.getValue());
        });
    }

    public StringStubResponse findResponseByHash(String hash) throws IOException {
        String path = String.format("%s%s-response.json", this.directory, hash);
        this.log.info((Object)String.format("Getting response with path (%s).", path));
        return (StringStubResponse)((Object)this.mapper.readValue(this.findResponseByPath(path), StringStubResponse.class));
    }

    public List<String> findCallsByHash(String hash) throws IOException {
        return this.findCallsByPath(String.format("%s%s-called-", this.directory, hash));
    }

    public void recordCall(String hash, StringStubRequest request) throws IOException {
        this.recordCallWithPath(String.format("%s%s-called-%s.json", this.directory, hash, FORMATTER.format(this.clock.instant())), this.mapper.writeValueAsString((Object)request));
    }

    protected abstract void saveWithPath(String var1, String var2);

    protected abstract InputStream findResponseByPath(String var1) throws IOException;

    protected abstract List<String> findCallsByPath(String var1) throws IOException;

    protected abstract void recordCallWithPath(String var1, String var2) throws IOException;
}

