/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server;

import java.io.IOException;
import org.apache.log4j.Logger;
import shiver.me.timbers.webservice.stub.api.Stubbing;
import shiver.me.timbers.webservice.stub.server.StubRepository;
import shiver.me.timbers.webservice.stub.server.StubbingException;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.api.StringStubResponse;
import shiver.me.timbers.webservice.stub.server.digest.Digester;

public class Stubber {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Digester digester;
    private final StubRepository repository;

    public Stubber(Digester digester, StubRepository repository) {
        this.digester = digester;
        this.repository = repository;
    }

    public void stubCall(Stubbing<StringStubRequest, StringStubResponse> stubbing) {
        this.log.info((Object)String.format("REQUEST:\n%s", stubbing.getRequest()));
        this.log.info((Object)String.format("RESPONSE:\n%s", stubbing.getResponse()));
        String hash = this.digester.digestRequest((StringStubRequest)stubbing.getRequest());
        try {
            this.repository.save(hash, stubbing);
        }
        catch (IOException e) {
            throw new StubbingException(String.format("Failed to stub call with hash (%s).", hash), e);
        }
    }
}

