/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import shiver.me.timbers.webservice.stub.api.Verifying;
import shiver.me.timbers.webservice.stub.server.StubRepository;
import shiver.me.timbers.webservice.stub.server.VerifyRequestException;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.digest.Digester;

public class Verifier {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Digester digester;
    private final StubRepository repository;

    public Verifier(Digester digester, StubRepository repository) {
        this.digester = digester;
        this.repository = repository;
    }

    public void verify(Verifying<StringStubRequest> verifying) {
        this.log.info((Object)String.format("REQUEST:\n%s", verifying.getRequest()));
        String hash = this.digester.digestRequest((StringStubRequest)verifying.getRequest());
        try {
            List<String> calls = this.repository.findCallsByHash(hash);
            if (Verifier.calledMoreThanOnce(calls)) {
                this.log.info((Object)String.format("Verify for (%s) has failed. Request called more than once.", hash));
                throw new VerifyRequestException(String.format("Verify Failure. Request with hash (%s) called more than once.", hash));
            }
            if (Verifier.neverCalled(calls)) {
                this.log.info((Object)String.format("Verify for (%s) has failed. Request never called.", hash));
                throw new VerifyRequestException(String.format("Verify Failure. Request with hash (%s) was never called.", hash));
            }
        }
        catch (IOException e) {
            throw new VerifyRequestException(String.format("Verify Failure. Request with hash (%s) could not be retrieved.", hash), e);
        }
        this.log.info((Object)String.format("Verify for (%s) has succeeded.", hash));
    }

    private static boolean calledMoreThanOnce(List calls) {
        return calls.size() > 1;
    }

    private static boolean neverCalled(List calls) {
        return calls.size() < 1;
    }
}

