/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server.cleaning;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shiver.me.timbers.webservice.stub.api.StubHeaders;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.cleaning.BodyCleaner;
import shiver.me.timbers.webservice.stub.server.cleaning.CleaningException;
import shiver.me.timbers.webservice.stub.server.cleaning.NoOpBodyCleaner;

public class Cleaner {
    private final Set<String> keepHeaders;
    private final List<BodyCleaner> bodyCleaners;
    private final ObjectMapper mapper;

    public Cleaner(Set<String> keepHeaders, List<BodyCleaner> bodyCleaners, ObjectMapper mapper) {
        this.keepHeaders = keepHeaders;
        this.bodyCleaners = bodyCleaners;
        this.mapper = mapper;
    }

    public StringStubRequest cleanHeaders(StringStubRequest request) {
        Map<String, List> filteredHeaders = request.getHeaders().entrySet().stream().filter(entry -> this.keepHeaders.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        StringStubRequest requestCopy = request.copy();
        requestCopy.setHeaders(new StubHeaders(filteredHeaders));
        return requestCopy;
    }

    public StringStubRequest cleanBody(StringStubRequest request) {
        return this.bodyCleaners.stream().filter(cleaner -> cleaner.supports(request)).findFirst().orElse(new NoOpBodyCleaner()).cleanBody(request);
    }

    public String toCleanString(StringStubRequest request) {
        try {
            return this.mapper.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            throw new CleaningException(String.format("Failed to convert the request into a clean string:\n%s", new Object[]{request}), e);
        }
    }
}

