/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server.cleaning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import shiver.me.timbers.webservice.stub.api.StubContentType;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.cleaning.BodyCleaner;
import shiver.me.timbers.webservice.stub.server.cleaning.CleaningException;
import shiver.me.timbers.webservice.stub.server.cleaning.MapKeyFilter;

public abstract class JacksonBodyCleaner
implements BodyCleaner {
    private final ObjectMapper mapper;
    private final MapKeyFilter filter;

    public JacksonBodyCleaner(ObjectMapper mapper, MapKeyFilter filter) {
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper = mapper;
        this.filter = filter;
    }

    @Override
    public boolean supports(StringStubRequest request) {
        StubContentType contentType = request.getContentType();
        return contentType != null && this.isCorrectSubtype(contentType);
    }

    protected abstract boolean isCorrectSubtype(StubContentType var1);

    @Override
    public StringStubRequest cleanBody(StringStubRequest request) {
        try {
            return (StringStubRequest)request.copy().withBody(this.mapper.writeValueAsString(this.filter.filterKeys((Map)this.mapper.readValue((String)request.getBody(), Map.class))));
        }
        catch (IOException e) {
            throw new CleaningException(String.format("Failed to clean JSON request:\n%s", new Object[]{request}), e);
        }
    }
}

