/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server.cleaning;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapKeyFilter {
    private final Set<String> fieldsToIgnore;

    public MapKeyFilter(Set<String> fieldsToIgnore) {
        this.fieldsToIgnore = fieldsToIgnore;
    }

    public Map<String, Object> filterKeys(Map<String, Object> map) {
        return map.entrySet().stream().filter(this::isNotIgnored).map(this::filterValue).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isNotIgnored(Map.Entry<String, Object> entry) {
        return !this.fieldsToIgnore.contains(entry.getKey());
    }

    private Map.Entry<String, Object> filterValue(Map.Entry<String, Object> entry) {
        Object value = entry.getValue();
        if (value instanceof Map) {
            return new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), this.filterKeys((Map)value));
        }
        return entry;
    }
}

