/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.webservice.stub.server.digest;

import org.apache.log4j.Logger;
import shiver.me.timbers.webservice.stub.server.api.StringStubRequest;
import shiver.me.timbers.webservice.stub.server.cleaning.Cleaner;
import shiver.me.timbers.webservice.stub.server.digest.Encoding;
import shiver.me.timbers.webservice.stub.server.digest.MessageDigestFactory;

public class Digester {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Cleaner cleaner;
    private final MessageDigestFactory factory;
    private final Encoding encoding;

    public Digester(Cleaner cleaner, MessageDigestFactory factory, Encoding encoding) {
        this.cleaner = cleaner;
        this.factory = factory;
        this.encoding = encoding;
    }

    public String digestRequest(StringStubRequest request) {
        String requestString = this.cleaner.toCleanString(this.cleaner.cleanHeaders(this.cleaner.cleanBody(request)));
        this.log.info((Object)String.format("Digesting XML:\n%s", requestString));
        return this.encoding.toHex(this.factory.create("MD5").digest(requestString.getBytes()));
    }
}

