/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.kv.impl.file;

import com.github.shoothzj.kv.api.IPutCallback;
import com.github.shoothzj.kv.api.exception.KvException;
import com.github.shoothzj.kv.api.module.KvGetResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKvImplHelper {
    private static final Logger log = LoggerFactory.getLogger(FileKvImplHelper.class);
    private String folderName;
    private File folder;

    public FileKvImplHelper(String folderName) {
        boolean mkdir;
        this.folderName = folderName;
        this.folder = new File(folderName);
        if (!this.folder.exists() && !(mkdir = this.folder.mkdir())) {
            throw new RuntimeException("folder create failed.");
        }
    }

    public void put(String group, String key, String value, IPutCallback iPutCallback) {
        File file = new File(this.folderName + "/" + group + ".kv");
        try {
            if (!file.exists() && !file.createNewFile()) {
                log.error("create file failed ");
                throw new RuntimeException("create file failed");
            }
            Properties prop = new Properties();
            prop.load(new FileInputStream(file));
            prop.setProperty(key, value);
            prop.store(new FileOutputStream(file), null);
        }
        catch (IOException e) {
            iPutCallback.fail(new KvException((Throwable)e));
        }
    }

    public KvGetResult get(String group, String key) {
        KvGetResult kvGetResult = new KvGetResult();
        File file = new File(this.folderName + "/" + group + ".kv");
        try (FileInputStream input = new FileInputStream(file);){
            Properties prop = new Properties();
            prop.load(input);
            kvGetResult.setContent(prop.getProperty(key));
        }
        catch (IOException ex) {
            kvGetResult.setKvException(new KvException((Throwable)ex));
        }
        return kvGetResult;
    }
}

