/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.sdk.codec.bk;

import com.github.shoothzj.javatool.util.HexUtil;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BkNetworkCodec {
    private static final Logger log = LoggerFactory.getLogger(BkNetworkCodec.class);
    private static final int BYTE_PREFIX = 4;

    public static BookkeeperProtocol.Response decodeRespNetwork(String hexStr) {
        byte[] bytes = HexUtil.hexStrToByteArray((String)hexStr);
        byte[] content = Arrays.copyOfRange(bytes, 4, bytes.length);
        return BkNetworkCodec.decodeRespContent(content);
    }

    public static BookkeeperProtocol.Response decodeRespContent(String hexStr) {
        return BkNetworkCodec.decodeRespContent(HexUtil.hexStrToByteArray((String)hexStr));
    }

    public static BookkeeperProtocol.Response decodeRespNetwork(byte[] bytes) {
        byte[] content = Arrays.copyOfRange(bytes, 4, bytes.length);
        return BkNetworkCodec.decodeRespContent(content);
    }

    public static BookkeeperProtocol.Response decodeRespContent(byte[] bytes) {
        try {
            return BookkeeperProtocol.Response.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("invalid proto buf is ", (Throwable)e);
            return null;
        }
    }

    public static BookkeeperProtocol.Request decodeReqNetwork(String hexStr) {
        byte[] bytes = HexUtil.hexStrToByteArray((String)hexStr);
        byte[] content = Arrays.copyOfRange(bytes, 4, bytes.length);
        return BkNetworkCodec.decodeReqContent(content);
    }

    public static BookkeeperProtocol.Request decodeReqContent(String hexStr) {
        return BkNetworkCodec.decodeReqContent(HexUtil.hexStrToByteArray((String)hexStr));
    }

    public static BookkeeperProtocol.Request decodeReqNetwork(byte[] bytes) {
        byte[] content = Arrays.copyOfRange(bytes, 4, bytes.length);
        return BkNetworkCodec.decodeReqContent(content);
    }

    public static BookkeeperProtocol.Request decodeReqContent(byte[] bytes) {
        try {
            return BookkeeperProtocol.Request.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("invalid proto buf is ", (Throwable)e);
            return null;
        }
    }
}

