package com.github.shoothzj.sdk.http;

import com.github.shoothzj.sdk.http.module.HttpPoolConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;

/**
 * @author hezhangjian
 */
@Slf4j
public class HttpPoolManager {

    private static final HttpPoolManager instance = new HttpPoolManager();

    public static HttpPoolManager getInstance() {
        return instance;
    }

    public static CloseableHttpClient createHttpPool(HttpPoolConfig httpPoolConfig) {
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create()
                .setMaxConnPerRoute(httpPoolConfig.getMaxConnPerRoute()).setMaxConnTotal(httpPoolConfig.getMaxConnTotal()).build();
        return HttpClients.custom().setConnectionManager(connectionManager).build();
    }

}