/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.structureblocklib.bukkit.v1_9_R2;

import com.github.shynixn.structureblocklib.api.bukkit.block.StructureBlockData;
import com.github.shynixn.structureblocklib.api.bukkit.block.StructureBlockLoad;
import com.github.shynixn.structureblocklib.api.bukkit.block.StructureBlockSave;
import com.github.shynixn.structureblocklib.api.entity.StructureLoaderAbstract;
import com.github.shynixn.structureblocklib.api.entity.StructureSaverAbstract;
import com.github.shynixn.structureblocklib.api.enumeration.StructureMirror;
import com.github.shynixn.structureblocklib.api.enumeration.StructureMode;
import com.github.shynixn.structureblocklib.api.enumeration.StructureRotation;
import com.github.shynixn.structureblocklib.api.service.TypeConversionService;
import com.github.shynixn.structureblocklib.core.block.StructureBlockAbstractImpl;
import net.minecraft.server.v1_9_R2.EnumBlockMirror;
import net.minecraft.server.v1_9_R2.EnumBlockRotation;
import net.minecraft.server.v1_9_R2.NBTTagCompound;
import net.minecraft.server.v1_9_R2.TileEntityStructure;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_9_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R2.block.CraftBlockState;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftStructureBlock
extends CraftBlockState
implements StructureBlockData,
StructureBlockSave,
StructureBlockLoad {
    public StructureBlockAbstractImpl<Location, Vector> internalBlock;
    public TypeConversionService conversionService;
    public TileEntityStructure tileEntityStructure;

    public CraftStructureBlock(StructureBlockAbstractImpl<Location, Vector> structure, TypeConversionService conversionService, Block block) {
        super(block);
        CraftWorld world = (CraftWorld)block.getWorld();
        this.internalBlock = structure;
        this.conversionService = conversionService;
        this.tileEntityStructure = (TileEntityStructure)world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
        if (this.tileEntityStructure == null) {
            throw new IllegalArgumentException("The block at " + world.getName() + " " + this.getX() + " " + this.getY() + " " + this.getZ() + " is not a StructureBlock.");
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.tileEntityStructure.save(compound);
        this.setSaveName(compound.getString("name"));
        this.setAuthor(compound.getString("author"));
        this.setBlockNameMetaData(compound.getString("metadata"));
        this.setStructureLocation(new Location(block.getWorld(), (double)compound.getInt("posX"), (double)compound.getInt("posY"), (double)compound.getInt("posZ")));
        this.setSizeX(compound.getInt("sizeX"));
        this.setSizeY(compound.getInt("sizeY"));
        this.setSizeZ(compound.getInt("sizeZ"));
        this.setIncludeEntities(!compound.getBoolean("ignoreEntities"));
        this.setBoundingBoxVisible(compound.getBoolean("showboundingbox"));
        this.setInvisibleBlocksEnabled(compound.getBoolean("showair"));
        this.setMirrorType(conversionService.convertToStructureMirror((Object)EnumBlockMirror.valueOf((String)compound.getString("mirror"))));
        this.setRotationType(conversionService.convertToStructureRotation((Object)EnumBlockRotation.valueOf((String)compound.getString("rotation"))));
        this.setStructureMode(conversionService.convertToStructureMode((Object)TileEntityStructure.UsageMode.valueOf((String)compound.getString("mode"))));
    }

    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.tileEntityStructure.save(compound);
        compound.setString("name", this.getSaveName());
        compound.setString("author", this.getAuthor());
        compound.setString("metadata", this.getBlockNameMetaData());
        compound.setInt("posX", this.getStructureLocation().getBlockX());
        compound.setInt("posY", this.getStructureLocation().getBlockY());
        compound.setInt("posZ", this.getStructureLocation().getBlockZ());
        compound.setInt("sizeX", this.getSizeX());
        compound.setInt("sizeY", this.getSizeY());
        compound.setInt("sizeZ", this.getSizeZ());
        compound.setBoolean("showboundingbox", this.isBoundingBoxVisible());
        compound.setBoolean("showair", this.isInvisibleBlocksEnabled());
        compound.setBoolean("ignoreEntities", !this.isIncludeEntitiesEnabled());
        compound.setString("rotation", this.conversionService.convertToRotationHandle(this.getRotationType()).toString());
        compound.setString("mirror", this.conversionService.convertToMirrorHandle(this.getMirrorType()).toString());
        compound.setString("mode", this.conversionService.convertToStructureModeHandle(this.getStructureMode()).toString());
        this.tileEntityStructure.a(compound);
        this.tileEntityStructure.update();
        return result;
    }

    public void setMirrorType(@NotNull StructureMirror mirrorType) {
        this.internalBlock.setMirrorType(mirrorType);
    }

    public void setRotationType(@NotNull StructureRotation rotation) {
        this.internalBlock.setRotationType(rotation);
    }

    @NotNull
    public StructureRotation getRotationType() {
        return this.internalBlock.getRotationType();
    }

    @NotNull
    public StructureMirror getMirrorType() {
        return this.internalBlock.getMirrorType();
    }

    public void setBoundingBoxVisible(boolean visible) {
        this.internalBlock.setBoundingBoxVisible(visible);
    }

    public boolean isBoundingBoxVisible() {
        return this.internalBlock.isBoundingBoxVisible();
    }

    public void setIntegrity(float integrity) {
        this.internalBlock.setIntegrity(integrity);
    }

    public float getIntegrity() {
        return this.internalBlock.getIntegrity();
    }

    public void setSeed(long seed) {
        this.internalBlock.setSeed(seed);
    }

    public long getSeed() {
        return this.internalBlock.getSeed();
    }

    public void setAuthor(@Nullable String author) {
        this.internalBlock.setAuthor(author);
    }

    @Nullable
    public String getAuthor() {
        return this.internalBlock.getAuthor();
    }

    public void setStructureLocation(@Nullable Location location) {
        this.internalBlock.setStructureLocation((Object)location);
    }

    @Nullable
    public Location getStructureLocation() {
        return (Location)this.internalBlock.getStructureLocation();
    }

    public void setIncludeEntities(boolean flag) {
        this.internalBlock.setIncludeEntities(flag);
    }

    public boolean isIncludeEntitiesEnabled() {
        return this.internalBlock.isIncludeEntitiesEnabled();
    }

    public void setSizeX(int sizeX) {
        this.internalBlock.setSizeX(sizeX);
    }

    public void setSizeY(int sizeY) {
        this.internalBlock.setSizeY(sizeY);
    }

    public void setSizeZ(int sizeZ) {
        this.internalBlock.setSizeZ(sizeZ);
    }

    public int getSizeX() {
        return this.internalBlock.getSizeX();
    }

    public int getSizeY() {
        return this.internalBlock.getSizeY();
    }

    public int getSizeZ() {
        return this.internalBlock.getSizeZ();
    }

    public void setSaveName(@Nullable String name) {
        this.internalBlock.setSaveName(name);
    }

    @Nullable
    public String getSaveName() {
        return this.internalBlock.getSaveName();
    }

    public void setBlockNameMetaData(@Nullable String blockNameMetaData) {
        this.internalBlock.setBlockNameMetaData(blockNameMetaData);
    }

    @Nullable
    public String getBlockNameMetaData() {
        return this.internalBlock.getBlockNameMetaData();
    }

    public void setInvisibleBlocksEnabled(boolean flag) {
        this.internalBlock.setInvisibleBlocksEnabled(flag);
    }

    public boolean isInvisibleBlocksEnabled() {
        return this.internalBlock.isInvisibleBlocksEnabled();
    }

    public void setStructureMode(@NotNull StructureMode structureMode) {
        this.internalBlock.setStructureMode(structureMode);
    }

    @NotNull
    public StructureMode getStructureMode() {
        return this.internalBlock.getStructureMode();
    }

    @NotNull
    public StructureLoaderAbstract<Location, Vector> loadStructure() {
        return this.internalBlock.loadStructure();
    }

    @NotNull
    public StructureSaverAbstract<Location, Vector> saveStructure() {
        return this.internalBlock.saveStructure();
    }
}

