/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.structureblocklib.bukkit.v1_19_R1;

import com.github.shynixn.structureblocklib.api.entity.StructureEntity;
import com.github.shynixn.structureblocklib.api.entity.StructurePlaceMeta;
import com.github.shynixn.structureblocklib.api.entity.StructurePlacePart;
import com.github.shynixn.structureblocklib.api.entity.StructureReadMeta;
import com.github.shynixn.structureblocklib.api.service.StructureWorldService;
import com.github.shynixn.structureblocklib.api.service.TypeConversionService;
import com.github.shynixn.structureblocklib.core.entity.GenericWrapper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureWorldServiceImpl
implements StructureWorldService {
    private final TypeConversionService conversionService;

    public StructureWorldServiceImpl(TypeConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void placeStructureToWorld(StructurePlaceMeta meta, Object structure) throws Exception {
        if (!(structure instanceof StructureTemplate)) {
            throw new IllegalArgumentException("StructureTemplate has to be an NMS handle!");
        }
        StructureTemplate template = (StructureTemplate)structure;
        World bukkitWorld = Bukkit.getWorld((String)meta.getLocation().getWorldName());
        ServerLevel world = ((CraftWorld)bukkitWorld).getHandle();
        BlockPos cornerBlock = new BlockPos((int)meta.getLocation().getX(), (int)meta.getLocation().getY(), (int)meta.getLocation().getZ());
        StructurePlaceSettings info = new StructurePlaceSettings();
        info.setIgnoreEntities(!meta.isIncludeEntitiesEnabled());
        info.setMirror((Mirror)this.conversionService.convertToMirrorHandle(meta.getMirrorType()));
        info.setRotation((Rotation)this.conversionService.convertToRotationHandle(meta.getRotationType()));
        if (meta.getIntegrity() < 1.0f) {
            info.clearProcessors();
            float rotation = Mth.clamp((float)meta.getIntegrity(), (float)0.0f, (float)1.0f);
            BlockRotProcessor rotationProcessor = new BlockRotProcessor(rotation);
            RandomSource random = RandomSource.create();
            if (meta.getSeed() != 0L) {
                random = RandomSource.create((long)meta.getSeed());
            }
            info.addProcessor((StructureProcessor)rotationProcessor);
            info.setRandom(random);
        }
        this.executeProcessors(bukkitWorld, meta, info);
        this.executeEntityProcessor(meta, bukkitWorld, template.entityInfoList);
        template.placeInWorld((ServerLevelAccessor)world, cornerBlock, cornerBlock, info, RandomSource.create(), 2);
    }

    public Object readStructureFromWorld(StructureReadMeta meta) {
        ServerLevel world = ((CraftWorld)Bukkit.getWorld((String)meta.getLocation().getWorldName())).getHandle();
        BlockPos cornerBlock = new BlockPos((int)meta.getLocation().getX(), (int)meta.getLocation().getY(), (int)meta.getLocation().getZ());
        BlockPos offsetBlock = new BlockPos((int)meta.getOffset().getX(), (int)meta.getOffset().getY(), (int)meta.getOffset().getZ());
        Block structureVoid = Blocks.STRUCTURE_VOID;
        StructureTemplate template = new StructureTemplate();
        template.fillFromWorld((Level)world, cornerBlock, (Vec3i)offsetBlock, meta.isIncludeEntitiesEnabled(), structureVoid);
        template.setAuthor(meta.getAuthor());
        return template;
    }

    private void executeProcessors(final World bukkitWorld, final StructurePlaceMeta meta, StructurePlaceSettings info) {
        info.addProcessor(new StructureProcessor(){

            @Nullable
            public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos1, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo1, StructurePlaceSettings structurePlaceSettings) {
                final GenericWrapper targetBlockState = new GenericWrapper((Object)structureBlockInfo.state);
                final CraftBlock sourceCraftBlock = new CraftBlock(null, structureBlockInfo.pos){

                    public BlockState getNMS() {
                        return (BlockState)targetBlockState.item;
                    }

                    public void setBlockData(BlockData data, boolean applyPhysics) {
                        targetBlockState.item = ((CraftBlockData)data).getState();
                    }
                };
                BlockPos sourcePos = blockPos1;
                final org.bukkit.block.Block targetBlock = bukkitWorld.getBlockAt(new Location(bukkitWorld, (double)sourcePos.getX(), (double)sourcePos.getY(), (double)sourcePos.getZ()));
                StructurePlacePart<org.bukkit.block.Block, World> structurePlacePart = new StructurePlacePart<org.bukkit.block.Block, World>(){

                    @NotNull
                    public org.bukkit.block.Block getSourceBlock() {
                        return sourceCraftBlock;
                    }

                    @NotNull
                    public org.bukkit.block.Block getTargetBlock() {
                        return targetBlock;
                    }

                    @NotNull
                    public World getWorld() {
                        return bukkitWorld;
                    }
                };
                for (Function processor : meta.getProcessors()) {
                    Function processHandle = processor;
                    boolean result = (Boolean)processHandle.apply(structurePlacePart);
                    if (result) continue;
                    return null;
                }
                if (!meta.isIncludeBlockEnabled()) {
                    return null;
                }
                return new StructureTemplate.StructureBlockInfo(structureBlockInfo1.pos, (BlockState)targetBlockState.item, structureBlockInfo1.nbt);
            }

            protected StructureProcessorType<?> getType() {
                return () -> null;
            }
        });
    }

    private void executeEntityProcessor(StructurePlaceMeta meta, final World bukkitWorld, List<StructureTemplate.StructureEntityInfo> structureEntityInfos) {
        for (final StructureTemplate.StructureEntityInfo entityInfo : structureEntityInfos.toArray(new StructureTemplate.StructureEntityInfo[0])) {
            final GenericWrapper peekEntity = new GenericWrapper(null);
            StructureEntity<Entity, Location> structureEntity = new StructureEntity<Entity, Location>(){

                public Optional<Entity> spawnEntity(Location location) {
                    Optional optEntity = EntityType.create((CompoundTag)entityInfo.nbt, (Level)((CraftWorld)location.getWorld()).getHandle());
                    if (optEntity.isPresent()) {
                        ((net.minecraft.world.entity.Entity)optEntity.get()).setUUID(UUID.randomUUID());
                        ((CraftWorld)location.getWorld()).addEntity((net.minecraft.world.entity.Entity)optEntity.get(), CreatureSpawnEvent.SpawnReason.CUSTOM);
                        ((net.minecraft.world.entity.Entity)optEntity.get()).getBukkitEntity().teleport(location);
                        return Optional.of(((net.minecraft.world.entity.Entity)optEntity.get()).getBukkitEntity());
                    }
                    return Optional.empty();
                }

                public Optional<Entity> getEntity() {
                    Optional optEntity;
                    if (peekEntity.item == null && (optEntity = EntityType.create((CompoundTag)entityInfo.nbt, (Level)((CraftWorld)bukkitWorld).getHandle())).isPresent()) {
                        peekEntity.item = ((net.minecraft.world.entity.Entity)optEntity.get()).getBukkitEntity();
                    }
                    return Optional.ofNullable((Entity)peekEntity.item);
                }

                public Location getSourceLocation() {
                    BlockPos sourcePos = entityInfo.blockPos;
                    return new Location(null, (double)sourcePos.getX(), (double)sourcePos.getY(), (double)sourcePos.getZ());
                }

                public String getNbtData() {
                    return entityInfo.nbt.toString();
                }
            };
            for (Function processor : meta.getEntityProcessors()) {
                Function processHandle = processor;
                boolean result = (Boolean)processHandle.apply(structureEntity);
                if (result) continue;
                structureEntityInfos.remove(entityInfo);
            }
            if (peekEntity.item == null) continue;
            ((Entity)peekEntity.item).remove();
        }
    }
}

