/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.structureblocklib.bukkit.v1_19_R1;

import com.github.shynixn.structureblocklib.api.bukkit.block.StructureBlockData;
import com.github.shynixn.structureblocklib.api.bukkit.block.StructureBlockLoad;
import com.github.shynixn.structureblocklib.api.bukkit.block.StructureBlockSave;
import com.github.shynixn.structureblocklib.api.entity.StructureLoaderAbstract;
import com.github.shynixn.structureblocklib.api.entity.StructureSaverAbstract;
import com.github.shynixn.structureblocklib.api.enumeration.StructureMirror;
import com.github.shynixn.structureblocklib.api.enumeration.StructureRotation;
import com.github.shynixn.structureblocklib.api.service.TypeConversionService;
import com.github.shynixn.structureblocklib.core.block.StructureBlockAbstractImpl;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.block.CraftBlockState;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftStructureBlock
extends CraftBlockState
implements StructureBlockData,
StructureBlockSave,
StructureBlockLoad {
    public StructureBlockAbstractImpl<Location, Vector, Block, Entity, World> internalBlock;
    public TypeConversionService conversionService;
    public StructureBlockEntity tileEntityStructure;

    public CraftStructureBlock(StructureBlockAbstractImpl<Location, Vector, Block, Entity, World> structure, TypeConversionService conversionService, Block block) {
        super(block);
        CraftWorld world = (CraftWorld)block.getWorld();
        this.internalBlock = structure;
        this.conversionService = conversionService;
        this.tileEntityStructure = (StructureBlockEntity)world.getHandle().getBlockEntity(new BlockPos(this.getX(), this.getY(), this.getZ()), true);
        if (this.tileEntityStructure == null) {
            throw new IllegalArgumentException("The block at " + world.getName() + " " + this.getX() + " " + this.getY() + " " + this.getZ() + " is not a StructureBlock.");
        }
        CompoundTag compound = new CompoundTag();
        compound = this.saveCompoundTileEntityStructure(this.tileEntityStructure, compound);
        this.setSaveName(compound.getString("name"));
        this.setAuthor(compound.getString("author"));
        this.setBlockNameMetaData(compound.getString("metadata"));
        this.setStructureLocation(new Location(block.getWorld(), (double)compound.getInt("posX"), (double)compound.getInt("posY"), (double)compound.getInt("posZ")));
        this.setSizeX(compound.getInt("sizeX"));
        this.setSizeY(compound.getInt("sizeY"));
        this.setSizeZ(compound.getInt("sizeZ"));
        this.setIncludeEntities(!compound.getBoolean("ignoreEntities"));
        this.setBoundingBoxVisible(compound.getBoolean("showboundingbox"));
        this.setInvisibleBlocksEnabled(compound.getBoolean("showair"));
        this.setIntegrity(compound.getFloat("integrity"));
        this.setSeed(compound.getLong("seed"));
        this.setMirrorType(conversionService.convertToStructureMirror((Object)Mirror.valueOf((String)compound.getString("mirror"))));
        this.setRotationType(conversionService.convertToStructureRotation((Object)Rotation.valueOf((String)compound.getString("rotation"))));
        this.setStructureMode(conversionService.convertToStructureMode((Object)StructureMode.valueOf((String)compound.getString("mode"))));
    }

    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        CompoundTag compound = new CompoundTag();
        compound = this.saveCompoundTileEntityStructure(this.tileEntityStructure, compound);
        compound.putString("name", this.getSaveName());
        compound.putString("author", this.getAuthor());
        compound.putString("metadata", this.getBlockNameMetaData());
        compound.putInt("posX", this.getStructureLocation().getBlockX());
        compound.putInt("posY", this.getStructureLocation().getBlockY());
        compound.putInt("posZ", this.getStructureLocation().getBlockZ());
        compound.putInt("sizeX", this.getSizeX());
        compound.putInt("sizeY", this.getSizeY());
        compound.putInt("sizeZ", this.getSizeZ());
        compound.putBoolean("showboundingbox", this.isBoundingBoxVisible());
        compound.putBoolean("showair", this.isInvisibleBlocksEnabled());
        compound.putBoolean("ignoreEntities", !this.isIncludeEntitiesEnabled());
        compound.putFloat("integrity", this.getIntegrity());
        compound.putLong("seed", this.getSeed());
        compound.putString("rotation", this.conversionService.convertToRotationHandle(this.getRotationType()).toString());
        compound.putString("mirror", this.conversionService.convertToMirrorHandle(this.getMirrorType()).toString());
        compound.putString("mode", this.conversionService.convertToStructureModeHandle(this.getStructureMode()).toString());
        this.loadCompoundTileEntityStructure(this.tileEntityStructure, compound);
        this.setChangedTileEntityStructure(this.tileEntityStructure);
        return result;
    }

    public void setMirrorType(@NotNull StructureMirror mirrorType) {
        this.internalBlock.setMirrorType(mirrorType);
    }

    public void setRotationType(@NotNull StructureRotation rotation) {
        this.internalBlock.setRotationType(rotation);
    }

    @NotNull
    public StructureRotation getRotationType() {
        return this.internalBlock.getRotationType();
    }

    @NotNull
    public StructureMirror getMirrorType() {
        return this.internalBlock.getMirrorType();
    }

    public void setBoundingBoxVisible(boolean visible) {
        this.internalBlock.setBoundingBoxVisible(visible);
    }

    public boolean isBoundingBoxVisible() {
        return this.internalBlock.isBoundingBoxVisible();
    }

    public void setIntegrity(float integrity) {
        this.internalBlock.setIntegrity(integrity);
    }

    public float getIntegrity() {
        return this.internalBlock.getIntegrity();
    }

    public void setSeed(long seed) {
        this.internalBlock.setSeed(seed);
    }

    public long getSeed() {
        return this.internalBlock.getSeed();
    }

    public void setAuthor(@Nullable String author) {
        this.internalBlock.setAuthor(author);
    }

    @Nullable
    public String getAuthor() {
        return this.internalBlock.getAuthor();
    }

    public void setStructureLocation(@Nullable Location location) {
        this.internalBlock.setStructureLocation((Object)location);
    }

    @Nullable
    public Location getStructureLocation() {
        return (Location)this.internalBlock.getStructureLocation();
    }

    public void setIncludeEntities(boolean flag) {
        this.internalBlock.setIncludeEntities(flag);
    }

    public boolean isIncludeEntitiesEnabled() {
        return this.internalBlock.isIncludeEntitiesEnabled();
    }

    public void setSizeX(int sizeX) {
        this.internalBlock.setSizeX(sizeX);
    }

    public void setSizeY(int sizeY) {
        this.internalBlock.setSizeY(sizeY);
    }

    public void setSizeZ(int sizeZ) {
        this.internalBlock.setSizeZ(sizeZ);
    }

    public int getSizeX() {
        return this.internalBlock.getSizeX();
    }

    public int getSizeY() {
        return this.internalBlock.getSizeY();
    }

    public int getSizeZ() {
        return this.internalBlock.getSizeZ();
    }

    public void setSaveName(@Nullable String name) {
        this.internalBlock.setSaveName(name);
    }

    @Nullable
    public String getSaveName() {
        return this.internalBlock.getSaveName();
    }

    public void setBlockNameMetaData(@Nullable String blockNameMetaData) {
        this.internalBlock.setBlockNameMetaData(blockNameMetaData);
    }

    @Nullable
    public String getBlockNameMetaData() {
        return this.internalBlock.getBlockNameMetaData();
    }

    public void setInvisibleBlocksEnabled(boolean flag) {
        this.internalBlock.setInvisibleBlocksEnabled(flag);
    }

    public boolean isInvisibleBlocksEnabled() {
        return this.internalBlock.isInvisibleBlocksEnabled();
    }

    public void setStructureMode(@NotNull com.github.shynixn.structureblocklib.api.enumeration.StructureMode structureMode) {
        this.internalBlock.setStructureMode(structureMode);
    }

    @NotNull
    public com.github.shynixn.structureblocklib.api.enumeration.StructureMode getStructureMode() {
        return this.internalBlock.getStructureMode();
    }

    @NotNull
    public StructureLoaderAbstract<Location, Vector, Block, Entity, World> loadStructure() {
        return this.internalBlock.loadStructure();
    }

    @NotNull
    public StructureSaverAbstract<Location, Vector> saveStructure() {
        return this.internalBlock.saveStructure();
    }

    private CompoundTag saveCompoundTileEntityStructure(StructureBlockEntity tileEntityStructure, CompoundTag compoundTag) {
        try {
            Method method = StructureBlockEntity.class.getDeclaredMethod("b", CompoundTag.class);
            method.setAccessible(true);
            method.invoke((Object)tileEntityStructure, compoundTag);
            return compoundTag;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCompoundTileEntityStructure(StructureBlockEntity tileEntityStructure, CompoundTag compoundTag) {
        try {
            Method method = StructureBlockEntity.class.getDeclaredMethod("a", CompoundTag.class);
            method.invoke((Object)tileEntityStructure, compoundTag);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setChangedTileEntityStructure(StructureBlockEntity tileEntityStructure) {
        try {
            Method method = BlockEntity.class.getDeclaredMethod("e", new Class[0]);
            method.invoke((Object)tileEntityStructure, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

