/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.api.directory;

import com.github.siroshun09.messages.api.directory.FileExtension;
import com.github.siroshun09.messages.api.directory.LoadedMessageSource;
import com.github.siroshun09.messages.api.source.MessageSource;
import com.github.siroshun09.messages.api.util.Loader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectorySource<S extends MessageSource<?>> {
    private final Path directory;
    private final Collection<Locale> defaultLocales = new ArrayList<Locale>();
    @Nullable
    private FileExtension fileExtension;
    @Nullable
    private Loader<Path, ? extends S> loader;

    @Contract(value="_ -> new")
    @NotNull
    public static <S extends MessageSource<?>> DirectorySource<S> create(@NotNull Path directory) {
        return new DirectorySource<S>(Objects.requireNonNull(directory));
    }

    private DirectorySource(@NotNull Path directory) {
        this.directory = directory;
    }

    @NotNull
    public DirectorySource<S> fileExtension(@NotNull FileExtension fileExtension) {
        this.fileExtension = Objects.requireNonNull(fileExtension);
        return this;
    }

    @NotNull
    public DirectorySource<S> defaultLocale(@NotNull Locale locale) {
        this.defaultLocales.add(Objects.requireNonNull(locale));
        return this;
    }

    @NotNull
    public DirectorySource<S> defaultLocale(Locale ... locales) {
        Objects.requireNonNull(locales);
        this.defaultLocales.addAll(Arrays.asList(locales));
        return this;
    }

    @NotNull
    public DirectorySource<S> defaultLocale(@NotNull Collection<Locale> locales) {
        this.defaultLocales.addAll(Objects.requireNonNull(locales));
        return this;
    }

    @NotNull
    public DirectorySource<S> messageLoader(@NotNull Loader<Path, ? extends S> loader) {
        this.loader = Objects.requireNonNull(loader);
        return this;
    }

    public void load(@NotNull Loader<LoadedMessageSource<S>, Void> consumer) throws IOException {
        Path filepath;
        if (this.fileExtension == null) {
            throw new IllegalStateException("localeParser is not set");
        }
        if (this.loader == null) {
            throw new IllegalStateException("loader is not set");
        }
        Objects.requireNonNull(consumer);
        Map<Path, Locale> file2LocaleMap = DirectorySource.collectPath(this.directory, this.fileExtension);
        if (file2LocaleMap.isEmpty()) {
            if (this.defaultLocales.isEmpty()) {
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        for (Locale locale : this.defaultLocales) {
            Objects.requireNonNull(locale);
            filepath = this.directory.resolve(this.fileExtension.toFilename(locale));
            file2LocaleMap.putIfAbsent(filepath, locale);
        }
        for (Map.Entry entry : file2LocaleMap.entrySet()) {
            filepath = (Path)entry.getKey();
            Locale locale = (Locale)entry.getValue();
            consumer.apply(new LoadedMessageSource<MessageSource>(filepath, locale, (MessageSource)this.loader.load(filepath)));
        }
    }

    @NotNull
    private static Map<Path, Locale> collectPath(@NotNull Path directory, @NotNull FileExtension fileExtension) throws IOException {
        if (Files.isDirectory(directory, new LinkOption[0])) {
            HashMap<Path, Locale> fileLocaleMap = new HashMap<Path, Locale>();
            try (Stream<Path> list = Files.list(directory);){
                list.forEach(path -> {
                    Locale locale;
                    if (Files.isRegularFile(path, new LinkOption[0]) && (locale = fileExtension.parse(path.getFileName().toString())) != null) {
                        fileLocaleMap.put((Path)path, locale);
                    }
                });
            }
            return fileLocaleMap;
        }
        return new HashMap<Path, Locale>();
    }
}

