/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.api.directory;

import com.github.siroshun09.messages.api.directory.DefaultFileExtension;
import com.github.siroshun09.messages.api.util.LocaleParser;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FileExtension {
    @NotNull
    public static FileExtension create(@NotNull String extension) {
        return new DefaultFileExtension(Objects.requireNonNull(extension));
    }

    @NotNull
    public String extension();

    @NotNull
    default public String toFilename(@NotNull Locale locale) {
        return Objects.requireNonNull(locale) + this.extension();
    }

    @Nullable
    default public Locale parse(@NotNull String filename) {
        return filename.endsWith(this.extension()) ? LocaleParser.parse(filename.substring(0, filename.length() - this.extension().length())) : null;
    }
}

