/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.api.localize;

import com.github.siroshun09.messages.api.localize.Localization;
import com.github.siroshun09.messages.api.source.FallingBackMessageSource;
import com.github.siroshun09.messages.api.source.MessageSource;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractLocalization<T, M extends MessageSource<T>, FB extends FallingBackMessageSource<T, M>>
implements Localization<T, M, FB> {
    private final Map<Locale, M> sourceMap = new ConcurrentHashMap<Locale, M>();
    private final M defaultSource;

    protected AbstractLocalization(@NotNull M defaultSource) {
        this.defaultSource = (MessageSource)Objects.requireNonNull(defaultSource);
    }

    @Override
    @NotNull
    public M defaultSource() {
        return this.defaultSource;
    }

    @Override
    @Nullable
    public M getSource(@NotNull Locale locale) {
        MessageSource source = (MessageSource)this.sourceMap.get(Objects.requireNonNull(locale));
        return (M)(source != null ? source : (MessageSource)this.sourceMap.get(new Locale(locale.getLanguage())));
    }

    @Override
    public void addSource(@NotNull Locale locale, @NotNull M source) {
        this.sourceMap.put(Objects.requireNonNull(locale), (MessageSource)Objects.requireNonNull(source));
    }

    @Override
    public void removeSource(@NotNull Locale locale) {
        this.sourceMap.remove(Objects.requireNonNull(locale));
    }

    @Override
    public void clearSources() {
        this.sourceMap.clear();
    }

    @Override
    @NotNull
    public @Unmodifiable Map<Locale, M> sourceMap() {
        return Map.copyOf(this.sourceMap);
    }
}

