/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.api.source;

import com.github.siroshun09.messages.api.source.MessageMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class AbstractMessageMap<T>
implements MessageMap<T> {
    private final Map<String, T> messageMap;

    protected AbstractMessageMap(@NotNull Map<String, T> messageMap) {
        this.messageMap = Objects.requireNonNull(messageMap);
    }

    @Override
    public boolean hasMessage(@NotNull String key) {
        Objects.requireNonNull(key);
        return this.messageMap.containsKey(key);
    }

    @Override
    @NotNull
    public T getMessage(@NotNull String key) {
        return this.messageMap.getOrDefault(key, this.empty());
    }

    @Override
    @NotNull
    public MessageMap<T> addMessage(@NotNull String key, @NotNull T message) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(message);
        this.messageMap.put(key, message);
        return this;
    }

    @Override
    @NotNull
    public MessageMap<T> removeMessage(@NotNull String key) {
        Objects.requireNonNull(key);
        this.messageMap.remove(key);
        return this;
    }

    @Override
    public void merge(@NotNull Map<String, T> other) {
        for (Map.Entry<String, T> entry : other.entrySet()) {
            this.messageMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, T> mergeAndCollectMissingMessages(@NotNull Map<String, T> other) {
        LinkedHashMap<String, T> missingMessages = new LinkedHashMap<String, T>();
        for (Map.Entry<String, T> entry : other.entrySet()) {
            if (this.messageMap.putIfAbsent(entry.getKey(), entry.getValue()) != null) continue;
            missingMessages.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(missingMessages);
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<String, T> asMap() {
        return Collections.unmodifiableMap(this.messageMap);
    }

    @NotNull
    protected abstract T empty();
}

