/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.api.util;

import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocaleParser {
    private static final Pattern SPLITTER = Pattern.compile("_");

    @Nullable
    public static Locale parse(@NotNull String string) {
        if (string.isEmpty()) {
            return null;
        }
        String[] segments = SPLITTER.split(string, 3);
        int length = segments.length;
        Locale.Builder builder = new Locale.Builder();
        if (length == 1) {
            builder.setLanguage(string);
        } else if (length == 2) {
            builder.setLanguage(segments[0]).setRegion(segments[1]);
        } else {
            return null;
        }
        return builder.build();
    }

    private LocaleParser() {
        throw new UnsupportedOperationException();
    }
}

