/*
 * Decompiled with CFR 0.152.
 */
package com.github.siroshun09.messages.api.util;

import com.github.siroshun09.messages.api.directory.FileExtension;
import com.github.siroshun09.messages.api.source.StringMessageMap;
import com.github.siroshun09.messages.api.util.Loader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public final class PropertiesFile {
    public static final FileExtension FILE_EXTENSION = FileExtension.create(".properties");
    public static final Loader<Path, StringMessageMap> DEFAULT_LOADER = filepath -> {
        if (Files.isRegularFile(filepath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(filepath, StandardCharsets.UTF_8);){
                StringMessageMap stringMessageMap = StringMessageMap.create(PropertiesFile.load(reader));
                return stringMessageMap;
            }
        }
        return StringMessageMap.create();
    };

    @NotNull
    public static Map<String, String> load(@NotNull Reader reader) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        new PropertiesReader((Map<String, String>)map).load(reader);
        return map;
    }

    @NotNull
    public static Map<String, String> load(@NotNull InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Map<String, String> map = PropertiesFile.load(reader);
            return map;
        }
    }

    @NotNull
    public static Map<String, String> load(@NotNull Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return new LinkedHashMap<String, String>();
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Map<String, String> map = PropertiesFile.load(reader);
            return map;
        }
    }

    public static void append(@NotNull Writer writer, @NotNull Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            PropertiesFile.appendEscapedString(entry.getKey(), true, writer);
            writer.write(61);
            PropertiesFile.appendEscapedString(entry.getValue(), false, writer);
            writer.write(System.lineSeparator());
        }
    }

    public static void append(@NotNull OutputStream outputStream, @NotNull Map<String, String> map) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            PropertiesFile.append(writer, map);
        }
    }

    public static void append(@NotNull Path file, @NotNull Map<String, String> map) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            PropertiesFile.append(writer, map);
        }
    }

    private static void appendEscapedString(@NotNull String theString, boolean escapeSpace, @NotNull Writer writer) throws IOException {
        char[] chars = theString.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ('=' < c && c < '\u007f') {
                if (c == '\\') {
                    writer.append('\\').append('\\');
                    continue;
                }
                writer.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || escapeSpace) {
                        writer.append('\\');
                    }
                    writer.append(' ');
                    continue block8;
                }
                case '\t': {
                    writer.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    writer.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    writer.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    writer.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    writer.append('\\').append(c);
                    continue block8;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private PropertiesFile() {
        throw new UnsupportedOperationException();
    }

    private static final class PropertiesReader
    extends Properties {
        private final Map<String, String> map;

        private PropertiesReader(@NotNull Map<String, String> map) {
            this.map = map;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            return this.map.put(String.valueOf(key), String.valueOf(value));
        }
    }
}

