/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast;

import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.proto.QueryType;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.net.Util;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    public final QueryType type;
    public final long token;
    public final Optional<ReqlAst> term;
    public final OptArgs globalOptions;
    static final Logger logger = LoggerFactory.getLogger(Query.class);

    public Query(QueryType type, long token, ReqlAst term, OptArgs globalOptions) {
        this.type = type;
        this.token = token;
        this.term = Optional.ofNullable(term);
        this.globalOptions = globalOptions;
    }

    public Query(QueryType type, long token) {
        this(type, token, null, new OptArgs());
    }

    public static Query stop(long token) {
        return new Query(QueryType.STOP, token, null, new OptArgs());
    }

    public static Query continue_(long token) {
        return new Query(QueryType.CONTINUE, token, null, new OptArgs());
    }

    public static Query start(long token, ReqlAst term, OptArgs globalOptions) {
        return new Query(QueryType.START, token, term, globalOptions);
    }

    public static Query noreplyWait(long token) {
        return new Query(QueryType.NOREPLY_WAIT, token, null, new OptArgs());
    }

    public ByteBuffer serialize() {
        JSONArray queryArr = new JSONArray();
        queryArr.add((Object)this.type.value);
        this.term.ifPresent(t -> queryArr.add(t.build()));
        if (!this.globalOptions.isEmpty()) {
            queryArr.add(ReqlAst.buildOptarg(this.globalOptions));
        }
        String queryJson = queryArr.toJSONString();
        byte[] queryBytes = queryJson.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = Util.leByteBuffer(12 + queryBytes.length).putLong(this.token).putInt(queryBytes.length).put(queryBytes);
        logger.debug("JSON Send: Token: {} {}", (Object)this.token, (Object)queryJson);
        return bb;
    }
}

