/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast;

import com.rethinkdb.annotations.IgnoreNullFields;
import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.ast.Datum;
import com.rethinkdb.gen.ast.Func;
import com.rethinkdb.gen.ast.Iso8601;
import com.rethinkdb.gen.ast.MakeArray;
import com.rethinkdb.gen.ast.MakeObj;
import com.rethinkdb.gen.ast.ReqlExpr;
import com.rethinkdb.gen.exc.ReqlDriverCompileError;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.model.Arguments;
import com.rethinkdb.model.MapObject;
import com.rethinkdb.model.ReqlLambda;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Util {
    private Util() {
    }

    public static ReqlAst toReqlAst(Object val) {
        return Util.toReqlAst(val, 100);
    }

    public static ReqlExpr toReqlExpr(Object val) {
        ReqlAst converted = Util.toReqlAst(val);
        if (converted instanceof ReqlExpr) {
            return (ReqlExpr)converted;
        }
        throw new ReqlDriverError("Cannot convert %s to ReqlExpr", val);
    }

    private static ReqlAst toReqlAst(Object val, int remainingDepth) {
        if (remainingDepth <= 0) {
            throw new ReqlDriverCompileError("Recursion limit reached converting to ReqlAst");
        }
        if (val instanceof ReqlAst) {
            return (ReqlAst)val;
        }
        if (val instanceof Object[]) {
            Arguments innerValues = new Arguments();
            for (Object innerValue : Arrays.asList((Object[])val)) {
                innerValues.add(Util.toReqlAst(innerValue, remainingDepth - 1));
            }
            return new MakeArray(innerValues, null);
        }
        if (val instanceof List) {
            Arguments innerValues = new Arguments();
            for (Object innerValue : (List)val) {
                innerValues.add(Util.toReqlAst(innerValue, remainingDepth - 1));
            }
            return new MakeArray(innerValues, null);
        }
        if (val instanceof Map) {
            MapObject obj = new MapObject();
            for (Map.Entry entry : ((Map)val).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new ReqlDriverCompileError("Object keys can only be strings");
                }
                obj.put((String)entry.getKey(), Util.toReqlAst(entry.getValue()));
            }
            return MakeObj.fromMap(obj);
        }
        if (val instanceof ReqlLambda) {
            return Func.fromLambda((ReqlLambda)val);
        }
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        if (val instanceof LocalDateTime) {
            ZonedDateTime zdt = ((LocalDateTime)val).atZone(ZoneId.systemDefault());
            return Iso8601.fromString(zdt.format(fmt));
        }
        if (val instanceof ZonedDateTime) {
            return Iso8601.fromString(((ZonedDateTime)val).format(fmt));
        }
        if (val instanceof OffsetDateTime) {
            return Iso8601.fromString(((OffsetDateTime)val).format(fmt));
        }
        if (val instanceof Integer) {
            return new Datum((Integer)val);
        }
        if (val instanceof Number) {
            return new Datum((Number)val);
        }
        if (val instanceof Boolean) {
            return new Datum((Boolean)val);
        }
        if (val instanceof String) {
            return new Datum((String)val);
        }
        if (val == null) {
            return new Datum(null);
        }
        if (val.getClass().isEnum()) {
            return new Datum(((Enum)val).name());
        }
        return Util.toReqlAst(Util.toMap(val));
    }

    private static Map<String, Object> toMap(Object pojo) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> pojoClass = pojo.getClass();
            if (!Modifier.isPublic(pojoClass.getModifiers())) {
                throw new IllegalAccessException(String.format("%s's class should be public", pojo));
            }
            BeanInfo info = Introspector.getBeanInfo(pojoClass);
            boolean notSaveNull = pojoClass.isAnnotationPresent(IgnoreNullFields.class);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                Method reader = descriptor.getReadMethod();
                if (reader == null || reader.getDeclaringClass() != pojoClass) continue;
                Object value = reader.invoke(pojo, new Object[0]);
                if (notSaveNull && value == null) continue;
                map.put(descriptor.getName(), value);
            }
            return map;
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new ReqlDriverError("Can't convert %s to a ReqlAst: %s", pojo, e.getMessage());
        }
    }
}

