/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.proto;

import java.util.Optional;

public enum DatumType {
    R_NULL(1),
    R_BOOL(2),
    R_NUM(3),
    R_STR(4),
    R_ARRAY(5),
    R_OBJECT(6),
    R_JSON(7);

    public final int value;

    private DatumType(int value) {
        this.value = value;
    }

    public static DatumType fromValue(int value) {
        switch (value) {
            case 1: {
                return R_NULL;
            }
            case 2: {
                return R_BOOL;
            }
            case 3: {
                return R_NUM;
            }
            case 4: {
                return R_STR;
            }
            case 5: {
                return R_ARRAY;
            }
            case 6: {
                return R_OBJECT;
            }
            case 7: {
                return R_JSON;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a legal value for DatumType", value));
    }

    public static Optional<DatumType> maybeFromValue(int value) {
        try {
            return Optional.of(DatumType.fromValue(value));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }
}

