/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.proto;

import java.util.Optional;

public enum ErrorType {
    INTERNAL(1000000),
    RESOURCE_LIMIT(2000000),
    QUERY_LOGIC(3000000),
    NON_EXISTENCE(3100000),
    OP_FAILED(4100000),
    OP_INDETERMINATE(4200000),
    USER(5000000);

    public final int value;

    private ErrorType(int value) {
        this.value = value;
    }

    public static ErrorType fromValue(int value) {
        switch (value) {
            case 1000000: {
                return INTERNAL;
            }
            case 2000000: {
                return RESOURCE_LIMIT;
            }
            case 3000000: {
                return QUERY_LOGIC;
            }
            case 3100000: {
                return NON_EXISTENCE;
            }
            case 4100000: {
                return OP_FAILED;
            }
            case 4200000: {
                return OP_INDETERMINATE;
            }
            case 5000000: {
                return USER;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a legal value for ErrorType", value));
    }

    public static Optional<ErrorType> maybeFromValue(int value) {
        try {
            return Optional.of(ErrorType.fromValue(value));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }
}

