/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.ast.Query;
import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.ast.Db;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.gen.proto.Protocol;
import com.rethinkdb.gen.proto.Version;
import com.rethinkdb.model.Arguments;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.net.Converter;
import com.rethinkdb.net.Cursor;
import com.rethinkdb.net.Response;
import com.rethinkdb.net.SocketWrapper;
import com.rethinkdb.net.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public final String hostname;
    public final int port;
    private final AtomicLong nextToken = new AtomicLong();
    private Optional<String> dbname;
    private Optional<Long> connectTimeout;
    private Optional<SSLContext> sslContext;
    private final ByteBuffer handshake;
    Optional<SocketWrapper> socket = Optional.empty();
    private Map<Long, Cursor> cursorCache = new ConcurrentHashMap<Long, Cursor>();
    private ExecutorService exec;
    private final Map<Long, CompletableFuture<Response>> awaiters = new ConcurrentHashMap<Long, CompletableFuture<Response>>();
    private Exception awaiterException = null;
    private final ReentrantLock lock = new ReentrantLock();

    public Connection(Builder builder) {
        this.dbname = builder.dbname;
        String authKey = builder.authKey.orElse("");
        this.handshake = Util.leByteBuffer(8 + authKey.length() + 4).putInt(Version.V0_4.value).putInt(authKey.length()).put(authKey.getBytes()).putInt(Protocol.JSON.value);
        this.handshake.flip();
        this.hostname = builder.hostname.orElse("localhost");
        this.port = builder.port.orElse(28015);
        if (builder.certFile.isPresent()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate caCert = (X509Certificate)cf.generateCertificate((InputStream)builder.certFile.get());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null);
                ks.setCertificateEntry("caCert", caCert);
                tmf.init(ks);
                SSLContext ssc = SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
                ssc.init(null, tmf.getTrustManagers(), null);
                this.sslContext = Optional.of(ssc);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new ReqlDriverError(e);
            }
        } else {
            this.sslContext = builder.sslContext;
        }
        this.connectTimeout = builder.timeout;
    }

    public static Builder build() {
        return new Builder();
    }

    public Optional<String> db() {
        return this.dbname;
    }

    public void connect() throws TimeoutException {
        this.connect(Optional.empty());
    }

    public Connection reconnect() {
        try {
            return this.reconnect(false, Optional.empty());
        }
        catch (TimeoutException toe) {
            throw new RuntimeException("Timeout can't happen here.");
        }
    }

    public Connection reconnect(boolean noreplyWait, Optional<Long> timeout) throws TimeoutException {
        if (!timeout.isPresent()) {
            timeout = this.connectTimeout;
        }
        this.close(noreplyWait);
        this.connect(timeout);
        return this;
    }

    void connect(Optional<Long> timeout) throws TimeoutException {
        SocketWrapper sock = new SocketWrapper(this.hostname, this.port, this.sslContext, timeout.isPresent() ? timeout : this.connectTimeout);
        sock.connect(this.handshake);
        this.socket = Optional.of(sock);
        this.exec = Executors.newSingleThreadExecutor();
        this.exec.submit(() -> {
            while (true) {
                if (!this.isOpen()) {
                    this.awaiterException = new IOException("The socket is closed, exiting response pump.");
                    this.close();
                    break;
                }
                try {
                    Response response = this.socket.orElseThrow(() -> new ReqlDriverError("No socket available.")).read();
                    CompletableFuture<Response> awaiter = this.awaiters.remove(response.token);
                    if (awaiter == null) continue;
                    awaiter.complete(response);
                }
                catch (IOException e) {
                    this.awaiterException = e;
                    this.close();
                    break;
                }
            }
        });
    }

    public boolean isOpen() {
        return this.socket.map(SocketWrapper::isOpen).orElse(false);
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean shouldNoreplyWait) {
        try {
            if (shouldNoreplyWait) {
                this.noreplyWait();
            }
        }
        finally {
            this.nextToken.set(0L);
            for (Cursor cursor : this.cursorCache.values()) {
                cursor.setError("Connection is closed.");
            }
            this.cursorCache.clear();
            this.awaiters.values().stream().forEach(awaiter -> {
                if (this.awaiterException != null) {
                    awaiter.completeExceptionally(this.awaiterException);
                } else {
                    awaiter.cancel(true);
                }
            });
            this.awaiters.clear();
            if (this.exec != null && !this.exec.isShutdown()) {
                this.exec.shutdown();
            }
            this.socket.ifPresent(SocketWrapper::close);
        }
    }

    public void use(String db) {
        this.dbname = Optional.ofNullable(db);
    }

    public Optional<Long> timeout() {
        return this.connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Response> sendQuery(Query query, Optional<Long> deadline) {
        if (!this.exec.isShutdown() && !this.exec.isTerminated()) {
            CompletableFuture awaiter = new CompletableFuture();
            this.awaiters.put(query.token, awaiter);
            try {
                this.lock.lock();
                this.socket.orElseThrow(() -> new ReqlDriverError("No socket available.")).write(query.serialize());
                CompletableFuture<Response> completableFuture = awaiter.toCompletableFuture();
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new ReqlDriverError("Can't write query because response pump is not running.");
    }

    void runQueryNoreply(Query query) {
        this.runQueryNoreply(query, Optional.empty());
    }

    void runQueryNoreply(Query query, Optional<Long> timeout) {
        this.runQuery(query, Optional.empty(), timeout);
    }

    <T> T runQuery(Query query) {
        return this.runQuery(query, Optional.empty());
    }

    <T, P> T runQuery(Query query, Optional<Class<P>> pojoClass) {
        return this.runQuery(query, pojoClass, Optional.empty());
    }

    <T, P> T runQuery(Query query, Optional<Class<P>> pojoClass, Optional<Long> timeout) {
        Response res = null;
        try {
            res = this.sendQuery(query, timeout).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ReqlDriverError(e);
        }
        if (res.isAtom()) {
            try {
                Converter.FormatOptions fmt = new Converter.FormatOptions(query.globalOptions);
                Object value = ((List)Converter.convertPseudotypes(res.data, fmt)).get(0);
                return Util.convertToPojo(value, pojoClass);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ReqlDriverError("Atom response was empty!", ex);
            }
        }
        if (res.isPartial() || res.isSequence()) {
            Cursor cursor = Cursor.create(this, query, res, pojoClass);
            return (T)cursor;
        }
        if (res.isWaitComplete()) {
            return null;
        }
        throw res.makeError(query);
    }

    private long newToken() {
        return this.nextToken.incrementAndGet();
    }

    void addToCache(long token, Cursor cursor) {
        this.cursorCache.put(token, cursor);
    }

    void removeFromCache(long token) {
        this.cursorCache.remove(token);
    }

    public void noreplyWait() {
        this.runQuery(Query.noreplyWait(this.newToken()));
    }

    private void setDefaultDB(OptArgs globalOpts) {
        if (!globalOpts.containsKey("db") && this.dbname.isPresent()) {
            globalOpts.with("db", this.dbname.get());
        }
        if (globalOpts.containsKey("db")) {
            globalOpts.with("db", new Db(Arguments.make(globalOpts.get("db"))));
        }
    }

    public <T, P> T run(ReqlAst term, OptArgs globalOpts, Optional<Class<P>> pojoClass) {
        return this.run(term, globalOpts, pojoClass, Optional.empty());
    }

    public <T, P> T run(ReqlAst term, OptArgs globalOpts, Optional<Class<P>> pojoClass, Optional<Long> timeout) {
        this.setDefaultDB(globalOpts);
        Query q = Query.start(this.newToken(), term, globalOpts);
        if (globalOpts.containsKey("noreply")) {
            throw new ReqlDriverError("Don't provide the noreply option as an optarg. Use `.runNoReply` instead of `.run`");
        }
        return this.runQuery(q, pojoClass, timeout);
    }

    public void runNoReply(ReqlAst term, OptArgs globalOpts) {
        this.setDefaultDB(globalOpts);
        globalOpts.with("noreply", true);
        this.runQueryNoreply(Query.start(this.newToken(), term, globalOpts));
    }

    Future<Response> continue_(Cursor cursor) {
        return this.sendQuery(Query.continue_(cursor.token), Optional.empty());
    }

    void stop(Cursor cursor) {
        this.runQueryNoreply(Query.stop(cursor.token));
    }

    public static class Builder {
        private Optional<String> hostname = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<String> dbname = Optional.empty();
        private Optional<String> authKey = Optional.empty();
        private Optional<InputStream> certFile = Optional.empty();
        private Optional<SSLContext> sslContext = Optional.empty();
        private Optional<Long> timeout = Optional.empty();

        public Builder hostname(String val) {
            this.hostname = Optional.of(val);
            return this;
        }

        public Builder port(int val) {
            this.port = Optional.of(val);
            return this;
        }

        public Builder db(String val) {
            this.dbname = Optional.of(val);
            return this;
        }

        public Builder authKey(String val) {
            this.authKey = Optional.of(val);
            return this;
        }

        public Builder certFile(InputStream val) {
            this.certFile = Optional.of(val);
            return this;
        }

        public Builder sslContext(SSLContext val) {
            this.sslContext = Optional.of(val);
            return this;
        }

        public Builder timeout(long val) {
            this.timeout = Optional.of(val);
            return this;
        }

        public Connection connect() {
            Connection conn = new Connection(this);
            conn.reconnect();
            return conn;
        }
    }
}

