/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.ast.Query;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.gen.exc.ReqlRuntimeError;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.net.Connection;
import com.rethinkdb.net.Converter;
import com.rethinkdb.net.Response;
import com.rethinkdb.net.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class Cursor<T>
implements Iterator<T>,
Iterable<T> {
    public final long token;
    protected final Connection connection;
    protected final Query query;
    protected final boolean _isFeed;
    protected Deque<T> items = new ArrayDeque<T>();
    protected int outstandingRequests = 0;
    protected int threshold = 1;
    protected Optional<RuntimeException> error = Optional.empty();
    protected Future<Response> awatingContinue = null;

    public Cursor(Connection connection, Query query, Response firstResponse) {
        this.connection = connection;
        this.query = query;
        this.token = query.token;
        this._isFeed = firstResponse.isFeed();
        connection.addToCache(query.token, this);
        this.maybeSendContinue();
        this.extendInternal(firstResponse);
    }

    public void close() {
        if (!this.error.isPresent()) {
            this.error = Optional.of(new NoSuchElementException());
            if (this.connection.isOpen()) {
                ++this.outstandingRequests;
                this.connection.stop(this);
            }
        }
    }

    public int bufferedSize() {
        return this.items.size();
    }

    public ArrayList<T> bufferedItems() {
        return new ArrayList<T>(this.items);
    }

    public boolean isFeed() {
        return this._isFeed;
    }

    void extend(Response response) {
        --this.outstandingRequests;
        this.maybeSendContinue();
        this.extendInternal(response);
    }

    private void extendInternal(Response response) {
        this.threshold = response.data.size();
        if (!this.error.isPresent()) {
            if (response.isPartial()) {
                this.items.addAll((Collection<T>)response.data);
            } else if (response.isSequence()) {
                this.items.addAll((Collection<T>)response.data);
                this.error = Optional.of(new NoSuchElementException());
            } else {
                this.error = Optional.of(response.makeError(this.query));
            }
        }
        if (this.outstandingRequests == 0 && this.error.isPresent()) {
            this.connection.removeFromCache(response.token);
        }
    }

    protected void maybeSendContinue() {
        if (!this.error.isPresent() && this.items.size() < this.threshold && this.outstandingRequests == 0) {
            ++this.outstandingRequests;
            this.awatingContinue = this.connection.continue_(this);
        }
    }

    protected void waitOnCursorItems() {
        Response res = null;
        try {
            res = this.awatingContinue.get();
        }
        catch (Exception e) {
            throw new ReqlDriverError(e);
        }
        this.extend(res);
    }

    protected void waitOnCursorItems(long timeout) {
        Response res = null;
        try {
            res = this.awatingContinue.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new ReqlDriverError(e);
        }
        this.extend(res);
    }

    void setError(String errMsg) {
        if (!this.error.isPresent()) {
            this.error = Optional.of(new ReqlRuntimeError(errMsg));
            Response dummyResponse = Response.make(this.query.token, ResponseType.SUCCESS_SEQUENCE).build();
            this.extendInternal(dummyResponse);
        }
    }

    public static <T> Cursor<T> create(Connection connection, Query query, Response firstResponse, Optional<Class<T>> pojoClass) {
        return new DefaultCursor<T>(connection, query, firstResponse, pojoClass);
    }

    @Override
    public T next() {
        try {
            return this.getNext(Optional.empty());
        }
        catch (TimeoutException toe) {
            throw new RuntimeException("Timeout can't happen here");
        }
    }

    public T next(long timeout) throws TimeoutException {
        return this.getNext(Optional.of(timeout));
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public List<T> toList() {
        ArrayList list = new ArrayList();
        this.forEachRemaining(list::add);
        return list;
    }

    abstract T getNext(Optional<Long> var1) throws TimeoutException;

    private static class DefaultCursor<T>
    extends Cursor<T> {
        private final Optional<Class<T>> pojoClass;
        public final Converter.FormatOptions fmt;

        public DefaultCursor(Connection connection, Query query, Response firstResponse, Optional<Class<T>> pojoClass) {
            super(connection, query, firstResponse);
            this.pojoClass = pojoClass;
            this.fmt = new Converter.FormatOptions(query.globalOptions);
        }

        @Override
        public boolean hasNext() {
            if (this.items.size() > 0) {
                return true;
            }
            if (this.error.isPresent()) {
                return false;
            }
            if (this._isFeed) {
                return true;
            }
            this.maybeSendContinue();
            this.waitOnCursorItems();
            return this.items.size() > 0;
        }

        @Override
        T getNext(Optional<Long> timeout) throws TimeoutException {
            long endTime = 0L;
            if (timeout.isPresent() && timeout.get() > 0L) {
                endTime = System.currentTimeMillis() + timeout.get();
            }
            while (this.items.size() == 0) {
                this.maybeSendContinue();
                if (endTime > 0L) {
                    this.waitOnCursorItems(Math.max(endTime - System.currentTimeMillis(), 1L));
                } else {
                    this.waitOnCursorItems();
                }
                if (this.items.size() != 0) break;
                this.error.ifPresent(exc -> {
                    throw exc;
                });
            }
            Object value = Converter.convertPseudotypes(this.items.pop(), this.fmt);
            return Util.convertToPojo(value, this.pojoClass);
        }
    }
}

