/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.ErrorBuilder;
import com.rethinkdb.ast.Query;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.gen.proto.ErrorType;
import com.rethinkdb.gen.proto.ResponseNote;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.model.Backtrace;
import com.rethinkdb.model.Profile;
import com.rethinkdb.net.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Response {
    public final long token;
    public final ResponseType type;
    public final ArrayList<ResponseNote> notes;
    public final JSONArray data;
    public final Optional<Profile> profile;
    public final Optional<Backtrace> backtrace;
    public final Optional<ErrorType> errorType;
    static final Logger logger = LoggerFactory.getLogger(Query.class);

    public static Response parseFrom(long token, ByteBuffer buf) {
        if (logger.isDebugEnabled()) {
            logger.debug("JSON Recv: Token: {} {}", (Object)token, (Object)Util.bufferToString(buf));
        }
        InputStreamReader codepointReader = new InputStreamReader(new ByteArrayInputStream(buf.array()));
        JSONObject jsonResp = (JSONObject)JSONValue.parse((Reader)codepointReader);
        ResponseType responseType = ResponseType.fromValue(((Long)jsonResp.get((Object)"t")).intValue());
        ArrayList responseNoteVals = (ArrayList)jsonResp.getOrDefault((Object)"n", new ArrayList());
        ArrayList responseNotes = responseNoteVals.stream().map(Long::intValue).map(ResponseNote::maybeFromValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ArrayList::new));
        Builder res = new Builder(token, responseType);
        if (jsonResp.containsKey((Object)"e")) {
            res.setErrorType(((Long)jsonResp.get((Object)"e")).intValue());
        }
        return res.setNotes(responseNotes).setProfile((JSONArray)jsonResp.getOrDefault((Object)"p", null)).setBacktrace((JSONArray)jsonResp.getOrDefault((Object)"b", null)).setData((JSONArray)jsonResp.getOrDefault((Object)"r", (Object)new JSONArray())).build();
    }

    private Response(long token, ResponseType responseType, JSONArray data, ArrayList<ResponseNote> responseNotes, Optional<Profile> profile, Optional<Backtrace> backtrace, Optional<ErrorType> errorType) {
        this.token = token;
        this.type = responseType;
        this.data = data;
        this.notes = responseNotes;
        this.profile = profile;
        this.backtrace = backtrace;
        this.errorType = errorType;
    }

    static Builder make(long token, ResponseType type) {
        return new Builder(token, type);
    }

    boolean isWaitComplete() {
        return this.type == ResponseType.WAIT_COMPLETE;
    }

    boolean isFeed() {
        return this.notes.stream().anyMatch(ResponseNote::isFeed);
    }

    boolean isError() {
        return this.type.isError();
    }

    boolean isAtom() {
        return this.type == ResponseType.SUCCESS_ATOM;
    }

    boolean isSequence() {
        return this.type == ResponseType.SUCCESS_SEQUENCE;
    }

    boolean isPartial() {
        return this.type == ResponseType.SUCCESS_PARTIAL;
    }

    ReqlError makeError(Query query) {
        String msg = this.data.size() > 0 ? (String)this.data.get(0) : "Unknown error message";
        return new ErrorBuilder(msg, this.type).setBacktrace(this.backtrace).setErrorType(this.errorType).setTerm(query).build();
    }

    public String toString() {
        return "Response{token=" + this.token + ", type=" + (Object)((Object)this.type) + ", notes=" + this.notes + ", data=" + this.data + ", profile=" + this.profile + ", backtrace=" + this.backtrace + '}';
    }

    static class Builder {
        long token;
        ResponseType responseType;
        ArrayList<ResponseNote> notes = new ArrayList();
        JSONArray data = new JSONArray();
        Optional<Profile> profile = Optional.empty();
        Optional<Backtrace> backtrace = Optional.empty();
        Optional<ErrorType> errorType = Optional.empty();

        Builder(long token, ResponseType responseType) {
            this.token = token;
            this.responseType = responseType;
        }

        Builder setNotes(ArrayList<ResponseNote> notes) {
            this.notes.addAll(notes);
            return this;
        }

        Builder setData(JSONArray data) {
            if (data != null) {
                this.data = data;
            }
            return this;
        }

        Builder setProfile(JSONArray profile) {
            this.profile = Profile.fromJSONArray(profile);
            return this;
        }

        Builder setBacktrace(JSONArray backtrace) {
            this.backtrace = Backtrace.fromJSONArray(backtrace);
            return this;
        }

        Builder setErrorType(int value) {
            this.errorType = Optional.of(ErrorType.fromValue(value));
            return this;
        }

        Response build() {
            return new Response(this.token, this.responseType, this.data, this.notes, this.profile, this.backtrace, this.errorType);
        }
    }
}

