/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.exc.ReqlDriverError;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class Util {
    static SimpleDateFormat dtf = new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy", Locale.ENGLISH);

    public static long deadline(long timeout) {
        return System.currentTimeMillis() + timeout;
    }

    public static ByteBuffer leByteBuffer(int capacity) {
        byte[] underlying = new byte[capacity];
        return ByteBuffer.wrap(underlying).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static String bufferToString(ByteBuffer buf) {
        return new String(buf.array(), StandardCharsets.UTF_8);
    }

    public static <T, P> T convertToPojo(Object value, Optional<Class<P>> pojoClass) {
        return (T)(!pojoClass.isPresent() || !(value instanceof Map) ? value : Util.toPojo(pojoClass.get(), (Map)value));
    }

    public static <T> T convertToPojo(Object value, Class pojoClass) {
        return (T)(!(value instanceof Map) ? value : Util.toPojo(pojoClass, (Map)value));
    }

    private static <T> T toPojo(Class<T> pojoClass, Map<String, Object> map) {
        try {
            if (map == null) {
                return null;
            }
            if (LocalDate.class.equals(pojoClass)) {
                return (T)LocalDate.of(((Long)map.get("year")).intValue(), ((Long)map.get("monthValue")).intValue(), ((Long)map.get("dayOfMonth")).intValue());
            }
            if (LocalTime.class.equals(pojoClass)) {
                return (T)LocalTime.of(((Long)map.get("hour")).intValue(), ((Long)map.get("minute")).intValue(), ((Long)map.get("second")).intValue(), ((Long)map.get("nano")).intValue());
            }
            if (LocalDateTime.class.equals(pojoClass)) {
                return (T)LocalDateTime.of(((Long)map.get("year")).intValue(), ((Long)map.get("monthValue")).intValue(), ((Long)map.get("dayOfMonth")).intValue(), ((Long)map.get("hour")).intValue(), ((Long)map.get("minute")).intValue(), ((Long)map.get("second")).intValue(), ((Long)map.get("nano")).intValue());
            }
            if (OffsetDateTime.class.equals(pojoClass)) {
                String zoneOffsetId = (String)((Map)map.get("offset")).get("id");
                return (T)OffsetDateTime.of(((Long)map.get("year")).intValue(), ((Long)map.get("monthValue")).intValue(), ((Long)map.get("dayOfMonth")).intValue(), ((Long)map.get("hour")).intValue(), ((Long)map.get("minute")).intValue(), ((Long)map.get("second")).intValue(), ((Long)map.get("nano")).intValue(), ZoneOffset.of(zoneOffsetId));
            }
            if (ZonedDateTime.class.equals(pojoClass)) {
                String zoneId = (String)((Map)map.get("zone")).get("id");
                return (T)ZonedDateTime.of(((Long)map.get("year")).intValue(), ((Long)map.get("monthValue")).intValue(), ((Long)map.get("dayOfMonth")).intValue(), ((Long)map.get("hour")).intValue(), ((Long)map.get("minute")).intValue(), ((Long)map.get("second")).intValue(), ((Long)map.get("nano")).intValue(), ZoneId.of(zoneId));
            }
            if (Date.class.isAssignableFrom(pojoClass)) {
                long epochMilli = (Long)map.get("time");
                return (T)new Date(epochMilli);
            }
            if (!Modifier.isPublic(pojoClass.getModifiers())) {
                throw new IllegalAccessException(String.format("%s should be public", pojoClass));
            }
            Constructor[] allConstructors = pojoClass.getDeclaredConstructors();
            if (Util.getPublicParameterlessConstructors(allConstructors).count() == 1L) {
                return (T)Util.constructViaPublicParameterlessConstructor(pojoClass, map);
            }
            Constructor[] constructors = Util.getSuitablePublicParametrizedConstructors(allConstructors, map);
            if (constructors.length == 1) {
                return (T)Util.constructViaPublicParametrizedConstructor(constructors[0], map);
            }
            throw new IllegalAccessException(String.format("%s should have a public parameterless constructor or a public constructor with %d parameters", pojoClass, map.keySet().size()));
        }
        catch (IntrospectionException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReqlDriverError("Can't convert %s to a POJO: %s", map, e.getMessage());
        }
    }

    private static Stream<Constructor> getPublicParameterlessConstructors(Constructor[] constructors) {
        return Arrays.stream(constructors).filter(constructor -> Modifier.isPublic(constructor.getModifiers()) && constructor.getParameterCount() == 0);
    }

    private static Object constructViaPublicParameterlessConstructor(Class pojoClass, Map<String, Object> map) throws IllegalAccessException, InstantiationException, IntrospectionException, InvocationTargetException {
        Object pojo = pojoClass.newInstance();
        BeanInfo info = Introspector.getBeanInfo(pojoClass);
        for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
            Method writer;
            String propertyName = descriptor.getName();
            if (!map.containsKey(propertyName) || (writer = descriptor.getWriteMethod()) == null || writer.getDeclaringClass() != pojoClass) continue;
            Object value = map.get(propertyName);
            Class<?> valueClass = writer.getParameterTypes()[0];
            String listItemClassName = null;
            if (value instanceof List) {
                String genName = descriptor.getWriteMethod().getGenericParameterTypes()[0].getTypeName();
                int len = valueClass.getName().length();
                int genLen = genName.length();
                if (genLen > len + 2 && genName.charAt(len) == '<' && genName.charAt(genLen - 1) == '>') {
                    listItemClassName = genName.substring(len + 1, genLen - 1);
                }
            }
            writer.invoke(pojo, value instanceof Map ? Util.toPojo(valueClass, (Map)value) : Util.smartCast(valueClass, value, listItemClassName));
        }
        return pojo;
    }

    private static Object smartCast(Class valueClass, Object value, String listItemClassName) {
        try {
            value = valueClass.cast(value);
            if (listItemClassName != null && value instanceof List) {
                Class<?> innerClass = null;
                try {
                    innerClass = Class.forName(listItemClassName);
                }
                catch (ClassNotFoundException e) {
                    e = e;
                }
                if (innerClass != null) {
                    List list = (List)value;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        Object obj = list.get(i);
                        Object convertedObj = Util.convertToPojo(obj, innerClass);
                        if (convertedObj == obj) continue;
                        list.set(i, convertedObj);
                    }
                }
            }
            return value;
        }
        catch (ClassCastException ex) {
            if (valueClass.isEnum()) {
                try {
                    return Enum.valueOf(valueClass, value.toString());
                }
                catch (IllegalArgumentException e) {
                    return Enum.valueOf(valueClass, value.toString().toUpperCase());
                }
            }
            if (OffsetDateTime.class.equals((Object)valueClass)) {
                return OffsetDateTime.ofInstant(Util.parseDate(value), ZoneId.systemDefault());
            }
            if (LocalDateTime.class.equals((Object)valueClass)) {
                return LocalDateTime.ofInstant(Util.parseDate(value), ZoneId.systemDefault());
            }
            if (LocalDate.class.equals((Object)valueClass)) {
                return LocalDateTime.ofInstant(Util.parseDate(value), ZoneId.systemDefault()).toLocalDate();
            }
            if (LocalTime.class.equals((Object)valueClass)) {
                try {
                    return LocalTime.parse(value.toString());
                }
                catch (DateTimeParseException e) {
                    throw new ClassCastException("Can not convert \"" + value + "\" to LocalTime. Valid data samples: 23:59:59.007");
                }
            }
            if (ZonedDateTime.class.equals((Object)valueClass)) {
                return ZonedDateTime.ofInstant(Util.parseDate(value), ZoneId.systemDefault());
            }
            if (Boolean.class.equals((Object)valueClass) || Boolean.TYPE.equals(valueClass)) {
                return Boolean.valueOf(value.toString());
            }
            if (Integer.class.equals((Object)valueClass) || Integer.TYPE.equals(valueClass)) {
                return Integer.valueOf(value.toString());
            }
            if (Long.class.equals((Object)valueClass) || Long.TYPE.equals(valueClass)) {
                return Double.valueOf(value.toString()).longValue();
            }
            if (Double.class.equals((Object)valueClass) || Double.TYPE.equals(valueClass)) {
                return Double.valueOf(value.toString());
            }
            if (Float.class.equals((Object)valueClass) || Float.TYPE.equals(valueClass)) {
                return Float.valueOf(value.toString());
            }
            if (Short.class.equals((Object)valueClass) || Short.TYPE.equals(valueClass)) {
                return Short.valueOf(value.toString());
            }
            if (Byte.class.equals((Object)valueClass) || Byte.TYPE.equals(valueClass)) {
                return Byte.valueOf(value.toString());
            }
            if (BigDecimal.class.isAssignableFrom(valueClass)) {
                return new BigDecimal(value.toString());
            }
            if (BigInteger.class.isAssignableFrom(valueClass)) {
                return new BigInteger(value.toString());
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                return new Date(Util.parseDate(value).toEpochMilli());
            }
            if (valueClass.isArray() && value instanceof List) {
                List list = (List)value;
                int len = list.size();
                Class<?> aryComponentType = valueClass.getComponentType();
                Object[] ary = (Object[])Array.newInstance(aryComponentType, list.size());
                for (int i = 0; i < len; ++i) {
                    ary[i] = Util.convertToPojo(list.get(i), aryComponentType);
                }
                return ary;
            }
            throw ex;
        }
    }

    private static Instant parseDate(Object value) {
        try {
            return Instant.ofEpochMilli((Long)value);
        }
        catch (ClassCastException e) {
            String sValue = value.toString();
            try {
                return LocalDate.parse(sValue).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            }
            catch (DateTimeParseException e1) {
                try {
                    return LocalDateTime.parse(sValue).atZone(ZoneId.systemDefault()).toInstant();
                }
                catch (DateTimeParseException e2) {
                    try {
                        return OffsetDateTime.parse(sValue).toInstant();
                    }
                    catch (DateTimeParseException e3) {
                        try {
                            return ZonedDateTime.parse(value.toString()).toInstant();
                        }
                        catch (DateTimeParseException e4) {
                            try {
                                return dtf.parse(sValue).toInstant();
                            }
                            catch (ParseException e5) {
                                throw new ClassCastException("Can not convert \"" + sValue + "\" to date related type. Valid data samples: 2016-03-16, 2016-03-16T09:58:59, 2016-03-16T09:58:59.007, 2016-03-16T09:58:59.007+09:00, Sat Dec 30 09:58:59 JST 2016");
                            }
                        }
                    }
                }
            }
        }
    }

    private static Constructor[] getSuitablePublicParametrizedConstructors(Constructor[] allConstructors, Map<String, Object> map) {
        return (Constructor[])Arrays.stream(allConstructors).filter(constructor -> Modifier.isPublic(constructor.getModifiers()) && Util.areParametersMatching(constructor.getParameters(), map)).toArray(Constructor[]::new);
    }

    private static boolean areParametersMatching(Parameter[] parameters, Map<String, Object> values) {
        return Arrays.stream(parameters).allMatch(parameter -> values.containsKey(parameter.getName()) && values.get(parameter.getName()).getClass() == parameter.getType());
    }

    private static Object constructViaPublicParametrizedConstructor(Constructor constructor, Map<String, Object> map) throws IllegalAccessException, InstantiationException, IntrospectionException, InvocationTargetException {
        Object[] values = Arrays.stream(constructor.getParameters()).map(parameter -> {
            Object value = map.get(parameter.getName());
            return value instanceof Map ? Util.toPojo(value.getClass(), (Map)value) : value;
        }).toArray();
        return constructor.newInstance(values);
    }
}

