/*
 * Decompiled with CFR 0.152.
 */
package org.summerb.i18n;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.summerb.i18n.HasMessageArgs;
import org.summerb.i18n.HasMessageArgsConverters;
import org.summerb.i18n.HasMessageCode;
import org.summerb.i18n.MessageArgConverter;

public abstract class I18nUtils {
    public static String buildMessage(HasMessageCode hasMessageCode, MessageSource messageSource, Locale locale) {
        try {
            Object[] args = null;
            if (hasMessageCode instanceof HasMessageArgs) {
                args = ((HasMessageArgs)((Object)hasMessageCode)).getMessageArgs();
            }
            MessageArgConverter[] argsConverters = null;
            if (hasMessageCode instanceof HasMessageArgsConverters) {
                argsConverters = ((HasMessageArgsConverters)((Object)hasMessageCode)).getMessageArgsConverters();
            }
            if (args != null && argsConverters != null) {
                I18nUtils.applyArgsConversion(hasMessageCode, args, argsConverters, messageSource, locale);
            }
            return I18nUtils.getMessage(hasMessageCode.getMessageCode(), args, messageSource, locale);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to build message", t);
        }
    }

    protected static void applyArgsConversion(HasMessageCode hasMessageCode, Object[] args, MessageArgConverter[] argsConverters, MessageSource messageSource, Locale locale) {
        for (int i = 0; i < args.length && argsConverters.length >= i + 1; ++i) {
            if (argsConverters[i] == null) continue;
            args[i] = args[i] == null ? "(null)" : argsConverters[i].convert(args[i], hasMessageCode, messageSource, locale);
        }
    }

    protected static String getMessage(String messageCode, Object[] args, MessageSource messageSource, Locale locale) {
        try {
            return messageSource.getMessage(messageCode, args, locale);
        }
        catch (NoSuchMessageException nsme) {
            return messageCode;
        }
    }
}

