/*
 * Decompiled with CFR 0.152.
 */
package org.summerb.i18n.exceptions.dto;

import java.io.Serializable;
import org.summerb.i18n.HasMessageArgs;
import org.summerb.i18n.HasMessageCode;
import org.summerb.i18n.exceptions.HasErrorDescriptionObject;
import org.summerb.utils.DtoBase;

public class ExceptionInfo
implements DtoBase {
    private static final long serialVersionUID = 1857628060664652023L;
    private String exceptionClassName;
    private String message;
    private String messageCode;
    private Object[] messageArgs;
    private Serializable errorDescriptionObject;
    private ExceptionInfo cause;

    public ExceptionInfo() {
    }

    public ExceptionInfo(Throwable t) {
        this.exceptionClassName = t.getClass().getName();
        this.message = t.getMessage();
        if (t instanceof HasMessageCode) {
            this.messageCode = ((HasMessageCode)((Object)t)).getMessageCode();
        }
        if (t instanceof HasMessageArgs) {
            this.messageArgs = ((HasMessageArgs)((Object)t)).getMessageArgs();
        }
        if (t instanceof HasErrorDescriptionObject) {
            this.errorDescriptionObject = ((HasErrorDescriptionObject)((Object)t)).getErrorDescriptionObject();
        }
        if (t.getCause() != null && t.getCause() != t) {
            this.cause = new ExceptionInfo(t.getCause());
        }
    }

    public boolean isExceptionClass(Class<? extends Throwable> clazz) {
        try {
            Class<?> current = Class.forName(this.exceptionClassName);
            return clazz.isAssignableFrom(current);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(Object[] messageArgs) {
        this.messageArgs = messageArgs;
    }

    public Serializable getErrorDescriptionObject() {
        return this.errorDescriptionObject;
    }

    public void setErrorDescriptionObject(Serializable errorDescriptionObject) {
        this.errorDescriptionObject = errorDescriptionObject;
    }

    public ExceptionInfo getCause() {
        return this.cause;
    }

    public void setCause(ExceptionInfo cause) {
        this.cause = cause;
    }
}

