/*
 * Decompiled with CFR 0.152.
 */
package dswork.http;

import dswork.http.Cookie;
import dswork.http.NameFile;
import dswork.http.NameValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpCommon {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM y HH:mm:ss 'GMT'", Locale.US);
    private static final TrustManager tm = new TM();
    public static final HostnameVerifier HV = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String PARAMETER_SEPARATOR = "&";
    private static byte[] B_T = new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 68, 105, 115, 112, 111, 115, 105, 116, 105, 111, 110, 58, 32, 102, 111, 114, 109, 45, 100, 97, 116, 97, 59, 32, 110, 97, 109, 101, 61, 34};
    private static byte[] B_M = new byte[]{34, 59, 32, 102, 105, 108, 101, 110, 97, 109, 101, 61, 34};
    private static byte[] B_D = new byte[]{34};
    private static byte[] B_C = new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 84, 121, 112, 101, 58, 32};
    private static byte[] B_RN = new byte[]{13, 10};
    private static byte[] B_JJ = new byte[]{45, 45};
    private static byte[] B_BOUNDARY = new byte[]{45, 45, 45, 45, 87, 101, 98, 75, 105, 116, 70, 111, 114, 109, 66, 111, 117, 110, 100, 97, 114, 121, 70, 111, 114, 68, 115, 119, 111, 114, 107, 65, 98, 99, 100, 101, 102, 103};

    private static Date convertGMT(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.indexOf("-") == 7) {
                string = string.substring(0, 7) + " " + string.substring(8, 11) + " " + string.substring(12, string.length());
            }
            if (!string.endsWith("GMT") && string.lastIndexOf(" ") >= 23) {
                string = string.substring(0, string.lastIndexOf(" ")) + " GMT";
            }
            return sdf.parse(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final TrustManager[] getTrustManager() {
        return new TrustManager[]{tm};
    }

    public static String format(List<? extends NameValue> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (NameValue nameValue : list) {
            if (nameValue.isFormdata()) continue;
            try {
                String string2 = URLEncoder.encode(nameValue.getName(), string);
                String string3 = URLEncoder.encode(nameValue.getValue(), string);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(PARAMETER_SEPARATOR);
                }
                stringBuilder.append(string2);
                if (string3 == null) continue;
                stringBuilder.append(NAME_VALUE_SEPARATOR);
                stringBuilder.append(string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] formatFormdata(List<? extends NameValue> list, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byteArrayOutputStream.write(B_JJ);
        byteArrayOutputStream.write(B_BOUNDARY);
        for (NameValue nameValue : list) {
            byteArrayOutputStream.write(B_RN);
            byteArrayOutputStream.write(B_T);
            byteArrayOutputStream.write(nameValue.getName().getBytes(string));
            if (nameValue.isFormdata()) {
                NameFile nameFile = (NameFile)nameValue;
                byteArrayOutputStream.write(B_M);
                byteArrayOutputStream.write(nameFile.getFilename().getBytes(string));
                byteArrayOutputStream.write(B_D);
                byteArrayOutputStream.write(B_RN);
                byteArrayOutputStream.write(B_C);
                byteArrayOutputStream.write(nameFile.getContenttype().getBytes(string));
                byteArrayOutputStream.write(B_RN);
                byteArrayOutputStream.write(B_RN);
                byteArrayOutputStream.write(nameFile.getFileobject());
            } else {
                byteArrayOutputStream.write(B_D);
                byteArrayOutputStream.write(B_RN);
                byteArrayOutputStream.write(B_RN);
                byteArrayOutputStream.write(nameValue.getValue().getBytes(string));
            }
            byteArrayOutputStream.write(B_RN);
            byteArrayOutputStream.write(B_JJ);
            byteArrayOutputStream.write(B_BOUNDARY);
        }
        byteArrayOutputStream.write(B_JJ);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String parse(List<? extends Cookie> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Cookie cookie : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(cookie.getName());
            if (cookie.getValue() == null) continue;
            stringBuilder.append(NAME_VALUE_SEPARATOR);
            stringBuilder.append(cookie.getValue());
        }
        return stringBuilder.toString();
    }

    private static List<Cookie> getHttpCookies(String string) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        if (string != null && string.length() > 0) {
            Date date = new Date();
            String[] stringArray = string.split(";");
            String[] stringArray2 = stringArray[0].split(NAME_VALUE_SEPARATOR, 2);
            Cookie cookie = stringArray2.length == 1 ? new Cookie(stringArray2[0], "") : new Cookie(stringArray2[0], stringArray2[1]);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<NameValue> arrayList2 = new ArrayList<NameValue>();
            String string2 = null;
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = stringArray[i].trim();
                try {
                    stringArray2 = string2.split(NAME_VALUE_SEPARATOR, 2);
                    arrayList2.add(new NameValue(stringArray2[0].toLowerCase(Locale.ROOT), stringArray2[1]));
                    hashMap.put(stringArray2[0].toLowerCase(Locale.ROOT), stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    if (string2.equalsIgnoreCase("secure")) {
                        cookie.setSecure(true);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("httponly")) continue;
                    cookie.setHttpOnly(true);
                }
            }
            String string3 = (String)hashMap.get("expires");
            if (string3 != null) {
                cookie.setExpiryDate(HttpCommon.convertGMT(string3));
            }
            if ((string3 = (String)hashMap.get("max-age")) != null) {
                try {
                    long l = Long.parseLong(string3);
                    cookie.setExpiryDate(new Date(date.getTime() + l));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (cookie.getExpiryDate() == null || !cookie.isExpired(date)) {
                string3 = (String)hashMap.get("path");
                if (string3 != null) {
                    cookie.setPath(string3);
                }
                if ((string3 = (String)hashMap.get("domain")) != null && cookie.getExpiryDate() != null) {
                    cookie.setDomain(string3);
                }
            }
            arrayList.add(cookie);
        }
        return arrayList;
    }

    public static List<Cookie> getHttpCookies(Map<String, List<String>> map) {
        String string = null;
        if (map != null && map.get("set-cookie") != null) {
            string = map.get("set-cookie").get(0);
        }
        return HttpCommon.getHttpCookies(string);
    }

    public static List<Cookie> getHttpCookies(HttpURLConnection httpURLConnection) {
        String string = null;
        String string2 = null;
        int n = 1;
        while ((string2 = httpURLConnection.getHeaderFieldKey(n)) != null) {
            try {
                if (string2.equalsIgnoreCase("set-cookie")) {
                    string = httpURLConnection.getHeaderField(n);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        return HttpCommon.getHttpCookies(string);
    }

    public static void refreshCookies(List<Cookie> list) {
        Date date = new Date();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.get(i).isExpired(date)) continue;
            list.remove(i);
        }
    }

    public static List<Cookie> getHttpCookies(List<Cookie> list, boolean bl) {
        List<Cookie> list2;
        HttpCommon.refreshCookies(list);
        if (bl) {
            list2 = list;
        } else {
            list2 = new ArrayList<Cookie>();
            for (Cookie cookie : list) {
                if (cookie.isSecure()) continue;
                list2.add(cookie.clone());
            }
        }
        return list2;
    }

    private static class TM
    implements TrustManager,
    X509TrustManager {
        private TM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }
}

